<?php 
class Ordering extends CI_Controller{
	function index()
	{
		$result = $this->find_all();
		echo json_encode($result);
	}
	
	function header_data()
	{
		$outlet_id = $this->session->userdata('outlet_id');
		
		$this->load->model('outlets');
		$data = array();
		$data['outlet_name'] = $this->outlets->getOutletName($outlet_id);
		$data['order_date']  = $this->outlets->getOrderDate($outlet_id);
		$data['created_at']  = date("Y-m-d H:i:s");

		echo json_encode($data);	
	}
	
	function save()
	{
		$data = json_decode($this->input->post('json'));
		$pk = isset($data->pk) ? $data->pk : '';
		$order_date = $data->order_date;
		$details = $data->details;
		
		$this->db->trans_begin();
		$code = '';
		if($pk == '')
			$pk = $this->create_new_order($order_date, $code);
		
		$this->create_order_menus($details, $pk);
		header("Content-Type: application/json", true);
		if ($this->db->trans_status() === FALSE)
		{
		    $this->db->trans_rollback();
		    echo json_encode(array('status'=>'failed'));
		}
		else
		{
			$log_history = array('treatment' =>'create' ,'date_time' =>date("Y-m-d H:i:s"),'author_id'=>$this->session->userdata('author_id'),
			'datatable'=>'order product','closing_date'=>$order_date,'outlet_id'=>$this->session->userdata('outlet_id'));
			$this->db->insert('log_history',$log_history);

		    $this->db->trans_commit();
			echo json_encode(array('status'=>'success', 'pk'=>$pk, 'code'=>$code));
		}
	}
	
	function create_new_order($order_date, &$code)
	{
		$this->load->model('outlets');
		$new_order  = array(
			'code' => $this->generate($this->session->userdata('outlet_id')), 
			'order_date' => $order_date,
			'closing_date' => $this->outlets->getClosingDate($this->session->userdata('outlet_id')),
			'outlet_id' => $this->session->userdata('outlet_id'), 
			'status' => 'new',
			'author_id' => $this->session->userdata('author_id'), 
			'created_at' => date("Y-m-d H:i:s"), 
		);
		
		$this->db->insert('outlet_order_product', $new_order);
		$code = $new_order['code'];
		return $this->db->insert_id();
	}

	function create_order_menus($detail, $id)
	{
		$this->db->where('order_id', $id);
		$this->db->delete('outlet_order_product_menus');
		
		foreach ($detail as $d)
		{
			$this->db->insert('outlet_order_product_menus', array(
					'order_id' => $id,
					'menu_id' => $d->menu_id,
					'qty' => $d->qty
				));
		}
	}
	
	function generateOrder($id)
	{
		$this->db->where('order_id', $id);
		if($this->db->count_all_results('outlet_order_product_menus') > 0)
		{
			$this->db->where('order_id', $id);
			if($this->db->count_all_results('outlet_order_product_details') == 0)
			{
				$qry_res = $this->db->query("CALL sp_order_menu_breakdown (".$id.")");
				$qry_res->next_result();
				$qry_res->free_result();
			}
			
			$sql = "SELECT A.product_id, B.product_code, B.product_name, A.unit_large, A.unit_small, A.conversion, A.qty_system, A.qty
					FROM `outlet_order_product_details` A INNER JOIN `master_products` B ON A.product_id = B.product_id
					WHERE A.order_id = ".$id."
					ORDER BY B.product_name";
			$result = $this->db->query($sql)->result();
			
			$sql = "SELECT A.*, B.outlets_code, B.outlets_name
					FROM `outlet_order_product` A INNER JOIN `master_outlets` B ON A.outlet_id = B.outlets_id
					WHERE A.id = ".$id;
			$header = $this->db->query($sql)->row();
			
			echo json_encode(array('header'=>$header, 'details'=>$result));
		}
	}
	
	function updateDetails($id)
	{
		$data = json_decode($this->input->post('json'));
		
		$this->db->trans_begin();
		$this->update_order_details($data, $id);
		
		header("Content-Type: application/json", true);
		if ($this->db->trans_status() === FALSE)
		{
		    $this->db->trans_rollback();
		    echo json_encode(array('status'=>'failed'));
		}
		else
		{
			/*$log_history = array('treatment' =>'create' ,'date_time' =>date("Y-m-d H:i:s"),'author_id'=>$this->session->userdata('author_id'),
			'datatable'=>'order product','closing_date'=>$order_date,'outlet_id'=>$this->session->userdata('outlet_id'));
			$this->db->insert('log_history',$log_history);*/

		    $this->db->trans_commit();
			echo json_encode(array('status'=>'success'));
		}
	}
	
	function update_order_details($detail, $id)
	{
		foreach ($detail as $d)
		{
			$this->db->where('order_id', $id);
			$this->db->where('product_id', $d->product_id);
			if($this->db->count_all_results('outlet_order_product_details') > 0)
			{
				$this->db->where('order_id', $id);
				$this->db->where('product_id', $d->product_id);
				$this->db->update('outlet_order_product_details', array('qty' => $d->qty));
			} else 
			{
				$this->db->insert('outlet_order_product_details', array(
					'order_id' => $id,
					'product_id' => $d->product_id,
					'unit_large' => $d->unit_large,
					'unit_small' => $d->unit_small,
					'conversion' => $d->conversion,
					'qty_system' => 0,
					'qty' => $d->qty
				));
			}
		}
	}
	
	function viewOrder($id, $oid=0)
	{
		$this->load->model('outlets');
		$sql = "SELECT id, `code` AS KdOrderProduksi, DATE_FORMAT(order_date, '%d/%m/%Y') AS TglOrderProduksi
				FROM `outlet_order_product` A INNER JOIN `master_outlets` B ON A.outlet_id = B.outlets_id
				WHERE closing_date = '".$this->outlets->getClosingDate($id)."' and outlet_id = ".$id." and status = 'new'
				ORDER BY `code` desc";
		$result = $this->db->query($sql)->result();
		
		if($oid == 0 && count($result) > 0)
			$oid = $result[0]->id;
		
		$sql = "SELECT `code` AS KdOrderProduksi, product_code AS KdBarang, product_name AS NmBarang, qty AS QtyOrderProduksi, C.unit_large AS SatuanOrder 
				FROM `outlet_order_product` A INNER JOIN `outlet_order_product_details` B ON A.id = B.order_id
					INNER JOIN `master_products` C ON B.product_id = C.product_id
				WHERE order_id = ".$oid." and status = 'new'
				ORDER BY `code` desc";
		$result2 = $this->db->query($sql)->result();
		
		$this->load->view('order', array('orders'=>$result, 'details'=>$result2, 'id'=>$id, 'oid'=>$oid));
	}
	
	function getHeaderData($id)
	{
		$HFields = array('KdOrderProduksi', 'TglOrderProduksi', 'KdOutlet', 'UserID', 'StatusOrder');		
		$HLastElement = end($HFields);
		
		$this->load->model('outlets');
		$sql = "SELECT `code` AS KdOrderProduksi, DATE_FORMAT(order_date, '%d/%m/%Y') AS TglOrderProduksi, other_code AS KdOutlet, outlets_code AS UserID, 'F' AS StatusOrder
				FROM `outlet_order_product` A INNER JOIN `master_outlets` B ON A.outlet_id = B.outlets_id
				WHERE closing_date = '".$this->outlets->getClosingDate($id)."' and outlet_id = ".$id." and status = 'new'
				ORDER BY `code` desc";
		$result = $this->db->query($sql)->result_array();
		
		if(count($result) > 0)
		{
			foreach($HFields as $field)
			{
				echo $field;
				if(!($field == $HLastElement))
					echo chr(9);
			}
			echo "\n";
			
			$statuses = array('T', 'F', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I');
			$i = 0;
			foreach($result as $row)
			{
				foreach($HFields as $field)
				{
					if($field == $HLastElement)
						echo $statuses[$i];
					else echo $row[$field];
					
					if(!($field == $HLastElement))
						echo chr(9);
				}
				echo "\n";
				$i++;
			}
		} else 
			echo '';
	}
	
	function getDetailData($id)
	{
		$DFields = array('KdOrderProduksi', 'SeqOrder', 'KdBarang', 'QtyOrderProduksi', 'SatuanOrder', 'CatatanOrder', 'Stok', 'SuggestiveOrder', 'StokK', 'StokFB', 'StokFK');
		$DLastElement = end($DFields);
		
		$this->load->model('outlets');
		$sql = "SELECT `code` AS KdOrderProduksi, product_code AS KdBarang, qty AS QtyOrderProduksi, C.unit_large AS SatuanOrder, '' AS CatatanOrder, 0 AS 'Stok', 0 AS 'SuggestiveOrder', 0 AS 'StokK', 0 AS 'StokFB', 0 AS 'StokFK' 
				FROM `outlet_order_product` A INNER JOIN `outlet_order_product_details` B ON A.id = B.order_id
					INNER JOIN `master_products` C ON B.product_id = C.product_id
				WHERE closing_date = '".$this->outlets->getClosingDate($id)."' and outlet_id = ".$id." and status = 'new'
				ORDER BY `code` desc";
		$result = $this->db->query($sql)->result_array();

		if(count($result) > 0)
		{
			foreach($DFields as $field)
			{
				echo $field;
				if(!($field == $DLastElement))
					echo chr(9);
			}
			echo "\n";
			
			$code = '';
			foreach($result as $row)
			{
				if($code == $row['KdOrderProduksi'])
					$seq += 1;
				else {
					$seq = 1;
					$code = $row['KdOrderProduksi'];
				}
				
				foreach($DFields as $field)
				{
					if($field == 'SeqOrder')
						echo $seq;
					else
						echo $row[$field];
					if(!($field == $DLastElement))
						echo chr(9);
				}
				echo "\n";
			}
		} else 
			echo '';
	}
	
	function getDetailMenuData($id)
	{
		$DFields = array('KdOrderProduksi', 'KdMenu', 'Jumlah');
		$DLastElement = end($DFields);
		
		$this->load->model('outlets');
		$sql = "SELECT `code` AS KdOrderProduksi, menu_code AS KdMenu, qty AS Jumlah 
				FROM `outlet_order_product` A INNER JOIN `outlet_order_product_menus` B ON A.id = B.order_id
					INNER JOIN `master_menus` C ON B.menu_id = C.menu_id
				WHERE closing_date = '".$this->outlets->getClosingDate($id)."' and outlet_id = ".$id." and status = 'new'
				ORDER BY `code` desc";
		$result = $this->db->query($sql)->result_array();

		if(count($result) > 0)
		{
			foreach($DFields as $field)
			{
				echo $field;
				if(!($field == $DLastElement))
					echo chr(9);
			}
			echo "\n";
			
			$code = '';
			foreach($result as $row)
			{
				foreach($DFields as $field)
				{
					echo $row[$field];
					if(!($field == $DLastElement))
						echo chr(9);
				}
				echo "\n";
			}
		} else 
			echo '';
	}
	
	function updateStatusData($id)
	{
		$this->load->model('outlets');
		$sql = "UPDATE `outlet_order_product` SET status = 'sent' WHERE closing_date = '".$this->outlets->getClosingDate($id)."' and outlet_id = ".$id." and status = 'new'";
		$result = $this->db->query($sql);
	}
	
	function find_all()
	{
		$this->load->model('outlets');
		$sql = "SELECT A.*, CASE WHEN B.total_item IS NULL THEN 0 ELSE B.total_item END AS total_item
				FROM outlet_order_product A LEFT JOIN ( SELECT order_id, count(*) AS total_item FROM outlet_order_product_details GROUP BY order_id) B ON A.id = B.order_id
				WHERE outlet_id = ".$this->session->userdata('outlet_id')." and order_date > '".$this->outlets->getClosingDate($this->session->userdata('outlet_id'))."'
				ORDER BY id desc";
		return $this->db->query($sql)->result();
	}

	function findby_pk($id){
		$this->db->trans_begin();
		$sql = "select * from outlet_order_product where outlet_id = ".$this->session->userdata('outlet_id')." and id = ".$id." ";
		$header = $this->db->query($sql);
		$person = $header->row();
		$person->author_name = $this->get_author($person->author_id);
		$data['body'] = $this->get_order_detail($id);
		$data['bodyMenu'] = $this->get_order_detailMenu($id);
		$data['header'] = $person;
		echo json_encode($data);
	}
	
	function get_author($id){
		$sql = "select full_name from user_apps where id = ".$id;
		$person = $this->db->query($sql);
		if ($person->num_rows() >0) {
			return $person->row()->full_name;
		}else{
			return "-";
		}
	}
	
	function get_order_detail($id){
		$sql = "select d.*, p.* from outlet_order_product_details d inner join master_products p on (d.product_id = p.product_id) where d.order_id = ".$id;
		//$sql = "select d.*, p.* from outlet_order_product_details d inner join master_products p on (d.product_id = p.product_id) where p.category_id='10' and d.order_id =".$id;
		$data = $this->db->query($sql)->result();
		return $data;
	}
	
	function get_order_detailMenu($id){
		$sql = "select d.*, p.menu_code, p.menu_name from outlet_order_product_menus d inner join master_menus p on (d.menu_id = p.menu_id) where d.order_id = ".$id;
		//$sql = "select d.*, p.menu_code, p.menu_name from outlet_order_product_menus d inner join master_menus p on (d.menu_id = p.menu_id) where p.category_id='10' and d.order_id =".$id;
		$data = $this->db->query($sql)->result();
		return $data;
	}
	
	function generate($_outlet_id){
		$year = date("Y");
        $month = date("m");
		
		$this->load->model('outlets');
		$code = "OP-".$this->outlets->getOutletCode($_outlet_id).'-';

		$select = "select count(id) as total from outlet_order_product where MONTH(created_at) = $month and YEAR(created_at) = $year AND code like '".$code."%'";
		$data = $this->db->query($select)->row();
		
		return $code.substr($year, 2)."".$month."".$this->get_zero($data->total+1);
	}

	function get_zero($id){
		$zero = "";
		for ($i=0; $i < 4-strlen($id.""); $i++) { 
			$zero.="0";
		}
		return $zero.$id;
	}

	function order_send()
	{
		$outlet_id = $this->session->userdata('outlet_id');
		$closing_date = $this->outlets->getClosingDate($outlet_id);

		$sql = "SELECT id, code, order_date
				FROM `outlet_order_product`
				WHERE closing_date = '".$closing_date."' AND A.outlet_id = ".$outlet_id." AND status = 'new' 
				ORDER BY id";

		$orders = $this->db->query($sql)->result();

		foreach($orders as $order)
		{
			$data = array();
			$result = $this->db->insert('wh_sales_order',$data);
			$so_id = $this->db->insert_id();

			$sql = "INSERT INTO `wh_sales_order_detail` (so_id, product_id, qty) 
					SELECT ".$so_id." AS so_id, product_id, SUM(qty) AS qty
					FROM `outlet_order_product_details`
					WHERE order_id = ".$order['id']."
					GROUP BY product_id";
			$result = $this->db->query($sql)->execute();
		}
	}
}
?>