<?php /**
* 
*/
class Auto_Report extends CI_Controller
{
	function index()
	{
		//$year = date('Y');
		//$month = date('m');
		$current = new DateTime();
		$current->sub(new DateInterval("P1D"));
		
		$year = $current->format('Y');
		$month = $current->format('m');
		$date = $current->format('d');
		
		$start = new DateTime($year.'-'.$month.'-1');
		$lastDate = $start->format('t')*1;
		$end = new DateTime($year.'-'.$month.'-'.$lastDate);

		$_newDate = clone $start;
		$fields = array();
		$_sql = '';
		while($_newDate <= $end)
		{
			$fields[] = array('code'=>'q'.$_newDate->format('d'), 'title'=>$_newDate->format('d'));
			$_sql .= ", SUM(CASE WHEN DATE_FORMAT(A.tglClosing,'%Y%m%d') = '".$_newDate->format('Ymd')."' THEN A.JmlPenjualan ELSE 0 END) AS `q".$_newDate->format('d')."`";
			$_newDate->add(new DateInterval("P1D"));
		}
		
		$sql = "SELECT B.outlets_id, B.other_code AS `outlets_code`, B.outlets_name, SUM(A.JmlPenjualan) AS `total` ".$_sql." 
				FROM `outlet_sales_orders` A INNER JOIN `master_outlets` B ON A.KdOutlet = B.other_code
				WHERE A.SdhBayar = 'T' AND YEAR(A.tglClosing) = ".$year." AND MONTH(A.tglClosing) = ".$month." 
				GROUP BY B.outlets_id, B.other_code, B.outlets_name
				ORDER BY B.outlets_name";
		
		$result = $this->db->query($sql)->result();
		
		
		$row = 1;
		$startChar = 'C';
		//load our new PHPExcel library
		$this->load->library('excel');
		//activate worksheet number 1
		$this->excel->setActiveSheetIndex(0);
		//name the worksheet
		$this->excel->getActiveSheet()->setTitle('sheet1');
		//set cell A1 content with some text
		$this->excel->getActiveSheet()->setCellValue('A'.$row, 'Laporan Penjualan Mujigae');
		//change the font size
		$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setSize(16);
		//make the font become bold
		$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setBold(true);

		$row++;
		$this->excel->getActiveSheet()->setCellValue('A'.$row, 'Periode: Juni 2015');
			
		$row+=2;
		$this->excel->getActiveSheet()->setCellValue('A'.$row, 'Kode');
		$this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(8);
		$this->excel->getActiveSheet()->setCellValue('B'.$row, 'Nama Outlet');
		$this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(25);
		$i=$startChar; $j=''; $k='';
		foreach($fields as $field)
		{
			$k = $j.$i;
			$this->excel->getActiveSheet()->setCellValue($k.$row, $field['title']);
			$this->excel->getActiveSheet()->getColumnDimension($k)->setWidth(15);
			if($i == 'Z')
			{
				$i='A';
				$j.=$i;
			} else $i++;
		}
		$this->excel->getActiveSheet()->setCellValue($j.$i.$row, 'Total');
		$this->excel->getActiveSheet()->getColumnDimension($j.$i)->setWidth(15);
		
		$this->excel->getActiveSheet()->getRowDimension($row)->setRowHeight(20);
		$dimension_title = 'A'.$row.':'.$j.$i.$row;
		$objRow = $this->excel->getActiveSheet()->getStyle($dimension_title);
		$objRow->getFont()->setBold(true);
		$objRow->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		$objRow->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
		$objRow->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFb6dde8');
		
		$row++;
		$start_row = $row;
		foreach($result as $data)
		{
			$this->excel->getActiveSheet()->setCellValue('A'.$row, $data->outlets_code);
			$this->excel->getActiveSheet()->setCellValue('B'.$row, $data->outlets_name);
			$this->writeRow($row, $startChar, $fields, $data, $date);
			$row++;
		}
		
		$end_row = $row-1;
		$i=$startChar; $j=''; $k='';
		foreach($fields as $field)
		{
			$k = $j.$i;
			$this->excel->getActiveSheet()->setCellValue($k.$row, '=SUM('.$k.$start_row.':'.$k.$end_row.')');
			if($i == 'Z')
			{
				$i='A';
				$j.=$i;
			} else $i++;
		}
		$this->excel->getActiveSheet()->setCellValue($j.$i.$row, '=SUM('.$startChar.$row.':'.$k.$row.')');
		$this->excel->getActiveSheet()->getStyle($j.$i.($start_row-1).':'.$j.$i.$end_row)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFfde9d9');
		$this->excel->getActiveSheet()->getStyle('A'.$row.':'.$j.$i.$row)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFfde9d9');
		
		$this->excel->getActiveSheet()
					->getStyle($startChar.$start_row.':'.$j.$i.$row)
					->getNumberFormat()
					->setFormatCode('"Rp "#,###');
		
		
		$filepath = '/home/mujigaeapp/incoming/exports/';
		$filename = $filepath.'LaporanPenjualan_'.$year.'_'.$month.'.xls';
		$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5'); 
		$objWriter->save($filename);
		$this->excel->disconnectWorksheets();
		unset($objWriter, $this->excel);
		
		
		$ci = get_instance();
		$ci->load->library('email');
		$config['protocol'] = "smtp";
		$config['smtp_host'] = "ssl://smtp.yandex.com";
		$config['smtp_port'] = "465";
		$config['smtp_user'] = "noreply@mujigae.com"; 
		$config['smtp_pass'] = "Mujigae*499";
		$config['charset'] = "utf-8";
		$config['mailtype'] = "html";
		$config['newline'] = "\r\n";

		$ci->email->initialize($config);

		$ci->email->from('noreply@mujigae.com', 'No Reply');
		$list = array('firman@garudagames.com');
		$list = array('paulin@mujigae.com');
		$ci->email->to($list);
		$ci->email->bcc(array('sarimoon98@gmail.com', 'julis@mujigae.com'));
		$ci->email->subject('Laporan Penjualan Outlet '.$current->format('F Y'));
		$ci->email->message('Laporan Penjualan Outlet '.$current->format('F Y'));
		$ci->email->attach($filename);
		$ci->email->send();
		
		exit;
	}
	
	function writeRow($row, $startChar, $field_array, $data, $cdate)
	{
		$i=$startChar; $j=''; $k='';
		foreach($field_array as $field)
		{
			$k = $j.$i;
			$this->excel->getActiveSheet()->setCellValue($k.$row, $data->$field['code']);
			if('q'.$cdate == $field['code'])
				$this->excel->getActiveSheet()->getStyle($k.$row)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFfde9d9');

			$last = $k;
			if($i == 'Z')
			{
				$i='A';
				$j.=$i;
			} else $i++;
		}
		$this->excel->getActiveSheet()->setCellValue($j.$i.$row, '=SUM(C'.$row.':'.$k.$row.')');
	}

	function sendOrder()
	{
		$order_date = array('2015-10-26', '2015-10-27');
		//$order_date = array('2015-10-16', '2015-10-17', '2015-10-18');
		$data = array(
				/*array('outlet_id' => 1, 	//MCW
					  'mix_date' => array('2015-09-07', '2015-09-08')),
				array('outlet_id' => 6, 	//MSB
					  'mix_date' => array('2015-09-07', '2015-09-08')),
				array('outlet_id' => 8, 	//MKR
					  'mix_date' => array('2015-09-07', '2015-09-08')),
				array('outlet_id' => 7, 	//MSP
					  'mix_date' => array('2015-09-07', '2015-09-08')),
				array('outlet_id' => 2, 	//MFC
					  'mix_date' => array('2015-09-07', '2015-09-08')),
				array('outlet_id' => 5, 	//MGM
					  'mix_date' => array('2015-09-07', '2015-09-08')),*/

				/*array('outlet_id' => 6, 	//MSB
					  'mix_date' => array('2015-09-25', '2015-09-26', '2015-09-27')),
				array('outlet_id' => 8, 	//MKR
					  'mix_date' => array('2015-09-25', '2015-09-26', '2015-09-27')),
				array('outlet_id' => 7, 	//MSP
					  'mix_date' => array('2015-09-25', '2015-09-26', '2015-09-27')),
				array('outlet_id' => 2, 	//MFC
					  'mix_date' => array('2015-09-25', '2015-09-26', '2015-09-27')),
				array('outlet_id' => 1, 	//MCW
					  'mix_date' => array('2015-09-25', '2015-09-26', '2015-09-27')),
				array('outlet_id' => 5, 	//MGM
					  'mix_date' => array('2015-09-25', '2015-09-26', '2015-09-27')),*/

				/*array('outlet_id' => 4, 	//MPV
					  'mix_date' => array('2015-08-22', '2015-08-23', '2015-08-24')),
				array('outlet_id' => 9, 	//MMC
					  'mix_date' => array('2015-08-22', '2015-08-23', '2015-08-24')),
				array('outlet_id' => 3, 	//MKG
					  'mix_date' => array('2015-08-22', '2015-08-23', '2015-08-24')),
				array('outlet_id' => 11, 	//MBB
					  'mix_date' => array('2015-08-22', '2015-08-23', '2015-08-24')),
				array('outlet_id' => 10, 	//MLK
					  'mix_date' => array('2015-08-22', '2015-08-23', '2015-08-24')),*/

				/*array('outlet_id' => 4, 	//MPV
					  'mix_date' => array('2015-09-08', '2015-09-09')),
				array('outlet_id' => 9, 	//MMC
					  'mix_date' => array('2015-09-08', '2015-09-09')),
				array('outlet_id' => 3, 	//MKG
					  'mix_date' => array('2015-09-08', '2015-09-09')),
				array('outlet_id' => 11, 	//MBB
					  'mix_date' => array('2015-09-08', '2015-09-09')),
				array('outlet_id' => 10, 	//MLK
					  'mix_date' => array('2015-09-08', '2015-09-09')),*/
			);

		foreach ($data as $value) {
			$outlet = $this->getOutletInfo($value['outlet_id']);
			$mix_date = $this->renderDate($value['mix_date']);

			$sql = "CALL sp_get_percentmix (".$value['outlet_id'].", '".$mix_date."')";
			$result = $this->db->query($sql)->result();
			
			$filename = 'Mix_'.$outlet->outlets_name.'_'.date('Y-m-d').'.xls';

			$this->export_order($outlet, $value['mix_date'], $order_date, $result, $filename);
		}
	}

	function getOutletInfo($oid)
	{
		$sql = 'select * from master_outlets where outlets_id = '.$oid;
		return $this->db->query($sql)->row();
	}

	function renderDate($mix_date)
	{
		$dateString = '';
		foreach ($mix_date as $date) {
			$dateString .= ($dateString == '' ? '' : ', ')."(''".$date."'')";
		}
		return $dateString;
	}

	function export_order($outlet, $mix_date, $order_date, $result, $filename)
	{
		$row = 1;
		$startChar = 'C';
		//load our new PHPExcel library
		$this->load->library('excel');
		//activate worksheet number 1
		$this->excel->setActiveSheetIndex(0);
		//name the worksheet
		$this->excel->getActiveSheet()->setTitle('sheet1');
		//set cell A1 content with some text
		$this->excel->getActiveSheet()->setCellValue('A'.$row, '% MIX '.$outlet->outlets_name);
		//change the font size
		$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setSize(16);
		//make the font become bold
		$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setBold(true);
			
		$row+=2;

		$this->excel->getActiveSheet()->setCellValue('A'.$row, 'Code');
		$this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
		$this->excel->getActiveSheet()->setCellValue('B'.$row, 'Menu Name');
		$this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(40);
		$this->excel->getActiveSheet()->setCellValue('C'.$row, 'Price');
		$this->excel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
	
		$i='C';
		foreach($mix_date as $datestr)
		{
			$this->excel->getActiveSheet()->setCellValue(++$i.$row, $datestr);
			$this->excel->getActiveSheet()->getColumnDimension($i)->setWidth(10);
		}

		$this->excel->getActiveSheet()->getRowDimension($row)->setRowHeight(20);
		$dimension_title = 'A'.$row.':'.$i.$row;
		$objRow = $this->excel->getActiveSheet()->getStyle($dimension_title);
		$objRow->getFont()->setBold(true);
		$objRow->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		$objRow->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
		$objRow->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFb6dde8');
		
		$row++;
		$start_row = $row;
		$idx = 0;
		foreach($result as $data)
		{
			$this->excel->getActiveSheet()->setCellValue('A'.$row, $data->menu_code);
			$this->excel->getActiveSheet()->setCellValue('B'.$row, $data->menu_name);
			$this->excel->getActiveSheet()->setCellValue('C'.$row, $data->HrgMenu);
			$i='C';
			foreach($mix_date as $datestr)
			{
				$this->excel->getActiveSheet()->setCellValue(++$i.$row, $data->$datestr);
			}
			$row++;
		}
		
		$this->excel->getActiveSheet()
					->getStyle('C'.$start_row.':C'.($row-1))
					->getNumberFormat()
					->setFormatCode('"Rp "#,###');

		$styleArray = array('code' => PHPExcel_Style_NumberFormat::FORMAT_PERCENTAGE_00);
		$this->excel->getActiveSheet()->getStyle('D'.$start_row.':'.$i.$row)->getNumberFormat()->applyFromArray($styleArray);
		unset($styleArray);

		$styleArray = array(
		  'borders' => array(
		    'allborders' => array(
		      'style' => PHPExcel_Style_Border::BORDER_THIN
		    )
		  )
		);

		$this->excel->getActiveSheet()->getStyle('A'.($start_row-1).':'.$i.($row-1))->applyFromArray($styleArray);
		unset($styleArray);
		
		$filepath = realpath(FCPATH).'/exports/orders/'.$filename;

		/*if(file_exists($filepath))
			unlink($filepath);

		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		//header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="'.$filename.'"');
		header('Content-Transfer-Encoding: binary');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		
		$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
		$objWriter->save($filepath);
		echo $fileurl;
		
		$this->excel->disconnectWorksheets();
		unset($objWriter, $this->excel);*/

		$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5'); 
		$objWriter->save($filepath);
		$this->excel->disconnectWorksheets();
		unset($objWriter, $this->excel);
		
		$ci = get_instance();
		$ci->load->library('email');
		$config['protocol'] = "smtp";
		$config['smtp_host'] = "ssl://smtp.yandex.com";
		$config['smtp_port'] = "465";
		$config['smtp_user'] = "noreply@mujigae.com"; 
		$config['smtp_pass'] = "Mujigae*499";
		$config['charset'] = "utf-8";
		$config['mailtype'] = "html";
		$config['newline'] = "\r\n";

		$ci->email->initialize($config);

		$ci->email->from('noreply@mujigae.com', 'No Reply');
		$list = array($outlet->outlets_code.'@mujigae.com');
		$ci->email->to($list);
		$ci->email->cc(array('yuseng@mujigae.com', 'rahadian@mujigae.com', 'budiansyah@mujigae.com', 'firman@garudagames.com'));
		$ci->email->bcc(array('sari@mujigae.com'));
		$ci->email->subject($outlet->outlets_code.' %MIX '.date('Y-m-d'));
		$ci->email->message('Dear RM/Captain,<br><br>
				Berikut saya kirimkan data %mix tanggal '.implode(', ',$mix_date).' 
				untuk acuan order tanggal '.implode(', ', $order_date).' sesuai permintaan.
				<br><br>
				Demikian informasi dari kami,<br>
				<br><br>
				Terima kasih');
		$ci->email->attach($filepath);
		$ci->email->send();
	}
} ?>
