<?php /**
* 
*/
class Report_Payroll extends CI_Controller
{
	function renderParams($data)
	{
		if(isset($data->Reports))
		{
			$variables = array();
			if(isset($data->Reports->outlet_id))
			{
				$this->load->model('outlets');
				$outlet_name = (isset($data->Reports->outlet_id)) && ($data->Reports->outlet_id * 1) > 0 ? $this->outlets->getOutletName($data->Reports->outlet_id) : 'All Outlet';
				$variables['outlet_id'] = $data->Reports->outlet_id;
				$variables['outlet_view'] = $outlet_name;
			}
			$variables['periode_start'] = new DateTime($data->Reports->periode_start);
			$variables['periode_end'] = new DateTime($data->Reports->periode_end);
			$variables['periode_view'] = 'Periode : '.$data->Reports->periode_start.' s.d '.$data->Reports->periode_end;
			if(isset($data->Reports->outlet_id))
				$variables['filename'] = $data->label.($outlet_name == '' ? '' : ' '.$outlet_name).' '.$data->Reports->periode_start.' s.d '.$data->Reports->periode_end.' '.$data->Reports->viewtype.'.xls';
			else 
				$variables['filename'] = $data->label.' '.$data->Reports->periode_start.' s.d '.$data->Reports->periode_end.' '.$data->Reports->viewtype.'.xls';

			return $variables;
		} else die();
	}

	function expense_coa()
	{
		$variables = $this->renderParams(json_decode(file_get_contents('php://input')));

		$filename = $variables['filename'];
		$start = $variables['periode_start'];
		$end = $variables['periode_end'];
		$outlet_id = $variables['outlet_id'];
		$outlet_name = $variables['outlet_view'];
		$periode_view = $variables['periode_view'];

		$sql = "SELECT C.coa, D.coa_description, SUM(CASE B.is_cons_bon WHEN 0 THEN qty * B.price ELSE 0 END) AS Tunai, SUM(CASE B.is_cons_bon WHEN 1 THEN qty * B.price ELSE 0 END) AS ConsBon
				FROM `outlet_purchases` A INNER JOIN `outlet_purchase_details` B ON A.id = B.purchase_id
					INNER JOIN `master_products` C ON B.product_id = C.product_id
				    INNER JOIN `master_coa` D ON C.coa = D.coa
				WHERE A.outlet_id = ".$outlet_id." AND closing_date BETWEEN '".$start->format('Y-m-d')."' AND '".$end->format('Y-m-d')."'
				GROUP BY C.coa, D.coa_description";
		
		$result = $this->db->query($sql)->result();
		
		
		$row = 1;
		$startChar = 'C';
		//load our new PHPExcel library
		$this->load->library('excel');
		//activate worksheet number 1
		$this->excel->setActiveSheetIndex(0);
		//name the worksheet
		$this->excel->getActiveSheet()->setTitle('sheet1');
		//set cell A1 content with some text
		$this->excel->getActiveSheet()->setCellValue('A'.$row, 'Rekap Pembelian Non Produksi Per COA');
		//change the font size
		$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setSize(16);
		//make the font become bold
		$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setBold(true);

		$row++;
		$this->excel->getActiveSheet()->setCellValue('A'.$row, $outlet_name);

		$row++;
		$this->excel->getActiveSheet()->setCellValue('A'.$row, $periode_view);
			
		$row+=2;
		$this->excel->getActiveSheet()->setCellValue('A'.$row, 'No');
		$this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(5);
		$this->excel->getActiveSheet()->setCellValue('B'.$row, 'COA');
		$this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(10);
		$this->excel->getActiveSheet()->setCellValue('C'.$row, 'Nama COA');
		$this->excel->getActiveSheet()->getColumnDimension('C')->setWidth(35);
		$this->excel->getActiveSheet()->setCellValue('D'.$row, 'Tunai');
		$this->excel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
		$this->excel->getActiveSheet()->setCellValue('E'.$row, 'Kontra Bon');
		$this->excel->getActiveSheet()->getColumnDimension('E')->setWidth(15);
		
		
		$this->excel->getActiveSheet()->getRowDimension($row)->setRowHeight(20);
		$dimension_title = 'A'.$row.':E'.$row;
		$objRow = $this->excel->getActiveSheet()->getStyle($dimension_title);
		$objRow->getFont()->setBold(true);
		$objRow->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		$objRow->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
		$objRow->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFb6dde8');
		
		$row++;
		$start_row = $row;
		$idx = 0;
		foreach($result as $data)
		{
			$this->excel->getActiveSheet()->setCellValue('A'.$row, ++$idx);
			$this->excel->getActiveSheet()->setCellValue('B'.$row, $data->coa);
			$this->excel->getActiveSheet()->setCellValue('C'.$row, $data->coa_description);
			$this->excel->getActiveSheet()->setCellValue('D'.$row, $data->Tunai);
			$this->excel->getActiveSheet()->setCellValue('E'.$row, $data->ConsBon);
			$row++;
		}
		
		$end_row = $row-1;
		$objRow = $this->excel->getActiveSheet()->getStyle('A'.$row);
		$objRow->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

		$objRow = $this->excel->getActiveSheet()->getStyle('A'.$row.':E'.$row);
		$objRow->getFont()->setBold(true);

		$this->excel->getActiveSheet()->setCellValue('A'.$row, 'TOTAL');
		$this->excel->getActiveSheet()->mergeCells("A".$row.":C".$row);

		$this->excel->getActiveSheet()->setCellValue('D'.$row, '=SUM(D'.$start_row.':D'.$end_row.')');
		$this->excel->getActiveSheet()->setCellValue('E'.$row, '=SUM(E'.$start_row.':E'.$end_row.')');
		$this->excel->getActiveSheet()->getStyle('A'.$row.':E'.$row)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFfde9d9');

		$this->excel->getActiveSheet()
					->getStyle('D'.$start_row.':E'.$row)
					->getNumberFormat()
					->setFormatCode('"Rp "#,###');
		
		$styleArray = array(
		  'borders' => array(
		    'allborders' => array(
		      'style' => PHPExcel_Style_Border::BORDER_THIN
		    )
		  )
		);

		$this->excel->getActiveSheet()->getStyle('A'.($start_row-1).':E'.$row)->applyFromArray($styleArray);
		unset($styleArray);
		
		$filepath = realpath(FCPATH).'/exports/'.$filename;
		$fileurl = "exports/".$filename;

		if(file_exists($filepath))
			unlink($filepath);

		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		//header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="'.$filename.'"');
		header('Content-Transfer-Encoding: binary');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		
		$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
		$objWriter->save($filepath);
		echo $fileurl;
		
		$this->excel->disconnectWorksheets();
		unset($objWriter, $this->excel);
		
		exit;
	}

	function product_received()
	{
		$variables = $this->renderParams(json_decode(file_get_contents('php://input')));

		$filename = $variables['filename'];
		$start = $variables['periode_start'];
		$end = $variables['periode_end'];
		$outlet_id = $variables['outlet_id'];
		$outlet_name = $variables['outlet_view'];
		$periode_view = $variables['periode_view'];

		$sql = "SELECT A.closing_date, C.product_code, C.product_name, C.unit_large, SUM(B.qty) AS qty, C.cost_of_goods
				FROM `outlet_purchase_receives` A INNER JOIN `outlet_purchase_receive_details` B ON A.id = B.pr_id
					INNER JOIN `master_products` C ON B.product_id = C.product_id
				WHERE A.outlet_id = ".$outlet_id." AND closing_date BETWEEN '".$start->format('Y-m-d')."' AND '".$end->format('Y-m-d')."'
				GROUP BY A.closing_date, C.product_code, C.product_name, C.unit_large, C.cost_of_goods
				ORDER BY A.closing_date, C.product_name";
		
		$result = $this->db->query($sql)->result();
		
		
		$row = 1;
		$startChar = 'C';
		//load our new PHPExcel library
		$this->load->library('excel');
		//activate worksheet number 1
		$this->excel->setActiveSheetIndex(0);
		//name the worksheet
		$this->excel->getActiveSheet()->setTitle('sheet1');
		//set cell A1 content with some text
		$this->excel->getActiveSheet()->setCellValue('A'.$row, 'Report Penerimaan Barang Produksi 4');
		//change the font size
		$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setSize(16);
		//make the font become bold
		$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setBold(true);

		$row++;
		$this->excel->getActiveSheet()->setCellValue('A'.$row, $outlet_name);

		$row++;
		$this->excel->getActiveSheet()->setCellValue('A'.$row, $periode_view);
			
		$row+=2;

		$this->excel->getActiveSheet()->setCellValue('A'.$row, 'Tgl Terima');
		$this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
		$this->excel->getActiveSheet()->setCellValue('B'.$row, 'Kode Barang');
		$this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(12);
		$this->excel->getActiveSheet()->setCellValue('C'.$row, 'Nama Barang');
		$this->excel->getActiveSheet()->getColumnDimension('C')->setWidth(35);
		$this->excel->getActiveSheet()->setCellValue('D'.$row, 'Qty Terima');
		$this->excel->getActiveSheet()->getColumnDimension('D')->setWidth(10);
		$this->excel->getActiveSheet()->setCellValue('E'.$row, 'Satuan Terima');
		$this->excel->getActiveSheet()->getColumnDimension('E')->setWidth(13);
		$this->excel->getActiveSheet()->setCellValue('F'.$row, 'Harga Pokok');
		$this->excel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
		$this->excel->getActiveSheet()->setCellValue('G'.$row, 'Catatan');
		$this->excel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
		$this->excel->getActiveSheet()->setCellValue('H'.$row, 'Total Harga');
		$this->excel->getActiveSheet()->getColumnDimension('H')->setWidth(15);

		$this->excel->getActiveSheet()->freezePane("A".($row+1));
		
		
		$this->excel->getActiveSheet()->getRowDimension($row)->setRowHeight(20);
		$dimension_title = 'A'.$row.':H'.$row;
		$objRow = $this->excel->getActiveSheet()->getStyle($dimension_title);
		$objRow->getFont()->setBold(true);
		$objRow->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		$objRow->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
		$objRow->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFb6dde8');
		
		$row++;
		$start_row = $row;
		$idx = 0;
		foreach($result as $data)
		{
			$this->excel->getActiveSheet()->setCellValue('A'.$row, $data->closing_date);
			$this->excel->getActiveSheet()->setCellValue('B'.$row, $data->product_code);
			$this->excel->getActiveSheet()->setCellValue('C'.$row, $data->product_name);
			$this->excel->getActiveSheet()->setCellValue('D'.$row, $data->qty);
			$this->excel->getActiveSheet()->setCellValue('E'.$row, $data->unit_large);
			$this->excel->getActiveSheet()->setCellValue('F'.$row, $data->cost_of_goods);
			$this->excel->getActiveSheet()->setCellValue('G'.$row, '');
			$this->excel->getActiveSheet()->setCellValue('H'.$row, '=D'.$row.'*F'.$row);
			$row++;
		}
		
		$end_row = $row-1;
		$objRow = $this->excel->getActiveSheet()->getStyle('A'.$row.':C'.$row);
		$objRow->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

		$objRow = $this->excel->getActiveSheet()->getStyle('A'.$row.':H'.$row);
		$objRow->getFont()->setBold(true);

		$this->excel->getActiveSheet()->setCellValue('C'.$row, 'TOTAL');

		$this->excel->getActiveSheet()->setCellValue('H'.$row, '=SUM(H'.$start_row.':H'.$end_row.')');
		$this->excel->getActiveSheet()->getStyle('H'.$start_row.':H'.$row)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFfde9d9');
		$this->excel->getActiveSheet()->getStyle('A'.$row.':H'.$row)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFfde9d9');

		$this->excel->getActiveSheet()
					->getStyle('F'.$start_row.':F'.$row)
					->getNumberFormat()
					->setFormatCode('"Rp "#,###');
		$this->excel->getActiveSheet()
					->getStyle('H'.$start_row.':H'.$row)
					->getNumberFormat()
					->setFormatCode('"Rp "#,###');

		
		$styleArray = array(
		  'borders' => array(
		    'allborders' => array(
		      'style' => PHPExcel_Style_Border::BORDER_THIN
		    )
		  )
		);

		$this->excel->getActiveSheet()->getStyle('A'.($start_row-1).':H'.$row)->applyFromArray($styleArray);
		unset($styleArray);
		
		$filepath = realpath(FCPATH).'/exports/'.$filename;
		$fileurl = "exports/".$filename;

		if(file_exists($filepath))
			unlink($filepath);

		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		//header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="'.$filename.'"');
		header('Content-Transfer-Encoding: binary');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		
		$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
		$objWriter->save($filepath);
		echo $fileurl;
		
		$this->excel->disconnectWorksheets();
		unset($objWriter, $this->excel);
		
		exit;
	}

	function recap_expense()
	{
		$variables = $this->renderParams(json_decode(file_get_contents('php://input')));

		$filename = $variables['filename'];
		$start = $variables['periode_start'];
		$end = $variables['periode_end'];
		$outlet_id = $variables['outlet_id'];
		$outlet_name = $variables['outlet_view'];
		$periode_view = $variables['periode_view'];

		$sql = "SELECT A.closing_date, E.supplier_name, C.product_code, C.product_name, B.qty, CASE B.is_cons_bon WHEN 1 THEN B.price * -1 ELSE B.price END AS `price`, C.unit_large, B.comments, C.coa, D.coa_description
				FROM `outlet_purchases` A INNER JOIN `outlet_purchase_details` B ON A.id = B.purchase_id
					INNER JOIN `master_supplier` E ON A.supplier_id = E.id
					INNER JOIN `master_products` C ON B.product_id = C.product_id
				    LEFT JOIN `master_coa` D ON C.coa = D.coa
				WHERE A.outlet_id = ".$outlet_id." AND closing_date BETWEEN '".$start->format('Y-m-d')."' AND '".$end->format('Y-m-d')."'
				ORDER BY A.closing_date, E.supplier_name, C.product_name";
		
		$result = $this->db->query($sql)->result();
		
		
		$row = 1;
		$startChar = 'C';
		//load our new PHPExcel library
		$this->load->library('excel');
		//activate worksheet number 1
		$this->excel->setActiveSheetIndex(0);
		//name the worksheet
		$this->excel->getActiveSheet()->setTitle('sheet1');
		//set cell A1 content with some text
		$this->excel->getActiveSheet()->setCellValue('A'.$row, 'Report Pembelian Non Produksi');
		//change the font size
		$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setSize(16);
		//make the font become bold
		$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setBold(true);

		$row++;
		$this->excel->getActiveSheet()->setCellValue('A'.$row, $outlet_name);

		$row++;
		$this->excel->getActiveSheet()->setCellValue('A'.$row, $periode_view);
			
		$row+=2;

		$this->excel->getActiveSheet()->setCellValue('A'.$row, 'Tgl Beli');
		$this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(12);
		$this->excel->getActiveSheet()->setCellValue('B'.$row, 'Nama Supplier');
		$this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(35);
		$this->excel->getActiveSheet()->setCellValue('C'.$row, 'Kode Barang');
		$this->excel->getActiveSheet()->getColumnDimension('C')->setWidth(12);
		$this->excel->getActiveSheet()->setCellValue('D'.$row, 'Nama Barang');
		$this->excel->getActiveSheet()->getColumnDimension('D')->setWidth(35);
		$this->excel->getActiveSheet()->setCellValue('E'.$row, 'Qty Beli');
		$this->excel->getActiveSheet()->getColumnDimension('E')->setWidth(10);
		$this->excel->getActiveSheet()->setCellValue('F'.$row, 'Harga Beli');
		$this->excel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
		$this->excel->getActiveSheet()->setCellValue('G'.$row, 'Satuan Beli');
		$this->excel->getActiveSheet()->getColumnDimension('G')->setWidth(13);
		$this->excel->getActiveSheet()->setCellValue('H'.$row, 'Catatan Beli');
		$this->excel->getActiveSheet()->getColumnDimension('H')->setWidth(35);
		$this->excel->getActiveSheet()->setCellValue('I'.$row, 'Total');
		$this->excel->getActiveSheet()->getColumnDimension('I')->setWidth(15);
		$this->excel->getActiveSheet()->setCellValue('J'.$row, 'COA');
		$this->excel->getActiveSheet()->getColumnDimension('J')->setWidth(10);
		$this->excel->getActiveSheet()->setCellValue('K'.$row, 'Nama COA');
		$this->excel->getActiveSheet()->getColumnDimension('K')->setWidth(35);

		$this->excel->getActiveSheet()->freezePane("E".($row+1));
		
		
		$this->excel->getActiveSheet()->getRowDimension($row)->setRowHeight(20);
		$dimension_title = 'A'.$row.':K'.$row;
		$objRow = $this->excel->getActiveSheet()->getStyle($dimension_title);
		$objRow->getFont()->setBold(true);
		$objRow->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		$objRow->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
		$objRow->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFb6dde8');
		
		$row++;
		$start_row = $row;
		$idx = 0;
		foreach($result as $data)
		{
			$this->excel->getActiveSheet()->setCellValue('A'.$row, $data->closing_date);
			$this->excel->getActiveSheet()->setCellValue('B'.$row, $data->supplier_name);
			$this->excel->getActiveSheet()->setCellValue('C'.$row, $data->product_code);
			$this->excel->getActiveSheet()->setCellValue('D'.$row, $data->product_name);
			$this->excel->getActiveSheet()->setCellValue('E'.$row, $data->qty);
			$this->excel->getActiveSheet()->setCellValue('F'.$row, $data->price);
			$this->excel->getActiveSheet()->setCellValue('G'.$row, $data->unit_large);
			$this->excel->getActiveSheet()->setCellValue('H'.$row, $data->comments);
			$this->excel->getActiveSheet()->setCellValue('I'.$row, '=E'.$row.'*F'.$row);
			$this->excel->getActiveSheet()->setCellValue('J'.$row, $data->coa);
			$this->excel->getActiveSheet()->setCellValue('K'.$row, $data->coa_description);
			$row++;
		}
		
		$end_row = $row-1;
		$objRow = $this->excel->getActiveSheet()->getStyle('A'.$row.':C'.$row);
		$objRow->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

		$objRow = $this->excel->getActiveSheet()->getStyle('A'.$row.':H'.$row);
		$objRow->getFont()->setBold(true);

		$this->excel->getActiveSheet()->setCellValue('C'.$row, 'TOTAL');

		$calc_range = 'I'.$start_row.':I'.$end_row;
		$this->excel->getActiveSheet()->setCellValue('I'.$row, '=SUMIF('.$calc_range.',"> 0",'.$calc_range.')');
		$this->excel->getActiveSheet()->setCellValue('I'.($row+1), '=SUMIF('.$calc_range.',"< 0",'.$calc_range.')');
		$this->excel->getActiveSheet()->getStyle('I'.$start_row.':I'.$row)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFfde9d9');
		$this->excel->getActiveSheet()->getStyle('A'.$row.':K'.$row)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFfde9d9');

		$this->excel->getActiveSheet()
					->getStyle('F'.$start_row.':F'.$row)
					->getNumberFormat()
					->setFormatCode('"Rp "#,###');
		$this->excel->getActiveSheet()
					->getStyle('I'.$start_row.':I'.$row)
					->getNumberFormat()
					->setFormatCode('"Rp "#,###');

		
		$styleArray = array(
		  'borders' => array(
		    'allborders' => array(
		      'style' => PHPExcel_Style_Border::BORDER_THIN
		    )
		  )
		);

		$this->excel->getActiveSheet()->getStyle('A'.($start_row-1).':K'.$row)->applyFromArray($styleArray);
		unset($styleArray);
		
		$filepath = realpath(FCPATH).'/exports/'.$filename;
		$fileurl = "exports/".$filename;

		if(file_exists($filepath))
			unlink($filepath);

		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		//header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="'.$filename.'"');
		header('Content-Transfer-Encoding: binary');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		
		$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
		$objWriter->save($filepath);
		echo $fileurl;
		
		$this->excel->disconnectWorksheets();
		unset($objWriter, $this->excel);
		
		exit;
	}

	function recap_sales_all()
	{
		$variables = $this->renderParams(json_decode(file_get_contents('php://input')));

		$filename = $variables['filename'];
		$start = $variables['periode_start'];
		$end = $variables['periode_end'];
		$periode_view = $variables['periode_view'];

		$sql = "SELECT A.outlets_id, A.outlets_code, A.outlets_name, JmCust, Sales, Expense, JmlVoucher, JmlCreditCard, JmlDiscount
				FROM (SELECT B.outlets_id, B.outlets_code, B.outlets_name, SUM(JmCust) AS JmCust, ROUND(SUM(JmlPenjualan)) AS Sales, SUM(JmlVoucher) AS JmlVoucher, SUM(JmlCreditCard) AS JmlCreditCard, SUM(JmlDiscount) AS JmlDiscount
				FROM `outlet_sales_orders` A 
					INNER JOIN `master_outlets` B ON A.KdOutlet = B.other_code
				WHERE SdhBayar = 'T' AND TglClosing BETWEEN '".$start->format('Y-m-d')."' AND '".$end->format('Y-m-d')."'
				GROUP BY B.outlets_id, B.outlets_code, B.outlets_name) A LEFT JOIN 

				(SELECT A.outlet_id, SUM(CASE B.is_cons_bon WHEN 0 THEN qty * B.price ELSE 0 END) AS Expense
				FROM `outlet_purchases` A INNER JOIN `outlet_purchase_details` B ON A.id = B.purchase_id
				WHERE A.closing_date BETWEEN '".$start->format('Y-m-d')."' AND '".$end->format('Y-m-d')."'
				GROUP BY A.outlet_id) B ON A.outlets_id = B.outlet_id
				ORDER BY A.outlets_name";
		
		$result = $this->db->query($sql)->result();
		
		
		$row = 1;
		$startChar = 'C';
		//load our new PHPExcel library
		$this->load->library('excel');
		//activate worksheet number 1
		$this->excel->setActiveSheetIndex(0);
		//name the worksheet
		$this->excel->getActiveSheet()->setTitle('sheet1');
		//set cell A1 content with some text
		$this->excel->getActiveSheet()->setCellValue('A'.$row, 'Rekap Pendapatan Outlet');
		//change the font size
		$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setSize(16);
		//make the font become bold
		$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setBold(true);


		$row++;
		$this->excel->getActiveSheet()->setCellValue('A'.$row, $periode_view);
			
		$row+=2;
		$row_header = $row + 1;

		$this->excel->getActiveSheet()->setCellValue('A'.$row, 'No');
		$this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(5);
		$this->excel->getActiveSheet()->mergeCells("A".$row.":A".$row_header);

		$this->excel->getActiveSheet()->setCellValue('B'.$row, 'Kode Outlet');
		$this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(10);
		$this->excel->getActiveSheet()->mergeCells("B".$row.":B".$row_header);

		$this->excel->getActiveSheet()->setCellValue('C'.$row, 'Nama Outlet');
		$this->excel->getActiveSheet()->getColumnDimension('C')->setWidth(35);
		$this->excel->getActiveSheet()->mergeCells("C".$row.":C".$row_header);

		$this->excel->getActiveSheet()->setCellValue('D'.$row, 'CU');
		$this->excel->getActiveSheet()->getColumnDimension('D')->setWidth(7);
		$this->excel->getActiveSheet()->mergeCells("D".$row.":D".$row_header);

		$this->excel->getActiveSheet()->setCellValue('E'.$row, 'Total Pendapatan');
		$this->excel->getActiveSheet()->getColumnDimension('E')->setWidth(16);
		$this->excel->getActiveSheet()->mergeCells("E".$row.":E".$row_header);

		$this->excel->getActiveSheet()->setCellValue('F'.$row, 'Total Biaya');
		$this->excel->getActiveSheet()->getColumnDimension('F')->setWidth(16);
		$this->excel->getActiveSheet()->mergeCells("F".$row.":F".$row_header);

		$this->excel->getActiveSheet()->setCellValue('G'.$row, 'Sisa Tunai');
		$this->excel->getActiveSheet()->getColumnDimension('G')->setWidth(16);
		$this->excel->getActiveSheet()->mergeCells("G".$row.":G".$row_header);

		$this->excel->getActiveSheet()->setCellValue('H'.$row, 'Deposit');
		//$this->excel->getActiveSheet()->getColumnDimension('H')->setWidth(30);
		$this->excel->getActiveSheet()->mergeCells("H".$row.":I".$row);

		$this->excel->getActiveSheet()->setCellValue('H'.$row_header, 'Deposit');
		$this->excel->getActiveSheet()->getColumnDimension('H')->setWidth(16);
		$this->excel->getActiveSheet()->setCellValue('I'.$row_header, 'G.Service');
		$this->excel->getActiveSheet()->getColumnDimension('I')->setWidth(16);

		$this->excel->getActiveSheet()->setCellValue('J'.$row, 'Voucher');
		$this->excel->getActiveSheet()->getColumnDimension('J')->setWidth(16);
		$this->excel->getActiveSheet()->mergeCells("J".$row.":J".$row_header);

		$this->excel->getActiveSheet()->setCellValue('K'.$row, 'Credit Card');
		$this->excel->getActiveSheet()->getColumnDimension('K')->setWidth(16);
		$this->excel->getActiveSheet()->mergeCells("K".$row.":K".$row_header);
	
		
		$this->excel->getActiveSheet()->getRowDimension($row)->setRowHeight(20);
		$dimension_title = 'A'.$row.':K'.$row_header;
		$objRow = $this->excel->getActiveSheet()->getStyle($dimension_title);
		$objRow->getFont()->setBold(true);
		$objRow->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		$objRow->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
		$objRow->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFb6dde8');
		
		$row+=2;
		$start_row = $row;
		$idx = 0;
		foreach($result as $data)
		{
			$this->excel->getActiveSheet()->setCellValue('A'.$row, ++$idx);
			$this->excel->getActiveSheet()->setCellValue('B'.$row, $data->outlets_code);
			$this->excel->getActiveSheet()->setCellValue('C'.$row, $data->outlets_name);
			$this->excel->getActiveSheet()->setCellValue('D'.$row, $data->JmCust);
			$this->excel->getActiveSheet()->setCellValue('E'.$row, $data->Sales);
			$this->excel->getActiveSheet()->setCellValue('F'.$row, $data->Expense);
			$this->excel->getActiveSheet()->setCellValue('G'.$row, '=E'.$row.'-F'.$row.'-J'.$row.'-K'.$row);
			$this->excel->getActiveSheet()->setCellValue('H'.$row, '=E'.$row.'-F'.$row.'-J'.$row.'-K'.$row);
			$this->excel->getActiveSheet()->setCellValue('I'.$row, 0);
			$this->excel->getActiveSheet()->setCellValue('J'.$row, $data->JmlVoucher);
			$this->excel->getActiveSheet()->setCellValue('K'.$row, $data->JmlCreditCard);
			$row++;
		}
		
		$end_row = $row-1;
		$this->excel->getActiveSheet()->setCellValue('A'.$row, 'TOTAL');
		$objRow = $this->excel->getActiveSheet()->getStyle('A'.$row.':B'.$row);
		$objRow->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

		$objRow = $this->excel->getActiveSheet()->getStyle('A'.$row.':K'.$row);
		$objRow->getFont()->setBold(true);

		for($chr = 'D'; $chr <= 'K'; $chr++) {
			$this->excel->getActiveSheet()->setCellValue($chr.$row, '=SUM('.$chr.$start_row.':'.$chr.$end_row.')');
		}
		$this->excel->getActiveSheet()->getStyle('A'.$row.':K'.$row)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFfde9d9');

		$this->excel->getActiveSheet()
					->getStyle('D'.$start_row.':D'.$row)
					->getNumberFormat()
					->setFormatCode('#,###');
		$this->excel->getActiveSheet()
					->getStyle('E'.$start_row.':K'.$row)
					->getNumberFormat()
					->setFormatCode('"Rp "#,###');

		
		$styleArray = array(
		  'borders' => array(
		    'allborders' => array(
		      'style' => PHPExcel_Style_Border::BORDER_THIN
		    )
		  )
		);

		$this->excel->getActiveSheet()->getStyle('A'.($start_row-2).':K'.$row)->applyFromArray($styleArray);
		unset($styleArray);
		
		$filepath = realpath(FCPATH).'/exports/'.$filename;
		$fileurl = "exports/".$filename;

		if(file_exists($filepath))
			unlink($filepath);

		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		//header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="'.$filename.'"');
		header('Content-Transfer-Encoding: binary');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		
		$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
		$objWriter->save($filepath);
		echo $fileurl;
		
		$this->excel->disconnectWorksheets();
		unset($objWriter, $this->excel);
		
		exit;
	}

	function recap_sales_outlet()
	{
		$variables = $this->renderParams(json_decode(file_get_contents('php://input')));

		$filename = $variables['filename'];
		$start = $variables['periode_start'];
		$end = $variables['periode_end'];
		$outlet_id = $variables['outlet_id'];
		$outlet_name = $variables['outlet_view'];
		$periode_view = $variables['periode_view'];

		$sql = "SELECT X.outlets_id, X.outlets_code, X.outlets_name, X.TglClosing, JmCust, Lunch, `Slow`, Dinner, Expense, JmlVoucher, JmlCreditCard, JmlDiscount
				FROM (SELECT B.outlets_id, B.outlets_code, B.outlets_name, TglClosing
					, ROUND(SUM(CASE WHEN TglPosting <= STR_TO_DATE(CONCAT(TglClosing, ' 14:00:00'), '%Y-%m-%d %H:%i:%s') THEN JmlPenjualan ELSE 0 END)) AS Lunch
					, ROUND(SUM(CASE WHEN (TglPosting > STR_TO_DATE(CONCAT(TglClosing, ' 14:00:00'), '%Y-%m-%d %H:%i:%s')) AND (TglPosting <= STR_TO_DATE(CONCAT(TglClosing, ' 18:00:00'), '%Y-%m-%d %H:%i:%s')) THEN JmlPenjualan ELSE 0 END)) AS `Slow`
					, ROUND(SUM(CASE WHEN TglPosting > STR_TO_DATE(CONCAT(TglClosing, ' 18:00:00'), '%Y-%m-%d %H:%i:%s') THEN JmlPenjualan ELSE 0 END)) AS Dinner
				    , SUM(JmCust) AS JmCust, SUM(JmlVoucher) AS JmlVoucher, SUM(JmlCreditCard) AS JmlCreditCard, SUM(JmlDiscount) AS JmlDiscount
					FROM `outlet_sales_orders` A INNER JOIN  `master_outlets` B ON A.KdOutlet = B.other_code
					WHERE SdhBayar = 'T' AND B.outlets_id = ".$outlet_id." AND TglClosing BETWEEN '".$start->format('Y-m-d')."' AND '".$end->format('Y-m-d')."'
					GROUP BY B.outlets_id, B.outlets_code, B.outlets_name, TglClosing) X LEFT JOIN 
				    
				(SELECT A.outlet_id, A.closing_date, SUM(CASE B.is_cons_bon WHEN 0 THEN qty * B.price ELSE 0 END) AS Expense
				FROM `outlet_purchases` A INNER JOIN `outlet_purchase_details` B ON A.id = B.purchase_id
				WHERE A.outlet_id = ".$outlet_id." AND A.closing_date BETWEEN '".$start->format('Y-m-d')."' AND '".$end->format('Y-m-d')."'
				GROUP BY A.outlet_id, A.closing_date) Y ON X.outlets_id = Y.outlet_id AND X.TglClosing = Y.closing_date
				ORDER BY X.TglClosing";
		
		$result = $this->db->query($sql)->result();
		
		
		$row = 1;
		$startChar = 'C';
		//load our new PHPExcel library
		$this->load->library('excel');
		//activate worksheet number 1
		$this->excel->setActiveSheetIndex(0);
		//name the worksheet
		$this->excel->getActiveSheet()->setTitle('sheet1');
		//set cell A1 content with some text
		$this->excel->getActiveSheet()->setCellValue('A'.$row, 'Laporan Pendapatan Per Outlet');
		//change the font size
		$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setSize(16);
		//make the font become bold
		$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setBold(true);

		$row++;
		$this->excel->getActiveSheet()->setCellValue('A'.$row, $outlet_name);

		$row++;
		$this->excel->getActiveSheet()->setCellValue('A'.$row, $periode_view);
			
		$row+=2;
		$row_header = $row + 1;

		$this->excel->getActiveSheet()->setCellValue('A'.$row, 'Tanggal');
		$this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(12);
		$this->excel->getActiveSheet()->mergeCells("A".$row.":A".$row_header);

		$this->excel->getActiveSheet()->setCellValue('B'.$row, 'CU');
		$this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(7);
		$this->excel->getActiveSheet()->mergeCells("B".$row.":B".$row_header);

		$this->excel->getActiveSheet()->setCellValue('C'.$row, 'Daya Beli');
		$this->excel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
		$this->excel->getActiveSheet()->mergeCells("C".$row.":C".$row_header);

		$this->excel->getActiveSheet()->setCellValue('D'.$row, 'Pendapatan');
		$this->excel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
		$this->excel->getActiveSheet()->mergeCells("D".$row.":G".$row);

		$this->excel->getActiveSheet()->setCellValue('D'.$row_header, 'Lunch');
		$this->excel->getActiveSheet()->getColumnDimension('D')->setWidth(15);

		$this->excel->getActiveSheet()->setCellValue('E'.$row_header, 'Slow');
		$this->excel->getActiveSheet()->getColumnDimension('E')->setWidth(15);

		$this->excel->getActiveSheet()->setCellValue('F'.$row_header, 'Dinner');
		$this->excel->getActiveSheet()->getColumnDimension('F')->setWidth(15);

		$this->excel->getActiveSheet()->setCellValue('G'.$row_header, 'Del Charge');
		$this->excel->getActiveSheet()->getColumnDimension('G')->setWidth(15);

		$this->excel->getActiveSheet()->setCellValue('H'.$row, 'Total Pendapatan');
		$this->excel->getActiveSheet()->getColumnDimension('H')->setWidth(16);
		$this->excel->getActiveSheet()->mergeCells("H".$row.":H".$row_header);

		$this->excel->getActiveSheet()->setCellValue('I'.$row, 'Total Biaya');
		$this->excel->getActiveSheet()->getColumnDimension('I')->setWidth(16);
		$this->excel->getActiveSheet()->mergeCells("I".$row.":I".$row_header);

		$this->excel->getActiveSheet()->setCellValue('J'.$row, 'Sisa Tunai');
		$this->excel->getActiveSheet()->getColumnDimension('J')->setWidth(16);
		$this->excel->getActiveSheet()->mergeCells("J".$row.":J".$row_header);

		$this->excel->getActiveSheet()->setCellValue('K'.$row, 'Deposit');
		$this->excel->getActiveSheet()->mergeCells("K".$row.":L".$row);

		$this->excel->getActiveSheet()->setCellValue('K'.$row_header, 'Deposit');
		$this->excel->getActiveSheet()->getColumnDimension('K')->setWidth(16);

		$this->excel->getActiveSheet()->setCellValue('L'.$row_header, 'G.Service');
		$this->excel->getActiveSheet()->getColumnDimension('L')->setWidth(16);

		$this->excel->getActiveSheet()->setCellValue('M'.$row, 'Voucher');
		$this->excel->getActiveSheet()->getColumnDimension('M')->setWidth(16);
		$this->excel->getActiveSheet()->mergeCells("M".$row.":M".$row_header);

		$this->excel->getActiveSheet()->setCellValue('N'.$row, 'Credit Card');
		$this->excel->getActiveSheet()->getColumnDimension('N')->setWidth(16);
		$this->excel->getActiveSheet()->mergeCells("N".$row.":N".$row_header);

		$this->excel->getActiveSheet()->setCellValue('O'.$row, 'Discount');
		$this->excel->getActiveSheet()->getColumnDimension('O')->setWidth(16);
		$this->excel->getActiveSheet()->mergeCells("O".$row.":O".$row_header);
	
		$this->excel->getActiveSheet()->freezePane("B".($row+2));
		
		$this->excel->getActiveSheet()->getRowDimension($row)->setRowHeight(20);
		$dimension_title = 'A'.$row.':O'.$row_header;
		$objRow = $this->excel->getActiveSheet()->getStyle($dimension_title);
		$objRow->getFont()->setBold(true);
		$objRow->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		$objRow->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
		$objRow->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFb6dde8');
		
		$row+=2;
		$start_row = $row;
		$idx = 0;
		foreach($result as $data)
		{
			$this->excel->getActiveSheet()->setCellValue('A'.$row, $data->TglClosing);
			$this->excel->getActiveSheet()->setCellValue('B'.$row, $data->JmCust);
			$this->excel->getActiveSheet()->setCellValue('C'.$row, '=ROUND((D'.$row.'+E'.$row.'+F'.$row.'+G'.$row.') / B'.$row.', 0)');
			$this->excel->getActiveSheet()->setCellValue('D'.$row, $data->Lunch);
			$this->excel->getActiveSheet()->setCellValue('E'.$row, $data->Slow);
			$this->excel->getActiveSheet()->setCellValue('F'.$row, $data->Dinner);
			$this->excel->getActiveSheet()->setCellValue('G'.$row, 0);
			$this->excel->getActiveSheet()->setCellValue('H'.$row, '=D'.$row.'+E'.$row.'+F'.$row.'+G'.$row);
			$this->excel->getActiveSheet()->setCellValue('I'.$row, $data->Expense);
			$this->excel->getActiveSheet()->setCellValue('J'.$row, '=H'.$row.'-(I'.$row.'+M'.$row.'+N'.$row.'+O'.$row.')');
			$this->excel->getActiveSheet()->setCellValue('K'.$row, '=H'.$row.'-(I'.$row.'+M'.$row.'+N'.$row.'+O'.$row.')');
			$this->excel->getActiveSheet()->setCellValue('L'.$row, 0);
			$this->excel->getActiveSheet()->setCellValue('M'.$row, $data->JmlVoucher);
			$this->excel->getActiveSheet()->setCellValue('N'.$row, $data->JmlCreditCard);
			$this->excel->getActiveSheet()->setCellValue('O'.$row, $data->JmlDiscount);
			$row++;
		}
		
		$end_row = $row-1;
		$this->excel->getActiveSheet()->setCellValue('A'.$row, 'TOTAL');
		$objRow = $this->excel->getActiveSheet()->getStyle('A'.$row.':B'.$row);
		$objRow->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

		$objRow = $this->excel->getActiveSheet()->getStyle('A'.$row.':O'.$row);
		$objRow->getFont()->setBold(true);

		for($chr = 'B'; $chr <= 'O'; $chr++) {
			$this->excel->getActiveSheet()->setCellValue($chr.$row, '=SUM('.$chr.$start_row.':'.$chr.$end_row.')');
		}
		$this->excel->getActiveSheet()->getStyle('A'.$row.':O'.$row)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFfde9d9');

		$this->excel->getActiveSheet()
					->getStyle('B'.$start_row.':B'.$row)
					->getNumberFormat()
					->setFormatCode('#,###');
		$this->excel->getActiveSheet()
					->getStyle('C'.$start_row.':O'.$row)
					->getNumberFormat()
					->setFormatCode('"Rp "#,###');

		
		$styleArray = array(
		  'borders' => array(
		    'allborders' => array(
		      'style' => PHPExcel_Style_Border::BORDER_THIN
		    )
		  )
		);

		$this->excel->getActiveSheet()->getStyle('A'.($start_row-2).':O'.$row)->applyFromArray($styleArray);
		unset($styleArray);
		
		$filepath = realpath(FCPATH).'/exports/'.$filename;
		$fileurl = "exports/".$filename;

		if(file_exists($filepath))
			unlink($filepath);

		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		//header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="'.$filename.'"');
		header('Content-Transfer-Encoding: binary');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		
		$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
		$objWriter->save($filepath);
		echo $fileurl;
		
		$this->excel->disconnectWorksheets();
		unset($objWriter, $this->excel);
		
		exit;
	}
} ?>
