<?php
class Export_Excel extends CI_Model
{
	function __construct()
	{
		parent::__construct();
	}

	function writeRow($row, $field_array, $data)
	{
		$i='A'; $j=''; $k='';
		foreach($field_array as $field)
		{
			$k = $j.$i;
			$this->excel->getActiveSheet()->setCellValue($k.$row, $data[$field['code']]);
			if($i == 'Z')
			{
				$i='A';
				$j.=$i;
			} else $i++;
		}
	}
	
	function runExport($title, $header_view, $field_array, $result, $filename)
	{
		$this->load->library('excel');
		$this->excel->setActiveSheetIndex(0);
		$this->excel->getActiveSheet()->setTitle('sheet1');
		
		//Report Title
		$row = 1;
		$this->excel->getActiveSheet()->setCellValue('A'.$row, $title);
		$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setSize(16);
		$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setBold(true);
		
		//Report Header Information
		if(is_array($header_view))
		{
			foreach($header_view as $view)
			{
				$row++;
				$this->excel->getActiveSheet()->setCellValue('A'.$row, $view);
			}
		} else {
			$row++;
			$this->excel->getActiveSheet()->setCellValue('A'.$row, $header_view);
		}
			
		//Report Table Column Name
		$row+=2;
		$i='A'; $j=''; $k='';
		foreach($field_array as $field)
		{
			$k = $j.$i;
			$this->excel->getActiveSheet()->setCellValue($k.$row, $field['title']);
			if(isset($field['width']))
				$this->excel->getActiveSheet()->getColumnDimension($k)->setWidth($field['width']);
			if($i == 'Z')
			{
				$i='A';
				$j.=$i;
			} else $i++;
		}
		
		$this->excel->getActiveSheet()->getRowDimension($row)->setRowHeight(20);
		$dimension_title = 'A'.$row.':'.$k.$row;
		$objRow = $this->excel->getActiveSheet()->getStyle($dimension_title);
		$objRow->getFont()->setBold(true);
		$objRow->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		$objRow->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
		$objRow->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFb6dde8');
		
		//Report Table Result Value
		$row++;
		foreach($result as $data)
		{
			$k = $j.$i;
			$this->writeRow($row, $field_array, $data);
			if($i == 'Z')
			{
				$i='A';
				$j.=$i;
			} else $i++;
			$row++;
		}
		
		$filepath = realpath(FCPATH).'/exports/'.$filename;
		$fileurl = "exports/".$filename;
		
		if(file_exists($filepath))
			unlink($filepath);
		
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		//header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="'.$filename.'"');
		header('Content-Transfer-Encoding: binary');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		
		$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
		$objWriter->save($filepath);
		echo $fileurl;
		
		$this->excel->disconnectWorksheets();
		unset($objWriter, $this->excel);
		
		exit;
	}
}