<?php
class Report_Sale_Menu extends CI_Model
{
	function __construct()
	{
		parent::__construct();
	}

	function runQuery($_sql, $data)
	{
		$sql = "SELECT D.menu_id, D.menu_code, D.menu_name, fc_format_rupiah(B.HrgMenu) AS `price`, fc_format_number(SUM(B.QtyJual)) AS `total` ".$_sql."
				FROM `outlet_sales_orders` A INNER JOIN `outlet_sales_order_details` B ON A.NoOrder = B.Noorder
					INNER JOIN `master_outlets` C ON A.KdOutlet = C.other_code
					INNER JOIN `master_menus` D ON B.KdMenu = D.menu_code
				WHERE A.tglClosing BETWEEN '".$data->periode_start."' AND '".$data->periode_end."' ".(isset($data->outlet_id) ? " AND C.outlets_id = ".$data->outlet_id : '')." 
				GROUP BY D.menu_id, D.menu_code, D.menu_name, B.HrgMenu
				ORDER BY D.menu_name";
		return $this->db->query($sql)->result_array();
	}
	
	function viewTotal($data, $fields)
	{
		$result = $this->runQuery('', $data);
		return array('fields'=>$fields, 'field_values'=>$result);
	}
	
	function viewMonthly($data, $fields)
	{
		$start = new DateTime($data->periode_start);
		$end = new DateTime($data->periode_end);

		$_newDate = new DateTime($start->format('Y').'-'.$start->format('m').'-01');
		$sql = '';
		while($_newDate <= $end)
		{
			$fields[] = array('code'=>'q'.$_newDate->format('Ym'), 'title'=>$_newDate->format('Ym'));
			$sql .= ", fc_format_number(SUM(CASE WHEN DATE_FORMAT(A.tglclosing,'%Y%m') = '".$_newDate->format('Ym')."' THEN B.QtyJual ELSE 0 END)) AS `q".$_newDate->format('Ym')."`";
			$_newDate->add(new DateInterval("P1M"));
		}
		
		$result = $this->runQuery($sql, $data);
		return array('fields'=>$fields, 'field_values'=>$result);
	}
	
	function viewDaily($data, $fields)
	{
		$start = new DateTime($data->periode_start);
		$end = new DateTime($data->periode_end);

		$_newDate = clone $start;
		$sql = '';
		while($_newDate <= $end)
		{
			$fields[] = array('code'=>'q'.$_newDate->format('Ymd'), 'title'=>$_newDate->format('Ymd'));
			$sql .= ", fc_format_number(SUM(CASE WHEN DATE_FORMAT(A.tglclosing,'%Y%m%d') = '".$_newDate->format('Ymd')."' THEN B.QtyJual ELSE 0 END)) AS `q".$_newDate->format('Ymd')."`";
			$_newDate->add(new DateInterval("P1D"));
		}
		
		$result = $this->runQuery($sql, $data);
		return array('fields'=>$fields, 'field_values'=>$result);
	}
}