var app = angular.module('engagement', [
	'ngRoute','ngAnimate','angular-ladda','ui.bootstrap'
]);

app.run(['$route', '$rootScope', '$location', '$routeParams', function ($route, $rootScope, $location, $routeParams) {
    var original = $location.path;
    $location.path = function (path, reload) {
        if (reload === false) {
            var lastRoute = $route.current;
            var un = $rootScope.$on('$locationChangeSuccess', function () {
                $route.current = lastRoute;
                un();
            });
        }
        return original.apply($location, [path]);
    };
	$rootScope.numPrecision = function(data) {
		return data - Math.floor(data) > 0 ? 2 : 0;
	};
}]);

app.config(['$routeProvider', function ($routeProvider) {
  $routeProvider
	// Home
	.when("/", {templateUrl:url_base+"src/page/home.html", controller: "DashboardController"})
	
	// Menus
	.when("/menu_categories", {templateUrl: url_base+"src/page/menus/categories.html", controller: "MenuCategoriesController"})
	.when("/menu_category_new", {templateUrl: url_base+"src/page/menus/category_new.html", controller: "NewMenuCategoryController"})
	.when("/menu_category_new/:eid", {templateUrl: url_base+"src/page/menus/category_new.html", controller: "NewMenuCategoryController"})
	
	.when("/menus", {templateUrl: url_base+"src/page/menus/menus.html", controller: "MenusController"})
	.when("/menu_new", {templateUrl: url_base+"src/page/menus/menu_new.html", controller: "NewMenuController"})
	.when("/menu_create", {templateUrl: url_base+"src/page/menus/create_menu.html", controller: "CreateMenuController"})
	.when("/menu_create/:eid", {templateUrl: url_base+"src/page/menus/create_menu.html", controller: "CreateMenuController"})
	.when("/menu_new/:eid", {templateUrl: url_base+"src/page/menus/menu_new.html", controller: "NewMenuController"})
	
	// Outlets
	.when("/outlets", {templateUrl: url_base+"src/page/outlets/outlets.html", controller: "OutletsController"})
	.when("/outlet_new", {templateUrl: url_base+"src/page/outlets/outlet_new.html", controller: "NewOutletController"})
	.when("/outlet_new/:eid", {templateUrl: url_base+"src/page/outlets/outlet_new.html", controller: "NewOutletController"})
	
	// Products
	.when("/product_categories", {templateUrl: url_base+"src/page/products/categories.html", controller: "ProductCategoriesController"})
	.when("/product_category_new", {templateUrl: url_base+"src/page/products/category_new.html", controller: "NewProductCategoryController"})
	.when("/product_category_new/:eid", {templateUrl: url_base+"src/page/products/category_new.html", controller: "NewProductCategoryController"})
	
	.when("/product_groups", {templateUrl: url_base+"src/page/products/groups.html", controller: "ProductGroupsController"})
	.when("/product_group_new", {templateUrl: url_base+"src/page/products/group_new.html", controller: "NewProductGroupController"})
	.when("/product_group_new/:eid", {templateUrl: url_base+"src/page/products/group_new.html", controller: "NewProductGroupController"})
	
	.when("/products", {templateUrl: url_base+"src/page/products/products.html", controller: "ProductsController"})
	.when("/product_new", {templateUrl: url_base+"src/page/products/product_new.html", controller: "NewProductController"})
	.when("/product_new/:eid", {templateUrl: url_base+"src/page/products/product_new.html", controller: "NewProductController"})
	
	// Transactions
	// IN
	.when("/receiving", {templateUrl:url_base+"src/page/transactions/receiving/list_receiving.html", controller: "ReceivingController"})
	.when("/receiving/:eid", {templateUrl:url_base+"src/page/transactions/receiving/view_receiving.html", controller: "ViewReceivingController"})
	
	.when("/purchases", {templateUrl:url_base+"src/page/transactions/purchases/purchases.html", controller: "PurchasesController"})
	.when("/purchases/:eid", {templateUrl:url_base+"src/page/transactions/purchases/view_purchase.html", controller: "ViewPurchasesController"})
	
	// OUT
	.when("/waste", {templateUrl:url_base+"src/page/transactions/waste/waste.html", controller: "WasteProductController"})
	.when("/waste/:eid", {templateUrl:url_base+"src/page/transactions/waste/view_waste.html", controller: "ViewWasteProductController"})

	//waste by menu 
	.when('/waste_menu',{templateUrl:url_base+"src/page/transactions/waste_menu/list.html",controller:"WasteMenuController"})
	.when('/waste_menu/:eid',{templateUrl:url_base+"src/page/transactions/waste_menu/view.html",controller:"ViewWasteMenuController"})

	//.when("/sales_order", {templateUrl:url_base+"src/page/transactions/stock/sales_order.html", controller: "SalesOrderController"})
	
	// Reports
	.when("/report/received", {templateUrl:url_base+"src/page/reports/received.html", controller: "ReceivedController"})
	.when("/report/purchased", {templateUrl:url_base+"src/page/reports/purchased.html", controller: "PurchasedController"})
	.when("/report/sales", {templateUrl:url_base+"src/page/reports/sales.html", controller: "SalesController"})
	.when("/report/sale_menu", {templateUrl:url_base+"src/page/reports/sale_menu.html", controller: "SaleMenuController"})
	.when("/report/waste", {templateUrl:url_base+"src/page/reports/waste.html", controller: "WasteController"})

	.when("/report/payroll/expensecoa", {templateUrl:url_base+"src/page/reports/payroll/expensecoa.html", controller: "PExpensecoaController"})
	.when("/report/payroll/received", {templateUrl:url_base+"src/page/reports/payroll/received.html", controller: "PReceivedController"})
	.when("/report/payroll/expense", {templateUrl:url_base+"src/page/reports/payroll/expense.html", controller: "PExpenseController"})
	.when("/report/payroll/recapsales", {templateUrl:url_base+"src/page/reports/payroll/recapsales.html", controller: "PRecapsalesController"})
	.when("/report/payroll/sales", {templateUrl:url_base+"src/page/reports/payroll/sales.html", controller: "PSalesController"})
	
	// Stock
	.when("/stock", {templateUrl:url_base+"src/page/stock/stock.html", controller: "ViewStockController"})
	.when("/stock_opname", {templateUrl:url_base+"src/page/stock/stock_opname.html", controller: "StockOpnameController"})
	.when("/stock_opname_view/:eid", {templateUrl:url_base+"src/page/stock/stock_opname_view.html", controller: "ViewStockOpnameController"})
	.when("/stock_opname_new", {templateUrl:url_base+"src/page/stock/stock_opname_new.html", controller: "NewStockOpnameController"})
	.when("/stock_opname_new/:eid", {templateUrl:url_base+"src/page/stock/stock_opname_new.html", controller: "NewStockOpnameController"})
	
	//
	.when("/drivers", {templateUrl: url_base+"src/page/masters/drivers.html", controller: "DriversController"})
	.when("/driver_new", {templateUrl: url_base+"src/page/masters/driver_new.html", controller: "NewDriverController"})
	.when("/driver_new/:eid", {templateUrl: url_base+"src/page/masters/driver_new.html", controller: "NewDriverController"})
	
	.when("/suppliers", {templateUrl: url_base+"src/page/masters/suppliers.html", controller: "SuppliersBackController"})
	.when("/supplier_view/:eid", {templateUrl: url_base+"src/page/masters/supplier_view.html", controller: "ViewSupplierController"})
	
	.when("/profile", {templateUrl: url_base+"src/page/profile.html", controller: "profile"})
	
	.otherwise("/404", {templateUrl: url_base+"src/page/404.html", controller: "PageCtrl"});
}]);

app.factory('StatusList', function(){
	var Statuses = {};
	Statuses.list = [{code:'1', name:'Aktif'}, {code:'0', name:'Tidak Aktif'}];
	return Statuses;
});

app.factory('UtilList', function($http)
{
	return {
		productCategories: function(callback) {
			var url = url_base + 'master/product_categories/';
			$http.get(url).success(callback);
		},
		
		productGroups: function(callback) {
			var url = url_base + 'master/product_groups/';
			$http.get(url).success(callback);
		},
		
		menuCategories: function(callback) {
			var url = url_base + 'master/menu_categories/';
		    $http.get(url).success(callback);
		},
		
		outletList: function(callback) {
			var url = url_base + 'master/outlets/';
			$http.get(url).success(callback);
		},
	}
});

app.controller('PageCtrl', function($scope) {
	$scope.pageClass = 'page-home';
});

app.directive('focusOn', function() { 
   return function(scope, elem, attr) {
	  scope.$on('focusOn', function(e, name) {
		if(name === attr.focusOn) {
		  elem[0].focus();
		}
	  });
   };
});

app.directive('focus', function() {
	return function(scope, element) {
		element[0].focus();
	}      
});

app.factory('focus', function ($rootScope, $timeout) {
  return function(name) {
	$timeout(function (){
	  $rootScope.$broadcast('focusOn', name);
	});
  }
});

app.directive('onlyNumbers', function()
{
	return function(scope, element, attrs) {
	var keyCode = [8,9,13,37,39,46,48,49,50,51,52,53,54,55,56,57,96,97,98,99,100,101,102,103,104,105,110,190];
	element.bind("keydown", function(event) {
		if($.inArray(event.which,keyCode) == -1) {
			scope.$apply(function(){
				scope.$eval(attrs.onlyNum);
				event.preventDefault();
			});
			event.preventDefault();
		}
	});
	};
});

app.filter('startFrom', function() {
	return function(input, start) {
		if(input) {
			start = +start; //parse to int
			return input.slice(start);
		}
		return [];
	}
});

app.directive('selectpicker', function () {
	return {
		restrict: 'C',
		link: function (scope, element) {
			$(element).selectpicker({
				style: 'btn-default',
				size: false
			});
		}
	};
});

app.directive('calendarsari', function()
{
	return {
		require: 'ngModel',
		link: function (scope, element, attr, ngModel) {
			element.on('changeDate', function(){
				scope.$apply(function () {
					ngModel.$setViewValue(element.val());
				});
			})
		}
	}
});

app.directive('calendar', function () {
	return {
		require: 'ngModel',
		link: function (scope, element, attr, ngModel) {
			$(element).datepicker({
				format: 'yyyy-mm-yy',
			}).on('changeDate', function(ev){
				scope.$apply(function () {
					ngModel.$setViewValue(ev.date);
				});
			});
		}
	};
});
/*app.directive('calendar', function () {
	return {
		require: 'ngModel',
		link: function (scope, el, attr, ngModel) {
			$(el).datepicker({
				dateFormat: 'yyyy-mm-dd',
				onRender: function (dateText) {
					scope.$apply(function () {
						ngModel.$setViewValue(dateText);
					});
				}
			});
		}
	};
})*/



app.controller('DashboardController',function($scope,$http,$timeout){
    $scope.pageClass = 'page-home';
	var d = new Date();
	$scope.year = d.getFullYear();
	$scope.month = d.getMonth();
	
	var postData = function(pyear, pmonth){
		$http.post(url_base+'dashboard',{'year':pyear, 'month':pmonth}).success(function(data){
			$scope.fields = data.fields;
			$scope.results = data.results;
		});
		
		switch ($scope.month) {
			case 0 : $scope.month_str = 'Januari'; break;
			case 1 : $scope.month_str = 'Februari'; break;
			case 2 : $scope.month_str = 'Maret'; break;
			case 3 : $scope.month_str = 'April'; break;
			case 4 : $scope.month_str = 'Mei'; break;
			case 5 : $scope.month_str = 'Juni'; break;
			case 6 : $scope.month_str = 'Juli'; break;
			case 7 : $scope.month_str = 'Agustus'; break;
			case 8 : $scope.month_str = 'September'; break;
			case 9 : $scope.month_str = 'Oktober'; break;
			case 10 : $scope.month_str = 'November'; break;
			case 11 : $scope.month_str = 'Desember'; break;
		}
	}
	
	postData($scope.year, $scope.month);
    
	$scope.reloadPrev = function(){
		$scope.month = $scope.month - 1;
		postData($scope.year, $scope.month);
	}
	
	$scope.reloadNext = function(){
		$scope.month = $scope.month + 1;
		postData($scope.year, $scope.month);
	}
});