var app = angular.module('engagement', [
	'ngRoute','ngAnimate','angular-ladda','ui.bootstrap'
]);

app.config(['$routeProvider', function ($routeProvider) {
  $routeProvider
	// Home
	.when("/", {templateUrl:url_base+"src/outlet/home.html", controller: "dashboard_"})
	
	// Menus
	.when("/menu_categories", {templateUrl: url_base+"src/outlet/menus/categories.html", controller: "MenuCategoriesController"})
	.when("/menu_category_view/:eid", {templateUrl: url_base+"src/outlet/menus/category_view.html", controller: "ViewMenuCategoryController"})
	
	.when("/menus", {templateUrl: url_base+"src/outlet/menus/menus.html", controller: "MenusController"})
	.when("/menu_view/:eid", {templateUrl: url_base+"src/outlet/menus/menu_view.html", controller: "ViewMenuController"})
	
	// Outlets
	.when("/outlets", {templateUrl: url_base+"src/outlet/outlets/outlets.html", controller: "OutletsController"})
	.when("/outlet_view/:eid", {templateUrl: url_base+"src/outlet/outlets/outlet_view.html", controller: "ViewOutletController"})
	
	// Products
	.when("/product_categories", {templateUrl: url_base+"src/outlet/products/categories.html", controller: "ProductCategoriesController"})
	.when("/product_category_view/:eid", {templateUrl: url_base+"src/outlet/products/category_view.html", controller: "ViewProductCategoryController"})
	
	.when("/product_groups", {templateUrl: url_base+"src/outlet/products/groups.html", controller: "ProductGroupsController"})
	.when("/product_group_view/:eid", {templateUrl: url_base+"src/outlet/products/group_view.html", controller: "ViewProductGroupController"})
	
	.when("/products", {templateUrl: url_base+"src/outlet/products/products.html", controller: "ProductsController"})
	.when("/product_view/:eid", {templateUrl: url_base+"src/outlet/products/product_view.html", controller: "ViewProductController"})
	
	// Transactions
	// IN
	.when("/receiving", {templateUrl:url_base+"src/outlet/receiving/list_receiving.html", controller: "receiving"})
	.when("/receiving_new", {templateUrl:url_base+"src/outlet/receiving/new_receiving.html", controller: "receiving_new"})
	.when("/receiving/:id", {templateUrl:url_base+"src/outlet/receiving/detail_receiving.html", controller: "view_receiving"})
	.when("/receiving_edit/:id", {templateUrl:url_base+"src/outlet/receiving/edit_receiving.html", controller: "receiving_edit"})
	.when("/view_receiving/:id", {templateUrl:url_base+"src/outlet/receiving/view_receiving.html", controller: "view_pr"})
	
	.when("/purchases", {templateUrl:url_base+"src/outlet/purchases/purchases.html", controller: "PurchasesController"})
	.when("/purchase_new/:eid", {templateUrl:url_base+"src/outlet/purchases/purchase_new.html", controller: "NewPurchaseController"})
	.when("/purchase_view/:eid", {templateUrl:url_base+"src/outlet/purchases/purchase_view.html", controller: "ViewPurchaseController"})
	
	// OUT
	.when("/waste", {templateUrl:url_base+"src/outlet/waste/waste.html", controller: "waste"})
//	.when("/waste_add", {templateUrl:url_base+"src/outlet/waste/create_waste.html", controller: "waste_add"})
	.when("/waste_new", {templateUrl:url_base+"src/outlet/waste/create.html", controller: "waste_new"})
	.when("/view_waste/:id", {templateUrl:url_base+"src/outlet/waste/view_receiving.html", controller: "view_pr"})
	.when("/waste/:id", {templateUrl:url_base+"src/outlet/waste/view_waste.html", controller: "waste_id"})
	.when("/waste_edit/:id", {templateUrl:url_base+"src/outlet/waste/update_waste.html", controller: "waste_edit"})

	//waste by menu 
	.when('/waste_menu',{templateUrl:url_base+"src/outlet/waste_menu/list.html",controller:"waste_menu"})
	.when('/waste_menu_add',{templateUrl:url_base+"src/outlet/waste_menu/create.html",controller:"waste_menu_add"})
	.when('/waste_menu/:id',{templateUrl:url_base+"src/outlet/waste_menu/view.html",controller:"waste_menu_view"})
	.when('/waste_menu_edit/:id',{templateUrl:url_base+"src/outlet/waste_menu/edit.html",controller:"waste_menu_edit"})

	//ORDERING
	.when("/orders", {templateUrl:url_base+"src/outlet/orders/index.html", controller: "OrdersController"})
	.when("/order_new", {templateUrl:url_base+"src/outlet/orders/new.html", controller: "NewOrderController"})
	.when("/order_new/step2/:eid", {templateUrl:url_base+"src/outlet/orders/new_step2.html", controller: "NewOrder2Controller"})
	.when("/order_view/:eid", {templateUrl:url_base+"src/outlet/orders/view.html", controller: "ViewOrderController"})
	

	.when("/purchase", {templateUrl:url_base+"src/outlet/purchase/purchase.html", controller: "purchase"})
	.when("/purchase_add", {templateUrl:url_base+"src/outlet/purchase/create_purchase.html", controller: "purchase_add"})
//	.when("/view_purchase/:id", {templateUrl:url_base+"src/outlet/purchase/view_receiving.html", controller: "view_pr"})
	.when("/purchase/:id", {templateUrl:url_base+"src/outlet/purchase/view_purchase.html", controller: "purchase_id"})
	.when("/purchase_edit/:eid", {templateUrl:url_base+"src/outlet/purchase/update_purchase.html", controller: "EditPurchaseController"})
	
	.when("/sales_order", {templateUrl:url_base+"src/outlet/stock/sales_order.html", controller: "PageCtrl"})
	// Stock
	.when("/stock", {templateUrl:url_base+"src/outlet/stock/stock.html", controller: "StockController"})
	.when("/stock_opname", {templateUrl:url_base+"src/outlet/stock/stock_opname.html", controller: "StockOpnameController"})
	.when("/stock_opname_view/:eid", {templateUrl:url_base+"src/outlet/stock/stock_opname_view.html", controller: "ViewStockOpnameController"})
	.when("/stock_opname_new", {templateUrl:url_base+"src/outlet/stock/stock_opname_new.html", controller: "NewStockOpnameController"})
	.when("/stock_opname_new/:eid", {templateUrl:url_base+"src/outlet/stock/stock_opname_new.html", controller: "NewStockOpnameController"})
	
	// 
	.when("/closing", {templateUrl:url_base+"src/outlet/tools/closing.html", controller: "ClosingController"})
	
	.when("/drivers", {templateUrl: url_base+"src/outlet/masters/drivers.html", controller: "DriversController"})
	.when("/driver_view/:eid", {templateUrl: url_base+"src/outlet/masters/driver_view.html", controller: "ViewDriverController"})
	
	.when("/suppliers", {templateUrl: url_base+"src/outlet/masters/suppliers.html", controller: "SuppliersController"})
	.when("/supplier_new", {templateUrl: url_base+"src/outlet/masters/supplier_new.html", controller: "NewSupplierController"})
	.when("/supplier_new/:eid", {templateUrl: url_base+"src/outlet/masters/supplier_new.html", controller: "NewSupplierController"})
	
	//profile
	.when("/profile", {templateUrl: url_base+"src/outlet/profile.html", controller: "profile"})
	
	.otherwise("/404", {templateUrl: url_base+"src/page/404.html", controller: "PageCtrl"});
}]);

app.controller('PageCtrl', function($scope) {
	$scope.pageClass = 'page-home';
});


app.factory('StatusList', function(){
	var Statuses = {};
	Statuses.list = [{code:'1', name:'Aktif'}, {code:'0', name:'Tidak Aktif'}];
	return Statuses;
});


app.controller('produk_page', function ($scope, $http, $timeout) {
	$http.get(url_base+'index.php/master_products/find_all').success(function(data){
		$scope.list = data;	
		$scope.currentPage = 1; //current page
		$scope.entryLimit = 20; //max no of items to display in a page
		$scope.filteredItems = $scope.list.length; //Initially for no filter  
		$scope.totalItems = $scope.list.length;
	 });
	$scope.pageClass = 'page-home';
	$scope.setPage = function(pageNo) {
		$scope.currentPage = pageNo;
	};
	$scope.filter = function() {
		$timeout(function() { 
			$scope.filteredItems = $scope.filtered.length;
		}, 10);
	};
	$scope.sort_by = function(predicate) {
		$scope.predicate = predicate;
		$scope.reverse = !$scope.reverse;
	};

});

app.directive('onlyNumbers', function() {
	return function(scope, element, attrs) {
		var keyCode = [8,9,13,37,39,46,48,49,50,51,52,53,54,55,56,57,96,97,98,99,100,101,102,103,104,105,110,190];
		element.bind("keydown", function(event) {
		 if($.inArray(event.which,keyCode) == -1) {
			scope.$apply(function(){
				scope.$eval(attrs.onlyNum);
				event.preventDefault();
			});
				event.preventDefault();
			 }

			});
		};
});

app.directive('onlyIntegers', function() {
	return function(scope, element, attrs) {
		var keyCode = [8,9,13,35,36,37,39,48,49,50,51,52,53,54,55,56,57,127];
		element.bind("keydown", function(event) {
		 if($.inArray(event.which,keyCode) == -1) {
			scope.$apply(function(){
				scope.$eval(attrs.onlyNum);
				event.preventDefault();
			});
				event.preventDefault();
			 }

			});
		};
});

app.filter('startFrom', function() {
	return function(input, start) {
		if(input) {
			start = +start; //parse to int
			return input.slice(start);
		}
		return [];
	}
});


app.factory('UtilList', function($http)
{
	return {
		outletList: function(callback) {
			var url = url_base + 'master/outlets/';
			$http.get(url).success(callback);
		},
		menuActiveList: function(callback) {
			var url = url_base + 'master/menus/getActiveMenus';
			$http.get(url).success(callback);
		},
	}
});

app.directive('ngEnter', function () {
	return function (scope, element, attrs) {
		element.bind("keydown keypress", function (event) {
			if(event.which === 13) {
				scope.$apply(function (){
					scope.$eval(attrs.ngEnter);
				});

				event.preventDefault();
			}
		});
	};
});