var app = angular.module('engagement', [
	'ngRoute','ngAnimate','angular-ladda','ui.bootstrap'
]);

app.config(['$routeProvider', function ($routeProvider) {
  $routeProvider
	// Home
	.when("/", {templateUrl:url_base+"src/salesonline/home.html", controller: "SoHomeController"})
	.when("/homeX", {templateUrl:url_base+"src/salesonline/homeX.html", controller: "SoHomeController"})
	.when("/profile", {templateUrl: url_base+"src/salesonline/profile.html", controller: "profile"})

	//Product
	.when("/product", {templateUrl:url_base+"src/salesonline/product/product.html", controller: "SoProductController"})

	//Customer
	.when("/customer", {templateUrl:url_base+"src/salesonline/customer/customer.html", controller: "SoCustomerController"})
	.when("/customerEdit/:id", {templateUrl:url_base+"src/salesonline/customer/customerEdit.html", controller: "SoCustomerEditController"})

	//Sales
	.when("/salesHistory", {templateUrl:url_base+"src/salesonline/sales/salesHistory.html", controller: "SoSalesHistoryController"})
	.when("/salesNew", {templateUrl:url_base+"src/salesonline/sales/salesNew.html", controller: "SoSalesNewController"})
	.when("/salesView/:id", {templateUrl:url_base+"src/salesonline/sales/salesView.html", controller: "SoSalesViewController"})

	//Route
	.when("/routeHistory", {templateUrl:url_base+"src/salesonline/route/routeHistory.html", controller: "SoRouteHistoryController"})

	//Payment
	.when("/paymentHistory", {templateUrl:url_base+"src/salesonline/payment/paymentHistory.html", controller: "SoPaymentHistoryController"})
	.when("/paymentEdit/:id", {templateUrl:url_base+"src/salesonline/payment/paymentEdit.html", controller: "SoPaymentEditController"})


	//CustomerX
	.when("/customerX", {templateUrl:url_base+"src/salesonline/customer/customerX.html", controller: "SoCustomerController"})
	.when("/customerEditX/:id", {templateUrl:url_base+"src/salesonline/customer/customerEditX.html", controller: "SoCustomerEditController"})

	//SalesX
	.when("/salesHistoryX", {templateUrl:url_base+"src/salesonline/sales/salesHistoryX.html", controller: "SoSalesHistoryController"})
	.when("/salesNewX", {templateUrl:url_base+"src/salesonline/sales/salesNewX.html", controller: "SoSalesNewController"})
	.when("/salesViewX/:id", {templateUrl:url_base+"src/salesonline/sales/salesViewX.html", controller: "SoSalesViewController"})

	//RouteX
	.when("/routeHistoryX", {templateUrl:url_base+"src/salesonline/route/routeHistoryX.html", controller: "SoRouteHistoryController"})
	.when("/routeNewX", {templateUrl:url_base+"src/salesonline/route/routeNewX.html", controller: "SoRouteNewController"})
	.when("/routeEditX/:id/:week/:day/:salesman/:customer", {templateUrl:url_base+"src/salesonline/route/routeEditX.html", controller: "SoRouteEditController"})

	//PaymentX
	.when("/paymentHistoryX", {templateUrl:url_base+"src/salesonline/payment/paymentHistoryX.html", controller: "SoPaymentHistoryController"})
	.when("/paymentEditX/:id", {templateUrl:url_base+"src/salesonline/payment/paymentEditX.html", controller: "SoPaymentEditController"})

	//Import
	.when("/importExport", {templateUrl:url_base+"src/salesonline/importExport/importExport.html", controller: "SoImportExportController"})

	//Attendance
	.when("/attendanceHistoryX", {templateUrl:url_base+"src/salesonline/attendance/attendanceX.html", controller: "AttendanceController"})
	/*.when("/attendanceEditX/:id", {templateUrl:url_base+"src/salesonline/attendance/attendanceEditX.html", controller: "EditAttendanceController"})*/

	.otherwise("/404", {templateUrl: url_base+"src/page/404.html", controller: "PageCtrl"});
}]);

app.controller('PageCtrl', function($scope) {
	$scope.pageClass = 'page-home';
});


app.factory('StatusList', function(){
	var Statuses = {};
	Statuses.list = [{code:'1', name:'Aktif'}, {code:'0', name:'Tidak Aktif'}];
	return Statuses;
});


app.controller('produk_page', function ($scope, $http, $timeout) {
	$http.get(url_base+'index.php/master_products/find_all').success(function(data){
		$scope.list = data;	
		$scope.currentPage = 1; //current page
		$scope.entryLimit = 20; //max no of items to display in a page
		$scope.filteredItems = $scope.list.length; //Initially for no filter  
		$scope.totalItems = $scope.list.length;
	 });
	$scope.pageClass = 'page-home';
	$scope.setPage = function(pageNo) {
		$scope.currentPage = pageNo;
	};
	$scope.filter = function() {
		$timeout(function() { 
			$scope.filteredItems = $scope.filtered.length;
		}, 10);
	};
	$scope.sort_by = function(predicate) {
		$scope.predicate = predicate;
		$scope.reverse = !$scope.reverse;
	};

});

app.directive('onlyNumbers', function() {
	return function(scope, element, attrs) {
		var keyCode = [8,9,13,37,39,46,48,49,50,51,52,53,54,55,56,57,96,97,98,99,100,101,102,103,104,105,110,190];
		element.bind("keydown", function(event) {
		 if($.inArray(event.which,keyCode) == -1) {
			scope.$apply(function(){
				scope.$eval(attrs.onlyNum);
				event.preventDefault();
			});
				event.preventDefault();
			 }

			});
		};
});

app.directive('onlyIntegers', function() {
	return function(scope, element, attrs) {
		var keyCode = [8,9,13,35,36,37,39,48,49,50,51,52,53,54,55,56,57,127];
		element.bind("keydown", function(event) {
		 if($.inArray(event.which,keyCode) == -1) {
			scope.$apply(function(){
				scope.$eval(attrs.onlyNum);
				event.preventDefault();
			});
				event.preventDefault();
			 }

			});
		};
});

app.filter('startFrom', function() {
	return function(input, start) {
		if(input) {
			start = +start; //parse to int
			return input.slice(start);
		}
		return [];
	}
});


app.factory('UtilList', function($http)
{
	return {
		outletList: function(callback) {
			var url = url_base + 'master/outlets/';
			$http.get(url).success(callback);
		},
		menuActiveList: function(callback) {
			var url = url_base + 'master/menus/getActiveMenus';
			$http.get(url).success(callback);
		},
	}
});

app.directive('ngEnter', function () {
	return function (scope, element, attrs) {
		element.bind("keydown keypress", function (event) {
			if(event.which === 13) {
				scope.$apply(function (){
					scope.$eval(attrs.ngEnter);
				});

				event.preventDefault();
			}
		});
	};
});