app.controller('BalanceSheetController', function($scope,$http, $timeout,$window) {
  $(window).off("keypress");
  $scope.ynextdrp = 0.00;
  $scope.ynextcrp = 0.00;
  $scope.pltotalrp = 0.00;

  $scope.acuHide = true;

  $("#bsDatepickerStart").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#bsDatepickerStart").on('changeDate',function(){
    $(this).datepicker("hide");
  });

   $("#bsDatepickerEnd").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#bsDatepickerEnd").on('changeDate',function(){
    $(this).datepicker("hide");
  });

  $http.get(url_base+'balancesheet/headAccount').success(function (records){
    $http.get(url_base+'balancesheet/lastMonthBalanceSheet').success(function (records2){
      $scope.balancesheetList = records2;

      $scope.ynextd = 0.00;
      $scope.ynextc = 0.00;

      for (var i = $scope.balancesheetList.length - 1; i >= 0; i--) {
        if ($scope.balancesheetList[i]['type'] == 0){
          $scope.balancesheetList[i]['debitprev'] = parseFloat($scope.balancesheetList[i]['debitprev']) + parseFloat($scope.balancesheetList[i]['saldo']);
        }
        else{
          $scope.balancesheetList[i]['creditprev'] = parseFloat($scope.balancesheetList[i]['creditprev']) + parseFloat($scope.balancesheetList[i]['saldo']);
        }
            
        if ($scope.balancesheetList[i]['acctype'] == 'd'){
          $scope.balancesheetList[i]['next'] = parseFloat($scope.balancesheetList[i]['debitprev']) - parseFloat($scope.balancesheetList[i]['creditprev']) + parseFloat($scope.balancesheetList[i]['debitcur']) - parseFloat($scope.balancesheetList[i]['creditcur']);
        }
        else {
          $scope.balancesheetList[i]['next'] = parseFloat($scope.balancesheetList[i]['creditprev']) - parseFloat($scope.balancesheetList[i]['debitprev']) - parseFloat($scope.balancesheetList[i]['debitcur']) + parseFloat($scope.balancesheetList[i]['creditcur']);
        }

        $scope.balancesheetList[i]['nextrp'] = convertToRp($scope.balancesheetList[i]['next']);
      };

      var total5 = 0;
      var total6 = 0;

      $scope.headAccountList = records;

      for (var i = $scope.headAccountList.length - 1; i >= 0; i--) {
        for (var j = $scope.balancesheetList.length - 1; j >= 0; j--) {
          if ($scope.headAccountList[i]['glno'] == $scope.balancesheetList[j]['head']){
            if ($scope.headAccountList[i]['glno'] != '4010000000' && $scope.headAccountList[i]['glno'] != '4020000000' && $scope.headAccountList[i]['glno'] != '510000000' && $scope.headAccountList[i]['glno'] != '5300000000' && $scope.headAccountList[i]['glno'] != '5200000000' && $scope.headAccountList[i]['glno'] != '6000000000' && $scope.headAccountList[i]['glno'] != '6100000000'){
              total5 = parseFloat(total5) + parseFloat($scope.balancesheetList[j]['next']);
            }
            else {
              total6 = parseFloat(total6) + parseFloat($scope.balancesheetList[j]['next']);
            }
          }
        };

        $scope.headAccountList[i]['xnext'] = total5;
        $scope.headAccountList[i]['xnextrp'] = convertToRp(total5);

        if ($scope.headAccountList[i]['acctype'] == 'd'){
          $scope.ynextd = parseFloat(total5) + parseFloat($scope.ynextd);
        }
        else {
          $scope.ynextc = parseFloat(total5) + parseFloat($scope.ynextc);
        }

        total5 = 0;
        $scope.$apply();
      };

      $scope.pltotalrp = convertToRp(-1 * parseFloat(total6));
      $scope.ynextdrp = convertToRp(parseFloat($scope.ynextd));
      $scope.ynextcrp = convertToRp((-1 * parseFloat(total6)) + parseFloat($scope.ynextc));

      $scope.acuHide = false;
      $scope.$apply();
    
      $scope.currentPage = 1;
      $scope.entryLimit = 50;
      $scope.filteredItems = $scope.headAccountList.length;
      $scope.totalItems = $scope.headAccountList.length;
    });
  });

  $scope.setPage = function(pageNo) {
    $scope.currentPage = pageNo;
  };

  function convertToRp(input){
    var rp = '';    
    input = parseFloat(input).toFixed(2);
    var angkarev = input.toString().split('').reverse().join('');
    var dec = angkarev.substr(0,2).split('').reverse().join('');
    var num = angkarev.substr(3,input.length-3).split('').reverse().join('');

    angkarev = num.toString().split('').reverse().join('');

    for(var i = 0; i < angkarev.length; i++){
      if(i%3 == 0){
        rp += angkarev.substr(i,3)+'.';
      } 
    } 

    var output = rp.split('',rp.length-1).reverse().join('')+','+dec;

    if (output.substr(0,1) == '-' && output.substr(1,1) == '.'){
      output = '-'+output.substr(2,output.length-2);
    }

    return output;
  }

  $scope.filter = function() {
    $timeout(function() { 
      $scope.filteredItems = $scope.filtered.length;
    }, 50);
  };

  $scope.generateBalanceSheet = function(isgen,status){
    if ($("#bsDatepickerStart").val() == ''){
      $.growl.notice({ message: "Fill in Start Date" });
    }
    else if($("#bsDatepickerEnd").val() == ''){
      $.growl.notice({ message: "Fill in End Date" });
    }
    else if(Date.parse($("#bsDatepickerStart").val()) > Date.parse($("#bsDatepickerEnd").val())){
      $.growl.notice({ message: "Start Date must be lower than End Date" });
    }
    else{
      if(!isgen){
        $scope.loading = true; 
      };

      $scope.inputDate = {"start":$("#bsDatepickerStart").val(),"end":$("#bsDatepickerEnd").val()};

      var json = JSON.stringify($scope.inputDate);

      $.ajax({
        type: 'post',
        url:url_base+'balancesheet/generateBalanceSheet',
        data: "json="+json,
        success: function(msg){
          $scope.balancesheetList = JSON.parse(msg);

          $timeout(function(){       
            if(!isgen){
              if ($scope.balancesheetList[0]['status'] == 'sukses') {
                $scope.ynextd = 0;
                $scope.ynextc = 0;

                for (var i = $scope.balancesheetList.length - 1; i >= 0; i--) {
                  if ($scope.balancesheetList[i]['type'] == 0){
                    $scope.balancesheetList[i]['debitprev'] = parseFloat($scope.balancesheetList[i]['debitprev']) + parseFloat($scope.balancesheetList[i]['saldo']);
                  }
                  else{
                    $scope.balancesheetList[i]['creditprev'] = parseFloat($scope.balancesheetList[i]['creditprev']) + parseFloat($scope.balancesheetList[i]['saldo']);
                  }

                  if ($scope.balancesheetList[i]['acctype'] == 'd'){
                    $scope.balancesheetList[i]['next'] = parseFloat($scope.balancesheetList[i]['debitprev']) - parseFloat($scope.balancesheetList[i]['creditprev']) + parseFloat($scope.balancesheetList[i]['debitcur']) - parseFloat($scope.balancesheetList[i]['creditcur']);
                  }
                  else {
                    $scope.balancesheetList[i]['next'] = parseFloat($scope.balancesheetList[i]['creditprev']) - parseFloat($scope.balancesheetList[i]['debitprev']) - parseFloat($scope.balancesheetList[i]['debitcur']) + parseFloat($scope.balancesheetList[i]['creditcur']);
                  }

                  $scope.balancesheetList[i]['nextrp'] = convertToRp($scope.balancesheetList[i]['next']);
                };

                var total5 = 0;
                var total6 = 0;

                for (var i = $scope.headAccountList.length - 1; i >= 0; i--) {
                  for (var j = $scope.balancesheetList.length - 1; j >= 0; j--) {
                    if ($scope.headAccountList[i]['glno'] == $scope.balancesheetList[j]['head']){
                      if ($scope.headAccountList[i]['glno'] != '4010000000' && $scope.headAccountList[i]['glno'] != '4020000000' && $scope.headAccountList[i]['glno'] != '510000000' && $scope.headAccountList[i]['glno'] != '5300000000' && $scope.headAccountList[i]['glno'] != '5200000000' && $scope.headAccountList[i]['glno'] != '6000000000' && $scope.headAccountList[i]['glno'] != '6100000000'){
                        total5 = parseFloat(total5) + parseFloat($scope.balancesheetList[j]['next']);
                      }
                      else {
                        total6 = parseFloat(total6) + parseFloat($scope.balancesheetList[j]['next']);
                      }
                    }
                  };

                  $scope.headAccountList[i]['xnext'] = total5;
                  $scope.headAccountList[i]['xnextrp'] = convertToRp(total5);

                  if ($scope.headAccountList[i]['acctype'] == 'd'){
                    $scope.ynextd = parseFloat(total5) + parseFloat($scope.ynextd);
                  }
                  else {
                    $scope.ynextc = parseFloat(total5) + parseFloat($scope.ynextc);
                  }

                  total5 = 0;
                  $scope.$apply();
                };

                $scope.pltotalrp = convertToRp(-1 * parseFloat(total6));
                $scope.ynextdrp = convertToRp(parseFloat($scope.ynextd));
                $scope.ynextcrp = convertToRp((-1 * parseFloat(total6)) + parseFloat($scope.ynextc));

                $scope.currentPage = 1;
                $scope.entryLimit = 50;
                $scope.filteredItems = $scope.headAccountList.length;
                $scope.totalItems = $scope.headAccountList.length;
                $scope.$apply();

                $.growl.notice({ message: "Process done" });
              } 
              else {
                $.growl.error({ message: "Process failed. Try again !" });
              };
              $scope.loading = false;
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
            }
            $.growl.error({ message: "Failed. <br/>Check connection and try again !" });
          },1000);
        }
      });
    }
  }

  /*function makeTableHTML(){
    var result = '';
    
    result += "<table width=560 border=1 class='table table-striped table-bordered'>";
    result += "<thead>";
    result += "<th width='15%'>GL No</th>";
    result += "<th width='50%'>Account</th>";
    result += "<th width='35%'>Total</th>";
    result += "</thead>";

    for (var i = 0; i < $scope.headAccountList.length; i++){
      if ($scope.headAccountList[i]['glno'] != '4010000000' && $scope.headAccountList[i]['glno'] != '4020000000' && $scope.headAccountList[i]['glno'] != '510000000' && $scope.headAccountList[i]['glno'] != '5200000000' && $scope.headAccountList[i]['glno'] != '5300000000' && $scope.headAccountList[i]['glno'] != '6000000000' && $scope.headAccountList[i]['glno'] != '6100000000'){
        result += "<tr>";
        result += "<td align='center'>"+$scope.headAccountList[i]['glno']+"</td>";
        result += "<td align='center'>"+$scope.headAccountList[i]['accountname']+"</td>";
        result += "<td>"+$scope.headAccountList[i]['xtotalrp']+"</td>";
        result += "</tr>";

        if ($scope.balancesheetList.length == 0){
          result += "<tr><td align='center' colspan='5' style='color:red;font-weight:bold;'>Tidak ditemukan data dalam Periode yang telah diinput.</td></tr>";
        }
      }
    }

    result += "<tr>";
    result += "<td align='center' colspan='2'>PROFIT / LOSS</td>";
    result += "<td>"+$scope.pltotalrp+"</td>";
    result += "</tr>";

    result += "<br>";
    result += "</table>";

    result += "<br>";
    result += "<h2>BALANCE SHEET : "+$scope.ytotalrp+"</h2>";

    return result;
  }

  $scope.printToCart = function() {
    var popupWinindow = window.open('', '_blank', 'width=600,height=700,scrollbars=yes,menubar=no,toolbar=no,location=no,status=no,titlebar=no');
    popupWinindow.document.open();
    popupWinindow.document.write('<html><body onload="window.print()">' + makeTableHTML() + '</html>');
    popupWinindow.document.close();
  }
  */

});
