app.controller('CancelMenuController',function($scope, $http, $timeout){
    $scope.pageClass = 'page-home';
    $http.get(url_base+'cancel_menu').success(function(data){
        $scope.list = data; 
        $scope.currentPage = 1; //current page
        $scope.entryLimit = 25; //max no of items to display in a page
        $scope.filteredItems = $scope.list.length; //Initially for no filter  
        $scope.totalItems = $scope.list.length;
     });
    $scope.setPage = function(pageNo) {
        $scope.currentPage = pageNo;
    };

    $scope.filter = function() {
        $timeout(function() { 
            $scope.filteredItems = $scope.filtered.length;
        }, 25);
    };
});


app.controller('NewCancelMenuController',function($scope,$http,$timeout,$location){
    $scope.pageClass = 'page-home';
    $http.get(url_base+'waste_menu/find_all').success(function(data){
        $scope.list = data; 
        $scope.currentPage = 1; //current page
        $scope.entryLimit = 10; //max no of items to display in a page
        $scope.filteredItems = $scope.list.length; //Initially for no filter  
        $scope.totalItems = $scope.list.length;
     });

    $http.get(url_base+'cancel_menu/header_data').success(function(data){
        $scope.header = data;
    });

    $scope.setPage = function(pageNo) {
        $scope.currentPage = pageNo;
    };
    $scope.filter = function() {
        $timeout(function() { 
            $scope.filteredItems = $scope.filtered.length;
        }, 10);
    };
    $scope.add_item = function(data){
        $('#modal_list_product').modal({
            backdrop:false,
        });
		$('#product_items_filter').focus();
    }
    $scope.modal_product_hide = function(){
        $('#modal_list_product').modal('hide');
    }
    $scope.current_open;
    $scope.data_cancelmenu = [];
    $scope.open_detail = function(data){
        $('#modal_confirmation').modal({show:true,backdrop:false,});
		$('#field_name').html(data.menu_name);
		$('#quantity_item').val("");
        $('#comments').val("");
        $('#form_qty').removeClass('has-error');
        $('.help-block').html('');
		$('#quantity_item').focus();
        $scope.current_open = data;
    }

    $scope.modal_confirmation_close = function(){
        $('#quantity_item').val("");
        $('#comments').val("");
        $('#modal_confirmation').modal('hide');
        $('#form_qty').removeClass('has-error');
        $('.help-block').html('')
    }

    $scope.modal_confirmation_add = function(){
        if ($('#quantity_item').val() == '' || $('#quantity_item').val() == '0') {
            $('#form_qty').addClass('has-error');
            $('.help-block').html('data jumlah tidak boleh kosong atau 0')
        } else{
            $scope.current_open.comments = $('#comments').val();
            $scope.insert_temporary();
            $('#quantity_item').val("");
            $('#comments').val("");
            $('#modal_confirmation').modal('hide');
            $('#form_qty').removeClass('has-error');
            $('.help-block').html('')
        };
    }

    $scope.insert_temporary = function(){
        if ($scope.cek_avaliable() == true) {
            $scope.replaces_data();
        } else{
            $scope.add_data();
        };
    }

    $scope.replaces_data = function(){
        var data_temp = [];
        for (var i = $scope.data_cancelmenu.length - 1; i >= 0; i--) {
            var temp = $scope.data_cancelmenu[i];
            if (temp.menu_code == $scope.current_open.menu_code) {
                var sumarize = parseFloat(temp.qty)+parseFloat($('#quantity_item').val());
                $scope.current_open.qty = sumarize;
                data_temp.push($scope.current_open);
            }else{
                data_temp.push(temp);
            };
        };
        $scope.data_cancelmenu = data_temp;
    }

    $scope.add_data = function(){
        $scope.current_open.qty = $('#quantity_item').val();
        $scope.data_cancelmenu.push($scope.current_open);
    }

    $scope.cek_avaliable = function(){
        var check_avaliable  = false;
        for (var i = $scope.data_cancelmenu.length - 1; i >= 0; i--) {
            var temp = $scope.data_cancelmenu[i];
            if (temp.product_code == $scope.current_open.product_code) {
                cek_avaliable = true;
                return true;
            };
        };

        return check_avaliable;
    }

    $scope.temp_delete;

    $scope.remove_data = function(data){
        $scope.temp_delete = data;
		$('#del_field_name').html($scope.temp_delete.product_name);
		$('#del_field_qty').html($('#fixed_qty_'+$scope.temp_delete.product_code).val()+' '+$scope.temp_delete.unit_large);
        $('#modal_confirmation_delete').modal({
            backdrop:false,
            show:true
        });
    }

    $scope.modal_confirmation_yes = function(){
        var data_temp = [];
        for (var i = $scope.data_cancelmenu.length - 1; i >= 0; i--) {
            var temp = $scope.data_cancelmenu[i];
            if (temp.product_code == $scope.temp_delete.product_code) {
            }else{
                data_temp.push(temp);
            };
        };
        $scope.data_cancelmenu = data_temp;
        $('#modal_confirmation_delete').modal('hide');
    }

    $scope.modal_confirmation_no = function(){
        $('#modal_confirmation_delete').modal('hide');
    }

    $scope.post_data = function(){
            if ($scope.data_cancelmenu.length > 0) {
                $scope.loading = true; 
                var data = JSON.stringify($scope.get_data_post());
                $.ajax({
                    url:url_base+'waste_menu/create_waste',
                    type:'post',
                    data:'json='+data,
                    dataType:'json',
					success:function(msg){
						$timeout(function(){
							$scope.loading = false;
							if (msg.status == 'success') {
								$.growl.notice({ message: "Data BERHASIL di Simpan" });
								$location.path('/waste_menu/'+msg.pk, false);
							} else {
								$.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
							};
						},1000);
					},
					error: function(XMLHttpRequest, textStatus, errorThrown) {
						$timeout(function(){
							$scope.loading = false;
							$.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
						},5000);
					}
                });
                //console.log(data);
            }else{
                $.growl.warning({ message: "Belum ada data untuk di simpan" });
            };
    }

    $scope.get_data_post = function(){
            var data_post = [];
            for (var i = $scope.data_cancelmenu.length - 1; i >= 0; i--) {
                       var data =  $scope.data_cancelmenu[i];
                       data.qty = $('#fixed_qty_'+data.product_code).val();
                       data_post.push(data);
            };        
            return data_post;
    }
});


app.controller('ViewCancelMenuController',['$scope','$routeParams','$http',
    function($scope,$routeParams,$http)
	{
        var pk = $routeParams.eid;
        $scope.pid = $routeParams.eid;
		$scope.detail = [];
        $http.get(url_base+'cancel_menu/viewCancelmenu/'+pk).success(function(data){
            $scope.header = data.header;
			$scope.detail = data.body;
         });
        $scope.pageClass = 'page-home';
		
		$scope.getTotal = function(){
			var total = 0;
			for(var i = 0; i < $scope.detail.length; i++){
				var menu = $scope.detail[i];
				total += (menu.qty * menu.price * 1.1 * 1.05);
			}
			return total;
		}
	}
]);