app.controller('CostIncomeNewController', function($scope,$http, $timeout) {
  $scope.journalDetail = [];
  $scope.journalDebit = 0;
  $scope.journalCredit = 0;
  $scope.journalDelta = 0;
  $scope.type = 0;
  $scope.invisible = true;

  $scope.journalDetail.push({"glno":"","accountname":"","debit":"0","credit":"0","type":""});

  $("#ciDatepickerNew").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#ciDatepickerNew").on('changeDate',function(){
    $(this).datepicker("hide");
  });

  $(document).on('change', function() {
    for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
      $scope.journalDetail[i].glno = $("#g"+i).val();
      $scope.journalDetail[i].accountname = $("#g"+i+" :selected").text();

      for (var j = $scope.glAccountList.length - 1; j >= 0; j--){
        if ($scope.glAccountList[j].glno == $("#g"+i).val()){
          $scope.journalDetail[i].type = $scope.glAccountList[j].type;
        }
      }

      $scope.$apply();
    };
  })

  function convertToRp(input){
    var rp = '';    
    input = parseFloat(input).toFixed(2);
    var angkarev = input.toString().split('').reverse().join('');
    var dec = angkarev.substr(0,2).split('').reverse().join('');
    var num = angkarev.substr(3,input.length-3).split('').reverse().join('');

    angkarev = num.toString().split('').reverse().join('');

    for(var i = 0; i < angkarev.length; i++){
      if(i%3 == 0){
        rp += angkarev.substr(i,3)+'.';
      } 
    } 

    var output = rp.split('',rp.length-1).reverse().join('')+','+dec;

    if (output.substr(0,1) == '-' && output.substr(1,1) == '.'){
      output = '-'+output.substr(2,output.length-2);
    }

    return output;
  }

  function total(type){
    var total = 0;

    for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
      if (type == 0){
        total = parseFloat($scope.journalDetail[i]['debit']) + parseFloat(total);
      }
      else {
        total = parseFloat($scope.journalDetail[i]['credit']) + parseFloat(total);
      }
    };

    return total;
  };

  function newId(count){
    var embed = 0;
    var zero = 'CI';

    embed = 10-(count.length+2);

    for (var i = 0; i < embed; i++){
      zero = zero + 0;
    }

    return zero;
  }

  $scope.checkRequirement = function(){
    var temp = 0;

    for(i=0;i<$scope.newDesc.length;i++) {
      if($scope.newDesc[i] == '&' || $scope.newDesc[i] == '|' || $scope.newDesc[i] == '$' || $scope.newDesc[i] == '^' || $scope.newDesc[i] == '<' || $scope.newDesc[i] == '>'){
        temp++
      }
    }

    if (temp > 0) {
      $scope.invisible = false;
    }else{
      $scope.invisible = true;
    }
  }

  $scope.checkAccount = function() {
    if ($scope.type == 0){
      $http.get(url_base+'costincome/glAccountListCost').success(function (records){
        $scope.glAccountList = records;
      });
    }
    else{
      $http.get(url_base+'costincome/glAccountListIncome').success(function (records){
        $scope.glAccountList = records;
      });
    }
  };

  $scope.addRow = function() {
    if ($scope.journalDetail.length < 2){
      $scope.journalDetail.push({"glno":"","accountname":"","debit":"0","credit":"0","type":""});
    }
  };

  $http.get(url_base+'costincome/glAccountListCost').success(function (records){
    $scope.glAccountList = records;
  });

  $http.get(url_base+'costincome/getNewId').success(function (records){
    $scope.newTrans = newId(records[0]['newid'])+records[0]['newid'];
  });

  $scope.updateTotal = function(index,iscredit){
    if (iscredit == 0){
      var pId = "p"+index;
      var newVal = $("#"+pId).val();

      for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
        if (i == index) {
          $scope.journalDetail[i].debit = newVal;

          $("#"+pId).val(newVal);
        };
      };

      $scope.journalDebit = convertToRp(total(0));
    }
    else{
      var pId = "s"+index;
      var newVal = $("#"+pId).val();

      for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
        if (i == index) {
          $scope.journalDetail[i].credit = newVal;

          $("#"+pId).val(newVal);
        };
      };

      $scope.journalCredit = convertToRp(total(1));
    }

    $scope.journalDelta = convertToRp(Math.abs(total(0)-total(1)));
  };

  $scope.deleteCostIncome = function(index) {
    var no = index+1;
    if (confirm("Delete cost income with NO : "+no+"?")){
      $scope.journalDetail.splice(index,1);
      $scope.journalDebit = convertToRp(total(0));
      $scope.journalCredit = convertToRp(total(1));
      $scope.journalDelta = convertToRp(Math.abs(total(0)-total(1)));
      $scope.$apply();
    }
  };

  $scope.saveCostIncome = function(isgen,status) {
    var temp = '';
    var tempX = 0;
    var tempY = 0;
    var idem = 0;
    var valid = 0;
    var empty = 0;

    for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
      if ($scope.journalDetail[i].debit > 0 && $scope.journalDetail[i].credit > 0){
        valid = 1;
        break;
      }

      if ($scope.journalDetail[i].glno == "" || $scope.journalDetail[i].glno === null){
        empty = 1;
        break;
      }
     
      if (temp != $scope.journalDetail[i].glno && idem == 0){
        temp = $scope.journalDetail[i].glno;
      }
      else{
        idem = 1; 
      }

      if ($scope.journalDetail[i].debit > $scope.journalDetail[i].credit){
        $scope.journalDetail[i].iscredit = 0;
      }
      else{
        $scope.journalDetail[i].iscredit = 1;
      }

      if ($scope.journalDetail[i].type == 'X'){
        tempX = 1;
      }

      if ($scope.journalDetail[i].type == 'Y'){
        tempY = 1;
      }

      $scope.journalDetail[i].jumlah = parseFloat($scope.journalDetail[i].debit) + parseFloat($scope.journalDetail[i].credit);
    };

    if ($("#ciDatepickerNew").val() === ''){
      $.growl.warning({ message: 'Choose Journal Date' });
    }
    else if ($scope.invisible == false){
      $.growl.warning({ message: 'Description Field Is Not Valid' });
    }
    else if ($scope.journalDelta != '0,00'){
      $.growl.warning({ message: 'Unbalance' });
    }
    else if (idem == 1){
      $.growl.warning({ message: 'Duplicate GL Account' });
    }
    else if (valid == 1){
      $.growl.warning({ message: 'Fill Only Debit / Credit' });
    }
    else if (empty == 1){
      $.growl.warning({ message: 'Empty Account' });
    }
    else if (tempX == 0 || tempY == 0){
      $.growl.warning({ message: 'Account [X-Y] Does Not Match' });
    }
    else {
      $http.get(url_base+'costincome/getNewId').success(function (records){
        $scope.newTrans = newId(records[0]['newid'])+records[0]['newid'];
      });

      if ($scope.newDesc === undefined || $scope.newDesc === "") {
        $scope.newDesc = '-'
      }

      if (!isgen){
        $scope.loading = true; 
      };

      $scope.journalHeader = {"noTrans":$scope.newTrans,"keterangan":"Cost Income | "+$scope.newTrans+" | "+$scope.newDesc,"date":$("#ciDatepickerNew").val()};

      var json = JSON.stringify($scope.journalDetail);
      var json2 = JSON.stringify($scope.journalHeader);
      
      $.ajax({
        type: 'post',
        url:url_base+'costincome/insertCostIncome',
        data: "json="+json+"&json2="+json2,
        success: function(msg){
          var obj = JSON.parse(msg);
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              if (obj.status == 'sukses') {
                $.growl.notice({ message: "Data inserted" });

                $scope.journalDetail = [];
                $scope.journalDebit = 0;
                $scope.journalCredit = 0;
                $scope.journalDelta = 0;
                $http.get(url_base+'costincome/getNewId').success(function (records){
                  $scope.newTrans = newId(records[0]['newid'])+records[0]['newid'];
                });
                $scope.newDesc = "";
                $("#ciDatepickerNew").val("");

                $scope.journalDetail.push({"glno":"","accountname":"","debit":"0","credit":"0","type":""});
                $scope.$apply();
              } 
              else {
                $.growl.error({ message: "Insert failed. Try again !" });
              };
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
            }
            $.growl.error({ message: "Insert failed. <br/>Check connection and try again !" });
          },1000);
        } 
      });
    }
  };

});


