app.controller('LedgerController', function($scope,$http, $timeout,$window) {
  $(window).off("keypress");
  $scope.journal = [];
  $scope.journal2 = [];

  $("#ledDatepickerStart").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#ledDatepickerStart").on('changeDate',function(){
    $(this).datepicker("hide");
  });

   $("#ledDatepickerEnd").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#ledDatepickerEnd").on('changeDate',function(){
    $(this).datepicker("hide");
  });

  $http.get(url_base+'ledger/glAccountList').success(function (records){
    $scope.glAccountList = records;
  });

  $scope.setPage = function(pageNo) {
    $scope.currentPage = pageNo;
  };

  $scope.filter = function() {
    $timeout(function() { 
      $scope.filteredItems = $scope.filtered.length;

      var debit = 0;
      var credit = 0;
      var saldo = 0;

      for (var i = 0; i < $scope.filtered.length; i++){
        for (var j = 0; j < $scope.filtered[i]['detail'].length; j++){      
          if ($scope.filtered[i]['detail'][j]['iscredit'] == 1){
            saldo = parseFloat(saldo) - parseFloat($scope.filtered[i]['detail'][j]['jumlah']);
            credit = parseFloat(credit) + parseFloat($scope.filtered[i]['detail'][j]['jumlah']);
          }
          else{
            saldo = parseFloat(saldo) + parseFloat($scope.filtered[i]['detail'][j]['jumlah']);
            debit = parseFloat(debit) + parseFloat($scope.filtered[i]['detail'][j]['jumlah']);
          }

          $scope.filtered[i]['detail'][j]['saldo'] = convertToRp(saldo);
        }
      }

      $scope.journalDebit = convertToRp(debit);
      $scope.journalCredit = convertToRp(credit);
      $scope.journalDelta = convertToRp(Math.abs(debit-credit));
      $scope.$apply();
    }, 50);
  };

  function total(type){
    var total = 0;

    for (var i = $scope.journal.length - 1; i >= 0; i--) {
      if ($scope.journal[i]['iscredit'] == type){
        total = parseFloat($scope.journal[i]['jumlah']) + parseFloat(total);
      }
    };

    return total;
  };

  function convertToRp(input){
    var rp = '';    
    input = parseFloat(input).toFixed(2);
    var angkarev = input.toString().split('').reverse().join('');
    var dec = angkarev.substr(0,2).split('').reverse().join('');
    var num = angkarev.substr(3,input.length-3).split('').reverse().join('');

    angkarev = num.toString().split('').reverse().join('');

    for(var i = 0; i < angkarev.length; i++){
      if(i%3 == 0){
        rp += angkarev.substr(i,3)+'.';
      } 
    } 

    var output = rp.split('',rp.length-1).reverse().join('')+','+dec;

    if (output.substr(0,1) == '-' && output.substr(1,1) == '.'){
      output = '-'+output.substr(2,output.length-2);
    }

    return output;
  }

  $http.get(url_base+'ledger/lastMonthLedger').success(function (records){
    $scope.journal = records;
    var temp = '';
    var j = 0;
    var k = 0;
    var saldo = 0;

    for (var i = 0; i < $scope.journal.length; i++){
      if (temp != $scope.journal[i]['journalid']){
        $scope.journal2[j] = {journalid:$scope.journal[i]['journalid'],tanggal:$scope.journal[i]['tanggal'],keterangan:$scope.journal[i]['keterangan'],notrans:$scope.journal[i]['notrans'],detail:[]};
        temp = $scope.journal[i]['journalid'];
        j++;
        k = 0;
      }

      if ($scope.journal[i]['iscredit'] == 1){
        saldo = parseFloat(saldo) - parseFloat($scope.journal[i]['jumlah']);
      }
      else{
        saldo = parseFloat(saldo) + parseFloat($scope.journal[i]['jumlah']);
      }

      $scope.journal2[j-1]['detail'][k] = {glno:$scope.journal[i]['glno'],accountname:$scope.journal[i]['accountname'],iscredit:$scope.journal[i]['iscredit'],jumlah:$scope.journal[i]['jumlah'],jumlah2:convertToRp($scope.journal[i]['jumlah']),saldo:convertToRp(saldo)};
      k++;
    }

    $scope.currentPage = 1;
    $scope.entryLimit = 25;
    $scope.filteredItems = $scope.journal2.length;
    $scope.totalItems = $scope.journal2.length;

    $scope.journalDebit = convertToRp(total(0));
    $scope.journalCredit = convertToRp(total(1));
    $scope.journalDelta = convertToRp(Math.abs(total(0)-total(1)));
  });

  $scope.newTab = function(id){
    $window.open('#/ledger2/'+id);
  };


  $scope.generateLedger = function(){
    if ($("#ledDatepickerStart").val() == ''){
      $.growl.notice({ message: "Fill in Start Date" });
    }
    else if($("#ledDatepickerEnd").val() == ''){
      $.growl.notice({ message: "Fill in End Date" });
    }
    else if(Date.parse($("#ledDatepickerStart").val()) > Date.parse($("#ledDatepickerEnd").val())){
      $.growl.notice({ message: "Start Date must be lower than End Date" });
    }
    else{
      if ($scope.account === undefined) {
        $scope.account = '0000000000'
      }

      $scope.inputDate = {"start":$("#ledDatepickerStart").val(),"end":$("#ledDatepickerEnd").val(),"account":$scope.account};

      var json = JSON.stringify($scope.inputDate);

      $.ajax({
        type: 'post',
        url:url_base+'ledger/generateLedger',
        data: "json="+json,
        success: function(msg){
          $scope.journal = JSON.parse(msg);
          $scope.journal2 = [];
          var temp = '';
          var j = 0;
          var k = 0;
          var saldo = 0

          for (var i = 0; i < $scope.journal.length; i++){
            if (temp != $scope.journal[i]['journalid']){
              $scope.journal2[j] = {journalid:$scope.journal[i]['journalid'],tanggal:$scope.journal[i]['tanggal'],keterangan:$scope.journal[i]['keterangan'],notrans:$scope.journal[i]['notrans'],detail:[]};
              temp = $scope.journal[i]['journalid'];
              j++;
              k = 0;
            }

            if ($scope.journal[i]['iscredit'] == 1){
              saldo = parseFloat(saldo) - parseFloat($scope.journal[i]['jumlah']);
            }
            else{
              saldo = parseFloat(saldo) + parseFloat($scope.journal[i]['jumlah']);
            }

            $scope.journal2[j-1]['detail'][k] = {glno:$scope.journal[i]['glno'],accountname:$scope.journal[i]['accountname'],iscredit:$scope.journal[i]['iscredit'],jumlah:$scope.journal[i]['jumlah'],jumlah2:convertToRp($scope.journal[i]['jumlah']),saldo:convertToRp(saldo)};
            k++;
          }

          $scope.currentPage = 1;
          $scope.entryLimit = 25;
          $scope.filteredItems = $scope.journal2.length;
          $scope.totalItems = $scope.journal2.length;

          $scope.journalDebit = convertToRp(total(0));
          $scope.journalCredit = convertToRp(total(1));
          $scope.journalDelta = convertToRp(Math.abs(total(0)-total(1)));

          $scope.$apply();
        },
        error: function() {
          $.growl.error({ message: "Failed. <br/>Check connection and try again !" });
        } 
      });
    }
  }

  function makeLedger(){
    var result = '';

    result += "<h4>Date : "+$("#ledDatepickerStart").val()+" to "+$("#ledDatepickerEnd").val()+"</h4>";
    result += "<h4>Account : "+$scope.journal[1]['accountname']+"</h4>";

    result += "<table width=1100 border=1 class='table table-striped table-bordered'>";

    result += "<thead>";
    result += "<th>ID</th>";
    result += "<th>Date</th>";
    result += "<th>Description</th>";
    //result += "<th>No Trans</th>";
    result += "<th>Debit</th>";
    result += "<th>Credit</th>";
    result += "<th>Saldo</th>";
    result += "</thead>";

    for (var i = 0; i < $scope.journal2.length; i++){
      result += "<tr>";
      result += "<td>"+$scope.journal2[i]['journalid']+"</td>";
      result += "<td>"+$scope.journal2[i]['tanggal']+"</td>";
      result += "<td>"+$scope.journal2[i]['keterangan']+"</td>";
      //result += "<td>"+$scope.journal2[i]['notrans']+"</td>";

      for (var j = 0; j < $scope.journal2[i]['detail'].length; j++){
        if ($scope.journal2[i]['detail'][j]['iscredit'] == 0){
          result += "<td>"+$scope.journal2[i]['detail'][j]['jumlah2']+"</td>";
          result += "<td>0,00</td>";
        }
        else{
          result += "<td>0,00</td>";
          result += "<td>"+$scope.journal2[i]['detail'][j]['jumlah2']+"</td>";
        }
       
        result += "<td>"+$scope.journal2[i]['detail'][j]['saldo']+"</td>";
      }
      result += "</tr>";
    }

    if ($scope.journal2.length == 0){
      result += "<tr><td align='center' colspan='7' style='color:red;font-weight:bold;'>Tidak ditemukan data dalam Periode yang telah diinput.</td></tr>";
    }

    result += "</table>";
    result += "<br>";

    result += "<br>";
    result += "<h2>Debit : "+$scope.journalDebit+"</h2>";
    result += "<h2>Credit : "+$scope.journalCredit+"</h2>";
    result += "<h2>Delta : "+$scope.journalDelta+"</h2>";

    return result;
  }

  $scope.printLedger = function() {
    var popupWinindow = window.open('', '_blank', 'width=1130,height=700,scrollbars=yes,menubar=no,toolbar=no,location=no,status=no,titlebar=no');
    popupWinindow.document.open();
    popupWinindow.document.write('<html><body onload="window.print()">' + makeLedger() + '</html>');
    popupWinindow.document.close();
  }
});

app.controller('LedgerEditController',['$scope','$routeParams','$http','$timeout',
  function($scope,$routeParams,$http,$timeout){
    var id = $routeParams.id;
    $("#datepickerLedger").datepicker({
      format:"yyyy-mm-dd"
    });

    $("#datepickerLedger").on('changeDate',function(){
      $(this).datepicker("hide");
    });

    $(document).on('change', function() {
      for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
        $scope.journalDetail[i].glno = $("#g"+i).val();
        $scope.journalDetail[i].accountname = $("#g"+i+" :selected").text();
        $scope.$apply();
      };
    })

    function convertToRp(input){
      var rp = '';    
      input = parseFloat(input).toFixed(2);
      var angkarev = input.toString().split('').reverse().join('');
      var dec = angkarev.substr(0,2).split('').reverse().join('');
      var num = angkarev.substr(3,input.length-3).split('').reverse().join('');

      angkarev = num.toString().split('').reverse().join('');

      for(var i = 0; i < angkarev.length; i++){
        if(i%3 == 0){
          rp += angkarev.substr(i,3)+'.';
        } 
      } 

      var output = rp.split('',rp.length-1).reverse().join('')+','+dec;

      if (output.substr(0,1) == '-' && output.substr(1,1) == '.'){
        output = '-'+output.substr(2,output.length-2);
      }

      return output;
    }

    function total(type){
      var total = 0;

      for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
        if (type == 0){
          total = parseFloat($scope.journalDetail[i]['debit']) + parseFloat(total);
        }
        else {
          total = parseFloat($scope.journalDetail[i]['credit']) + parseFloat(total);
        }
      };

      return total;
    };

    $http.get(url_base+'ledger/getJournalHeader/'+id).success(function (records){
      $scope.journalId = records[0]['journalid'];
      $("#datepickerLedger").val(records[0]['tanggal']);
      $scope.journalDesc = records[0]['keterangan'];
      $scope.noTrans = records[0]['notrans'];
      $scope.createdBy = records[0]['dibuat'];
    });

    $http.get(url_base+'ledger/getJournalDetail/'+id).success(function (records){
      $scope.journalDetail = records;
      $scope.journalDebit = convertToRp(total(0));
      $scope.journalCredit = convertToRp(total(1));
      $scope.journalDelta = convertToRp(Math.abs(total(0)-total(1)));
    });

    $http.get(url_base+'ledger/glAccountList').success(function (records){
      $scope.glAccountList = records;
      $scope.glAccountList.splice(0,1);
    });

    $scope.addRow = function() {
      $scope.journalDetail.push({"journalid":id,"glno":"","accountname":"","debit":"0","credit":"0"});
      $scope.$apply();

      for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
        $scope.journalDetail[i].glno = $("#g"+i).val();
        $scope.journalDetail[i].accountname = $("#g"+i+" :selected").text();
        $scope.$apply();
      };
    };

    $scope.updateTotal = function(index,iscredit){
      if (iscredit == 0){
        var pId = "p"+index;
        var newVal = $("#"+pId).val();

        for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
          if (i == index) {
            $scope.journalDetail[i].debit = newVal;

            $("#"+pId).val(newVal);
          };
        };

        $scope.journalDebit = convertToRp(total(0));
      }
      else{
        var pId = "s"+index;
        var newVal = $("#"+pId).val();

        for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
          if (i == index) {
            $scope.journalDetail[i].credit = newVal;

            $("#"+pId).val(newVal);
          };
        };

        $scope.journalCredit = convertToRp(total(1));
      }

      $scope.journalDelta = convertToRp(Math.abs(total(0)-total(1)));
    };

    $scope.deleteJournal = function(index) {
      var no = index+1;
      if (confirm("Delete journal with NO : "+no+"?")){
        $scope.journalDetail.splice(index,1);
        $scope.journalDebit = convertToRp(total(0));
        $scope.journalCredit = convertToRp(total(1));
        $scope.journalDelta = convertToRp(Math.abs(total(0)-total(1)));
        $scope.$apply();
      }
    };

    $scope.saveJournal = function(isgen,status) {
      var temp = '';
      var idem = 0;
      var valid = 0;

      for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
        if ($scope.journalDetail[i].debit > 0 && $scope.journalDetail[i].credit > 0){
          valid = 1;
          break;
        }
       
        for (var j = $scope.journalDetail.length - 1 - ($scope.journalDetail.length - i); j >= 0; j--) {
          if ($scope.journalDetail[i].glno == $scope.journalDetail[j].glno){
            idem = 1; 
            break;
          }
        }

        if ($scope.journalDetail[i].debit > $scope.journalDetail[i].credit){
          $scope.journalDetail[i].iscredit = 0;
        }
        else{
          $scope.journalDetail[i].iscredit = 1;
        }

        $scope.journalDetail[i].jumlah = parseFloat($scope.journalDetail[i].debit) + parseFloat($scope.journalDetail[i].credit);
      };

      if ($scope.journalDelta != '0,00'){
        $.growl.warning({ message: 'Unbalance' });
      }
      else if (idem == 1){
        $.growl.warning({ message: 'Duplicate GL Account' });
      }
      else if (valid == 1){
        $.growl.warning({ message: 'Fill Only Debit / Credit' });
      }
      else {
        if(!isgen){
          $scope.loading = true; 
        };

        $scope.journalHeader = {"date":$("#datepickerLedger").val()};

        var json = JSON.stringify($scope.journalDetail);
        var json2 = JSON.stringify($scope.journalHeader);

        $.ajax({
          type: 'post',
          url:url_base+'ledger/editLedger',
          data: "json="+json+"&json2="+json2,
          success: function(msg){
            var obj = JSON.parse(msg);
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
                if (obj.status == 'sukses') {
                  $.growl.notice({ message: "Data updated" });
                } 
                else {
                  $.growl.error({ message: "Update failed. Try again !" });
                };
              }
            },1000);
          },
          error: function(XMLHttpRequest, textStatus, errorThrown) {
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
              }
              $.growl.error({ message: "Update failed. <br/>Check connection and try again !" });
            },1000);
          } 
        });
      }

    };

  }
]);


