app.controller('MenusController',function($scope, $http, $timeout){
    $scope.pageClass = 'page-home';
    $http.get(url_base+'master/menus').success(function(data){
        //console.log(data);
        $scope.list = data;
        $scope.currentPage = 1; //current page
        $scope.entryLimit = 25; //max no of items to display in a page
        $scope.filteredItems = $scope.list.length; //Initially for no filter
        $scope.totalItems = $scope.list.length;
     });
    $scope.setPage = function(pageNo) {
        $scope.currentPage = pageNo;
    };

    $scope.filter = function() {
        $timeout(function() { 
            $scope.filteredItems = $scope.filtered.length;
        }, 25);
    };
	
	$scope.delete_menu = function(did) {
		var strconfirm = confirm("Apakah Anda yakin menu dengan id '"+did+"' akan dihapus ?");
		if (strconfirm == true)
		{
			var url = url_base + 'master/menus/delete/' + did;
			var responseData = $http.delete(url);
			
			responseData.success(function(data, status, headers, config) {			
				$scope.list = data;
			});
			
			responseData.error(function(data, status, headers, config) {
				//alert("AJAX failed!");
			});
		}
	};
	
	$scope.exportExcel = function()
	{
		$http({
			url: url_base + 'master/menus/export',
			method: 'POST',
			dataType: 'json',
		})
		.success(function (data, status, headers, config)
		{
			window.open(data);
		})
		.error(function(data, status, headers, config) {
			alert("AJAX failed!");
		})
	}
}); 

app.controller("NewMenuController",function ($scope,$routeParams,$http,$timeout,StatusList,UtilList)
{ 
	var edit_id = +($routeParams.eid);
	$scope.save_success = '';
	$scope.save_error = '';
	$scope.statuses = StatusList.list;
	UtilList.menuCategories(function(data) {
		$scope.categories = data;
	});
	
	if((angular.isNumber(edit_id) && !isNaN(edit_id)) || (angular.isUndefined($routeParams.eid)))
	{
		if(angular.isNumber(edit_id) && !isNaN(edit_id))
		{
			$scope.title = 'Ubah Menu';	
			var url = url_base + 'master/menus/update/' + edit_id;

			var responseData = $http.get(url);
			responseData.success(function(data, status, headers, config) {
				$scope.menus = data.list[0];
				$scope.packages = data.packages;
				$scope.compositions = data.compositions;
				$scope.package_compositions = data.package_compositions;
				$scope.packagesItems = $scope.packages.length;
			});
			responseData.error(function(data, status, headers, config) {
				alert("Data tidak bisa di ambil !");
			});
		} else if(angular.isUndefined($routeParams.eid)) {
			$scope.title = 'Tambah Menu';
			$scope.menus = {};
			$scope.packages = {};
			$scope.compositions = {};
			$scope.package_compositions = {};
			$scope.packagesItems = 0;
		}
		
		$scope.submitForm = function (menus)
		{
			var edit_id = +($routeParams.eid);
			if(angular.isNumber(edit_id) && !isNaN(edit_id))
			{
				var url = url_base + 'master/menus/update/' + edit_id;
				var responseData = $http.post(url,{'Menus':menus});
			} else {
				var url = url_base + 'master/menus/create';
				var responseData = $http.post(url,{'Menus':menus});
			}
			
			responseData.success(function(data, status, headers, config)
			{
				$scope.save_success = '';
				if(data.success) {
					$scope.save_success = data.success.msg;
				}
				if(data.success) {
					$scope.save_success = data.success.msg;
					if(!(angular.isNumber(edit_id) && !isNaN(edit_id)))
						$routeParams.eid = data.menu[0].menu_id;
					$location.path('menu_new/' + $routeParams.eid, false);
				}
				$scope.save_error = '';
				if(data.error) {
					$scope.save_error = data.error.msg;
				}
				if(data.status) {		
					$location.path('menus');			
				}
			});
			
			responseData.error(function(data, status, headers, config) {
				//alert("AJAX failed!");
			});
		};
	} else {
		$scope.msg = 'Wrong url input';
	}
	
	$scope.add_compositions = function(){
		$('#modal_list_products').modal({
			backdrop:false,
		});
	}
	$scope.modal_product_hide = function(){
        $('#modal_list_products').modal('hide');
    }
	
	$scope.add_packages = function(){
		$('#modal_list_product').modal({
			backdrop:false,
		});
	}
});

app.controller("ModalProductListController",function ($scope,$routeParams,$http,$timeout)
{ 
	$http.get(url_base+'master/products').success(function(data)
	{
		$scope.list = data;
		$scope.currentPage = 1;
		$scope.entryLimit = 25;
		$scope.filteredItems = $scope.list.length;
		$scope.totalItems = $scope.list.length;
	});
	
	$scope.setPage = function(pageNo) {
		$scope.currentPage = pageNo;
	};

	$scope.filter = function() {
		$timeout(function() { 
			$scope.filteredItems = $scope.filtered.length;
		}, 25);
	};
	
	$scope.open_detail = function(data){
        $('#modal_confirmation').modal({show:true,backdrop:false,});
        $('.unit_s').html(data.menu_name);
        $('#qty_dinein').focus();
        $scope.current_open = data;
    }
	
	$scope.modal_confirmation_close = function(){
        $('#qty_dinein').val("");
		$('#qty_deltak').val("");
        $('#modal_confirmation').modal('hide');
        $('#form_qty').removeClass('has-error');
        $('.help-block').html('');
    }

    $scope.modal_confirmation_add = function(){
        if (($('#qty_dinein').val() == '' || $('#qty_dinein').val() == '0') && ($('#qty_deltak').val() == '' || $('#qty_deltak').val() == '0')) {
            $('#form_qty').addClass('has-error');
            $('.help-block').html('data jumlah tidak boleh kosong atau 0')
        } else{
            $scope.current_open.qty_dinein = $('#qty_dinein').val();
            $scope.current_open.qty_deltak = $('#qty_deltak').val();
            $scope.insert_temporary();
            $('#qty_dinein').val("");
			$('#qty_deltak').val("");
            $('#modal_confirmation').modal('hide');
            $('#form_qty').removeClass('has-error');
            $('.help-block').html('')
        };
    }
	
	$scope.insert_temporary = function(){
        //console.log($scope.current_open);
        if ($scope.cek_avaliable() == true) {
            $scope.replaces_data();
        } else{
            $scope.add_data();
        };
    }
});

app.controller("ViewMenuController",function ($scope,$routeParams,$http,$timeout)
{ 
	var view_id = +($routeParams.eid);

	if(angular.isNumber(view_id) && !isNaN(view_id))
	{
		$scope.title = 'View Menu';
		var url = url_base + 'master/menus/view/' + view_id;

		var responseData = $http.get(url);
		responseData.success(function(data, status, headers, config) {
			$scope.menus = data.list[0];
			$scope.packages = data.packages;
			$scope.compositions = data.compositions;
			$scope.package_compositions = data.package_compositions;
			$scope.packagesItems = $scope.packages.length;
		});
		responseData.error(function(data, status, headers, config) {
			alert("Data tidak bisa di ambil !");
		});
	} else {
		$scope.msg = 'Wrong url input';
	}
});


// CATEGORIES
app.controller('MenuCategoriesController',function($scope,$http,$timeout){
    $scope.pageClass = 'page-home';
    $http.get(url_base+'master/menu_categories').success(function(data){
        //console.log(data);
        $scope.list = data; 
        $scope.currentPage = 1; //current page
        $scope.entryLimit = 25; //max no of items to display in a page
        $scope.filteredItems = $scope.list.length; //Initially for no filter  
        $scope.totalItems = $scope.list.length;
     });
    $scope.setPage = function(pageNo) {
        $scope.currentPage = pageNo;
    };

    $scope.filter = function() {
        $timeout(function() { 
            $scope.filteredItems = $scope.filtered.length;
        }, 25);
    };
	
	$scope.delete_category = function(did) {
		var strconfirm = confirm("Apakah Anda yakin kategori dengan id '"+did+"' akan dihapus ?");
		if (strconfirm == true)
		{
			var url = url_base + 'master/menu_categories/delete/' + did;
			var responseData = $http.delete(url);
			
			responseData.success(function(data, status, headers, config) {			
				$scope.list = data;			
				//$(event.target).parent().parent().css('display','none');				
			});
			
			responseData.error(function(data, status, headers, config) {
				//alert("AJAX failed!");
			});
		}
	};
});


app.controller("NewMenuCategoryController",function ($scope,$routeParams,$location,$http,$timeout,StatusList)
{ 
	var edit_id = +($routeParams.eid);
	$scope.save_success = '';
	$scope.save_error = '';
	$scope.statuses = StatusList.list;

	if((angular.isNumber(edit_id) && !isNaN(edit_id)) || (angular.isUndefined($routeParams.eid)))
	{
		if(angular.isNumber(edit_id) && !isNaN(edit_id))
		{
			$scope.title = 'Ubah Kategori Menu';	
			var url = url_base + 'master/menu_categories/update/' + edit_id;

			var responseData = $http.get(url);
			responseData.success(function(data, status, headers, config) {			
				$scope.category = data[0];
			});
			responseData.error(function(data, status, headers, config) {
				//alert("AJAX failed!");
			});
		} else if(angular.isUndefined($routeParams.eid)) {
			$scope.title = 'Tambah Kategori Menu';
			$scope.category = {};
		}
		
		$scope.submitForm = function (category)
		{
			var edit_id = +($routeParams.eid);
			if(angular.isNumber(edit_id) && !isNaN(edit_id))
			{
				var url = url_base + 'master/menu_categories/update/' + edit_id;
				var responseData = $http.post(url,{'MenuCategories':category});
			} else {
				var url = url_base + 'master/menu_categories/create';
				var responseData = $http.post(url,{'MenuCategories':category});
			}
			
			responseData.success(function(data, status, headers, config)
			{
				$scope.save_success = '';
				if(data.success) {
					$scope.save_success = data.success.msg;
				}
				if(data.success) {
					$scope.save_success = data.success.msg;
					if(!(angular.isNumber(edit_id) && !isNaN(edit_id)))
						$routeParams.eid = data.category[0].category_id;
					$location.path('menu_category_new/' + $routeParams.eid, false);
				}
				$scope.save_error = '';
				if(data.error) {
					$scope.save_error = data.error.msg;
				}
				if(data.status) {		
					$location.path('menu_categories');			
				}
			});
			
			responseData.error(function(data, status, headers, config) {
				//alert("AJAX failed!");
			});
		};
	} else {
		$scope.msg = 'Wrong url input';
	}
});

app.controller("ViewMenuCategoryController",function ($scope,$routeParams,$http,$timeout)
{ 
	var view_id = +($routeParams.eid);

	if(angular.isNumber(view_id) && !isNaN(view_id))
	{
		$scope.title = 'View Category Menu';
		var url = url_base + 'master/menu_categories/view/' + view_id;

		var responseData = $http.get(url);
		responseData.success(function(data, status, headers, config) {
			$scope.category = data[0];
		});
		responseData.error(function(data, status, headers, config) {
			alert("Data tidak bisa di ambil !");
		});
	} else {
		$scope.msg = 'Wrong url input';
	}
});


// OUTLETS
app.controller('OutletsController',function($scope,$http,$timeout){
    $scope.pageClass = 'page-home';
    $http.get(url_base+'master/outlets').success(function(data){
        //console.log(data);
        $scope.list = data; 
        $scope.currentPage = 1; //current page
        $scope.entryLimit = 25; //max no of items to display in a page
        $scope.filteredItems = $scope.list.length; //Initially for no filter  
        $scope.totalItems = $scope.list.length;
     });
    $scope.setPage = function(pageNo) {
        $scope.currentPage = pageNo;
    };

    $scope.filter = function() {
        $timeout(function() { 
            $scope.filteredItems = $scope.filtered.length;
        }, 25);
    };
	
	$scope.delete_outlet = function(did) {
		var strconfirm = confirm("Apakah Anda yakin outlet dengan id '"+did+"' akan dihapus ?");
		if (strconfirm == true)
		{
			var url = url_base + 'master/outlets/delete/' + did;
			var responseData = $http.delete(url);
			
			responseData.success(function(data, status, headers, config) {			
				$scope.list = data;			
			});
			
			responseData.error(function(data, status, headers, config) {
				//alert("AJAX failed!");
			});
		}
	};
});


app.controller("NewOutletController",function ($scope,$routeParams,$location,$http,$timeout,StatusList)
{ 
	var edit_id = +($routeParams.eid);
	$scope.save_success = '';
	$scope.save_error = '';
	$scope.statuses = StatusList.list;

	if((angular.isNumber(edit_id) && !isNaN(edit_id)) || (angular.isUndefined($routeParams.eid)))
	{
		if(angular.isNumber(edit_id) && !isNaN(edit_id))
		{
			$scope.title = 'Ubah Outlet';	
			var url = url_base + 'master/outlets/update/' + edit_id;

			var responseData = $http.get(url);
			responseData.success(function(data, status, headers, config) {			
				$scope.outlets = data[0];
			});
			responseData.error(function(data, status, headers, config) {
				//alert("AJAX failed!");
			});
		} else if(angular.isUndefined($routeParams.eid)) {
			$scope.title = 'Tambah Outlet';
			$scope.outlets = {};
		}
		
		$scope.submitForm = function (outlets)
		{
			var edit_id = +($routeParams.eid);
			if(angular.isNumber(edit_id) && !isNaN(edit_id))
			{
				var url = url_base + 'master/outlets/update/' + edit_id;
				var responseData = $http.post(url,{'Outlets':outlets});
			} else {
				var url = url_base + 'master/outlets/create';
				var responseData = $http.post(url,{'Outlets':outlets});
			}
			
			responseData.success(function(data, status, headers, config)
			{
				$scope.save_success = '';
				if(data.success) {
					$scope.save_success = data.success.msg;
				}
				if(data.success) {
					$scope.save_success = data.success.msg;
					if(!(angular.isNumber(edit_id) && !isNaN(edit_id)))
						$routeParams.eid = data.outlet[0].outlet_id;
					$location.path('outlet_new/' + $routeParams.eid, false);
				}
				$scope.save_error = '';
				if(data.error) {
					$scope.save_error = data.error.msg;
				}
				if(data.status) {		
					$location.path('outlets');			
				}
			});
			
			responseData.error(function(data, status, headers, config) {
				//alert("AJAX failed!");
			});
		};
	} else {
		$scope.msg = 'Wrong url input';
	}
});

app.controller("ViewOutletController",function ($scope,$routeParams,$http,$timeout)
{ 
	var view_id = +($routeParams.eid);

	if(angular.isNumber(view_id) && !isNaN(view_id))
	{
		$scope.title = 'View Menu';
		var url = url_base + 'master/outlets/view/' + view_id;

		var responseData = $http.get(url);
		responseData.success(function(data, status, headers, config) {
			$scope.outlets = data[0];
		});
		responseData.error(function(data, status, headers, config) {
			alert("Data tidak bisa di ambil !");
		});
	} else {
		$scope.msg = 'Wrong url input';
	}
});