app.controller('OrdersController',function($scope, $http, $timeout){
    $scope.pageClass = 'page-home';
    $http.get(url_base+'ordering').success(function(data){
        $scope.list = data; 
        $scope.currentPage = 1; //current page
        $scope.entryLimit = 25; //max no of items to display in a page
        $scope.filteredItems = $scope.list.length; //Initially for no filter  
        $scope.totalItems = $scope.list.length;
     });
    $scope.setPage = function(pageNo) {
        $scope.currentPage = pageNo;
    };

    $scope.filter = function() {
        $timeout(function() { 
            $scope.filteredItems = $scope.filtered.length;
        }, 25);
    };

    $scope.orderSend = function() {
        $http.get(url_base+'ordering/order_send').success(function(data){
            $scope.list = data; 
            $scope.currentPage = 1;
            $scope.entryLimit = 25;
            $scope.filteredItems = $scope.list.length;
            $scope.totalItems = $scope.list.length;
        });
    }
}); 


app.controller('NewOrderController',function($scope,$http,$timeout,$location,UtilList){
    $scope.pageClass = 'page-home';
	$scope.isChanges = true;
	
	//Get Modal Menu Information
	UtilList.menuActiveList(function(data) {
		$scope.list = data;
		$scope.currentPage = 1;
        $scope.entryLimit = 10;
        $scope.filteredItems = $scope.list.length;
        $scope.totalItems = $scope.list.length;
	});

    $scope.setPage = function(pageNo) {
        $scope.currentPage = pageNo;
    };

    $scope.filter = function() {
        $timeout(function() { 
            $scope.filteredItems = $scope.filtered.length;
        }, 10);
    };

    $scope.add_item = function(){
        $('#modal_list_menu').modal({
            backdrop:false,
        });
		$('#menu_items_filter').focus();
    }
	
    $scope.modal_menu_hide = function(){
        $('#modal_list_menu').modal('hide');
    }
	//-- END Get Modal Menu Information
	
    $http.get(url_base+'ordering/header_data').success(function(data){
        $scope.header_transaction = data;
    });
	
	$scope.current_open;
    $scope.data_transaction = [];
    $scope.open_detail = function(data){
        $('#modal_confirmation').modal({show:true,backdrop:false,});
        $('#field_name').html(data.menu_name);
		$('#subfield_qty').html('PORSI');
		$('#quantity_item').focus();
        $scope.current_open = data;
    }

    $scope.modal_confirmation_close = function(){
        $('#quantity_item').val("");
        $('#modal_confirmation').modal('hide');
        $('#form_qty').removeClass('has-error');
        $('.help-block').html('');
    }

    $scope.modal_confirmation_add = function(){
        if ($('#quantity_item').val() == '' || $('#quantity_item').val() == '0') {
            $('#form_qty').addClass('has-error');
            $('.help-block').html('Jumlah tidak boleh kosong atau 0 !');
        } else{
            $scope.insert_temporary();
            $('#quantity_item').val("");
            $('#modal_confirmation').modal('hide');
            $('#form_qty').removeClass('has-error');
            $('.help-block').html('')
        };
    }

    $scope.insert_temporary = function(){
        if ($scope.cek_avaliable() == true) {
            $scope.replaces_data();
        } else{
            $scope.add_data();
        };
    }

    $scope.replaces_data = function(){
        var data_temp = [];
        for (var i = $scope.data_transaction.length - 1; i >= 0; i--) {
            var temp = $scope.data_transaction[i];
            if (temp.menu_code == $scope.current_open.menu_code) {
                var sumarize = parseFloat(temp.qty)+parseFloat($('#quantity_item').val());
                $scope.current_open.qty = sumarize;
                data_temp.push($scope.current_open);
            }else{
                data_temp.push(temp);
            };
        };
        $scope.data_transaction = data_temp;
    }

    $scope.add_data = function(){
        $scope.current_open.qty = $('#quantity_item').val();
        $scope.data_transaction.push($scope.current_open);
    }

    $scope.cek_avaliable = function(){
        var check_avaliable  = false;
        for (var i = $scope.data_transaction.length - 1; i >= 0; i--) {
            var temp = $scope.data_transaction[i];
            if (temp.menu_code == $scope.current_open.menu_code) {
                cek_avaliable = true;
                return true;
            };
        };

        return check_avaliable;
    }

    $scope.temp_delete;

    $scope.remove_data = function(data){
        $scope.temp_delete = data;
        $('#del_field_name').html($scope.temp_delete.menu_name);
        $('#modal_confirmation_delete').modal({
            backdrop:false,
            show:true
        });
    }

    $scope.modal_confirmation_yes = function(){
        var data_temp = [];
        for (var i = $scope.data_transaction.length - 1; i >= 0; i--) {
            var temp = $scope.data_transaction[i];
            if (temp.menu_code == $scope.temp_delete.menu_code) {
            }else{
                data_temp.push(temp);
            };
        };
        $scope.data_transaction = data_temp;
		$scope.isChanges = true;
        $('#modal_confirmation_delete').modal('hide');
    }

    $scope.modal_confirmation_no = function(){
        $('#modal_confirmation_delete').modal('hide');
    }
	
	//POST BLOCK
	$scope.post_data = function(isgen){
		if ($scope.data_transaction.length > 0) {
			
			if(!isgen)
				$scope.loading = true; 
			else $scope.generating = true;
				
			var data = $scope.get_data_post();
			$.ajax({
				url:url_base+'ordering/save',
				type:'post',
				data:'json='+data,
				//data:'json={"a":"tes", "b":"OK", "details":'+data+"}",
				success:function(msg){
					$timeout(function(){
						if(!isgen)
						{
							$scope.loading = false;
							if (msg.status == 'success') {
								if(angular.isUndefined($scope.pk) || $scope.pk == '')
								{
									$scope.pk = msg.pk;
									$scope.header_transaction.code = msg.code;
								}
								$scope.isChanges = false;
								$.growl.notice({ message: "Data BERHASIL diSimpan" });
							} else {
								$.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
							};
						} else 
						{
							$scope.generating = false;
							if(angular.isUndefined($scope.pk) || $scope.pk == '')
							{
								$.growl.error({ message: "Klik 'Simpan'. Kemudian 'Generate Order Produk' !" });
							} else {
								$location.path('/order_new/step2/'+$scope.pk);
							}
						}
					},1000);
				},
				error: function(XMLHttpRequest, textStatus, errorThrown) {
                    $timeout(function(){
						if(!isgen)
							$scope.loading = false;
						else $scope.generating = false;
						$.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
					},1000);
                } 
			});
		}else{
			$.growl.warning({ message: "Belum ada data untuk di simpan" });
		};
	}

	$scope.get_data_post = function(){
		var data_temp = [];
		for (var i = $scope.data_transaction.length - 1; i >= 0; i--) {
			var data =  $scope.data_transaction[i];
			data.qty = $('#fixed_qty_' + data.menu_id).val();
			data_temp.push(data);
		};
		
		var data_post = '{';
		if(angular.isDefined($scope.pk) && $scope.pk != '')
			data_post += '"pk":"' + $scope.pk + '", ';
		
		data_post += '"order_date":"' + $scope.header_transaction.order_date + '", ';
		data_post += '"details":' + JSON.stringify(data_temp);
		data_post += '}';

		return data_post;
	}

	$scope.dataChanged = function(){
		$scope.isChanges = true;
	}
});


app.controller('NewOrder2Controller',function($scope,$routeParams,$http,$timeout,$location){
    var pk = +($routeParams.eid);
	
	$scope.pageClass = 'page-home';
    $scope.data_transaction = [];
    $scope.current_open;

    $http.get(url_base+'master/products/getActiveProduct').success(function(data){
        $scope.list = data; 
        $scope.currentPage = 1;
        $scope.entryLimit = 10;
        $scope.filteredItems = $scope.list.length; //Initially for no filter  
        $scope.totalItems = $scope.list.length;
    });

	$scope.setPage = function(pageNo) {
        $scope.currentPage = pageNo;
    };

    $scope.filter = function() {
        $timeout(function() { 
            $scope.filteredItems = $scope.filtered.length;
        }, 10);
    };

	$http.get(url_base+'ordering/generateOrder/'+pk).success(function(data){
        $scope.header_transaction = data.header;
		$scope.data_transaction = data.details;
    });

    $scope.modal_product = function(){
		$('#modal_list_product').modal({
            backdrop:false,
        });
		$('#product_items_filter').focus();
    }

    $scope.modal_product_hide = function(){
        $('#modal_list_product').modal('hide');   
    }

    $scope.add_product = function(data){
        $('#modal_confirmation').modal({show:true,backdrop:false,});
		$('#field_name').html(data.product_name);
		$('#field_unit').html('1 '+data.unit_large+' = '+data.conversion+' '+data.unit_small);
		$('#subfield_qty').html(data.unit_large);
		$('#quantity_item').val('');
        $('#quantity_item').focus();
        $scope.current_open = data;
    }

    $scope.modal_confirmation_add = function(){
        if ($('#quantity_item').val() == '' || $('#quantity_item').val() == '0') {
            $('#form_qty').addClass('has-error');
            $('#hb_quantity_item').html('Data JUMLAH tidak boleh kosong atau 0')
        } else{
            $scope.insert_temporary();
            $('#quantity_item').val("");
            $('#modal_confirmation').modal('hide');
            $('#form_qty').removeClass('has-error');
        };
    }

    $scope.insert_temporary = function(){
        if ($scope.cek_avaliable() == true) {
            $scope.replaces_data();
        } else{
            $scope.add_data();
        };
    }

    $scope.replaces_data = function(){
        for (var i = $scope.data_transaction.length - 1; i >= 0; i--) {
            var temp = $scope.data_transaction[i];
            if (temp.product_code == $scope.current_open.product_code) {
				$scope.data_transaction[i].qty = parseFloat($('#quantity_item').val());
            }
        };
    }

    $scope.add_data = function(){
        $scope.current_open.qty = $('#quantity_item').val();
        $scope.data_transaction.push($scope.current_open);
    }

    $scope.cek_avaliable = function(){
        var check_avaliable  = false;
        for (var i = $scope.data_transaction.length - 1; i >= 0; i--) {
            var temp = $scope.data_transaction[i];
            if (temp.product_code == $scope.current_open.product_code) {
                cek_avaliable = true;
                return true;
            };
        };

        return check_avaliable;
    }

    $scope.temp_delete;

    $scope.remove_data = function(data){
        $scope.temp_delete = data;
        $('#name_item').val($scope.temp_delete.product_name);
        $('#modal_confirmation_delete').modal({
            backdrop:false,
            show:true
        });
    }

    $scope.modal_confirmation_yes = function(){
        var data_temp = [];
        for (var i = $scope.data_transaction.length - 1; i >= 0; i--) {
            var temp = $scope.data_transaction[i];
            if (temp.product_code == $scope.temp_delete.product_code) {
            }else{
                data_temp.push(temp);
            };
        };
        $scope.data_transaction = data_temp;
        $('#modal_confirmation_delete').modal('hide');
    }

    $scope.modal_confirmation_no = function(){
        $('#modal_confirmation_delete').modal('hide');
    }

    $scope.convert_string = function(){
         for (var i = $scope.data_transaction.length - 1; i >= 0; i--) {
             $scope.data_transaction[i].qty = $('#fixed_qty_'+$scope.data_transaction[i].product_id).val();
         };
    }

    $scope.post_data = function(isFinish){
        if ($scope.data_transaction.length >0) {
            $scope.convert_string();
            var json = JSON.stringify($scope.data_transaction);
            
			if(isFinish)
				$scope.finish = true;
			else $scope.loading = true;
            $.ajax({
                url:url_base+'ordering/updateDetails/'+pk,
                type:'post',
                data:'json='+json,
				success:function(msg){
					$timeout(function(){
						if(isFinish)
							$scope.finish = false;
						else $scope.loading = false;
						
						if (msg.status == 'success') {
							$.growl.notice({ message: "Data BERHASIL diSimpan" });
							
							if(isFinish)
								$location.path('/order_view/'+pk);
						} else {
							$.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
						};
					},1000);
				},
				error: function(XMLHttpRequest, textStatus, errorThrown) {
                    $timeout(function(){
						if(isFinish)
							$scope.finish = false;
						else $scope.loading = false;
						
						$.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
					},1000);
                } 
            });
        } else{
            
            $.growl.warning({message:"Tidak ada data yang dapat dikirim "});
        };

    }

});

app.controller('ViewOrderController',['$scope','$routeParams','$http',
    function($scope,$routeParams,$http)	{
        var pk = $routeParams.eid;
        $scope.pid = $routeParams.eid;
        $http.get(url_base+'ordering/findby_pk/'+pk).success(function(data){
            $scope.header = data.header;
			$scope.detail = data.body;
            $scope.detailMenu = data.bodyMenu;
         });
        $scope.pageClass = 'page-home';
	}
]);