app.controller('PurchaseGiroController', function($scope,$http, $timeout,$window) {
  $(window).off("keypress");
  $scope.pgTotal = 0;

  $("#pgDatepickerStart").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#pgDatepickerStart").on('changeDate',function(){
    $(this).datepicker("hide");
  });

   $("#pgDatepickerEnd").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#pgDatepickerEnd").on('changeDate',function(){
    $(this).datepicker("hide");
  });

  $scope.setPage = function(pageNo) {
    $scope.currentPage = pageNo;
  };

  function convertToRp(input){
    var rp = '';    
    input = parseFloat(input).toFixed(2);
    var angkarev = input.toString().split('').reverse().join('');
    var dec = angkarev.substr(0,2).split('').reverse().join('');
    var num = angkarev.substr(3,input.length-3).split('').reverse().join('');

    angkarev = num.toString().split('').reverse().join('');

    for(var i = 0; i < angkarev.length; i++){
      if(i%3 == 0){
        rp += angkarev.substr(i,3)+'.';
      } 
    } 

    var output = rp.split('',rp.length-1).reverse().join('')+','+dec;

    if (output.substr(0,1) == '-' && output.substr(1,1) == '.'){
      output = '-'+output.substr(2,output.length-2);
    }

    return output;
  }

  $scope.filter = function() {
    $timeout(function() { 
      $scope.filteredItems = $scope.filtered.length;

      var balance = 0;

      for (var i = 0; i < $scope.filtered.length; i++){
        balance = balance + (parseFloat($scope.filtered[i]['payment'])-parseFloat($scope.filtered[i]['giro']));
      }

      $scope.pgTotalRp = convertToRp(balance);
      $scope.$apply();
    }, 50);
  };

  $http.get(url_base+'purchasegiro/purchaseGiroAll').success(function (records){
    $scope.purchaseGiroList = records;

    for (var i = 0; i < records.length; i++){
      $scope.purchaseGiroList[i]['paymentRp'] = convertToRp($scope.purchaseGiroList[i]['payment']);
      $scope.purchaseGiroList[i]['discountRp'] = convertToRp($scope.purchaseGiroList[i]['discount']);
      $scope.purchaseGiroList[i]['preturnRp'] = convertToRp($scope.purchaseGiroList[i]['preturn']);
      $scope.purchaseGiroList[i]['giroRp'] = convertToRp($scope.purchaseGiroList[i]['giro']);
      $scope.purchaseGiroList[i]['balanceRp'] = convertToRp(parseFloat($scope.purchaseGiroList[i]['payment'])-parseFloat($scope.purchaseGiroList[i]['giro']));

      $scope.pgTotal = $scope.pgTotal + (parseFloat($scope.purchaseGiroList[i]['payment'])-parseFloat($scope.purchaseGiroList[i]['giro']));
    }

    $scope.pgTotalRp = convertToRp($scope.pgTotal);

    $scope.currentPage = 1;
    $scope.entryLimit = 100;
    $scope.filteredItems = $scope.purchaseGiroList.length;
    $scope.totalItems = $scope.purchaseGiroList.length;
  });

  $scope.generatePurchaseGiro = function(){
    if ($("#pgDatepickerStart").val() == ''){
      $.growl.notice({ message: "Fill in Start Date" });
    }
    else if($("#pgDatepickerEnd").val() == ''){
      $.growl.notice({ message: "Fill in End Date" });
    }
    else if(Date.parse($("#pgDatepickerStart").val()) > Date.parse($("#pgDatepickerEnd").val())){
      $.growl.notice({ message: "Start Date must be lower than End Date" });
    }
    else{
      $scope.inputDate = {"start":$("#pgDatepickerStart").val(),"end":$("#pgDatepickerEnd").val()};

      var json = JSON.stringify($scope.inputDate);

      $.ajax({
        type: 'post',
        url:url_base+'purchasegiro/generatePurchaseGiro',
        data: "json="+json,
        success: function(msg){
          $scope.purchaseGiroList = JSON.parse(msg);
          $scope.pgTotal = 0;

          for (var i = 0; i < $scope.purchaseGiroList.length; i++){
            $scope.purchaseGiroList[i]['paymentRp'] = convertToRp($scope.purchaseGiroList[i]['payment']);
            $scope.purchaseGiroList[i]['discountRp'] = convertToRp($scope.purchaseGiroList[i]['discount']);
            $scope.purchaseGiroList[i]['preturnRp'] = convertToRp($scope.purchaseGiroList[i]['preturn']);
            $scope.purchaseGiroList[i]['giroRp'] = convertToRp($scope.purchaseGiroList[i]['giro']);
            $scope.purchaseGiroList[i]['balanceRp'] = convertToRp(parseFloat($scope.purchaseGiroList[i]['payment'])-parseFloat($scope.purchaseGiroList[i]['giro']));

            $scope.pgTotal = $scope.pgTotal + (parseFloat($scope.purchaseGiroList[i]['payment'])-parseFloat($scope.purchaseGiroList[i]['giro']));
          }

          $scope.pgTotalRp = convertToRp($scope.pgTotal);

          $scope.currentPage = 1;
          $scope.entryLimit = 100;
          $scope.filteredItems = $scope.purchaseGiroList.length;
          $scope.totalItems = $scope.purchaseGiroList.length;

          $scope.$apply();
        },
        error: function() {
          $.growl.error({ message: "Failed. <br/>Check connection and try again !" });
        } 
      });
    
    }
  }

});