app.controller('PurchaseHistoryController', function($scope,$http, $timeout,$window) {
  $(window).off("keypress");

  $("#phDatepickerStart").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#phDatepickerStart").on('changeDate',function(){
    $(this).datepicker("hide");
  });

   $("#phDatepickerEnd").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#phDatepickerEnd").on('changeDate',function(){
    $(this).datepicker("hide");
  });

  $scope.setPage = function(pageNo) {
    $scope.currentPage = pageNo;
  };

  function convertToRp(input){
    var rp = '';    
    input = parseFloat(input).toFixed(2);
    var angkarev = input.toString().split('').reverse().join('');
    var dec = angkarev.substr(0,2).split('').reverse().join('');
    var num = angkarev.substr(3,input.length-3).split('').reverse().join('');

    angkarev = num.toString().split('').reverse().join('');

    for(var i = 0; i < angkarev.length; i++){
      if(i%3 == 0){
        rp += angkarev.substr(i,3)+'.';
      } 
    } 

    var output = rp.split('',rp.length-1).reverse().join('')+','+dec;

    if (output.substr(0,1) == '-' && output.substr(1,1) == '.'){
      output = '-'+output.substr(2,output.length-2);
    }

    return output;
  }

  $scope.filter = function() {
    $timeout(function() { 
      $scope.filteredItems = $scope.filtered.length;
    }, 50);
  };

  $scope.newTab = function(id){
    $window.open('#/purchasehistory2/'+id);
  };

  $http.get(url_base+'purchasehistory/purchaseHistoryAll').success(function (records){
    $scope.purchaseHistoryList = records;

    for (var i = 0; i < records.length; i++){
      $scope.purchaseHistoryList[i]['purchaseRp'] = convertToRp($scope.purchaseHistoryList[i]['purchase']);
      $scope.purchaseHistoryList[i]['paymentRp'] = convertToRp($scope.purchaseHistoryList[i]['payment']);
      $scope.purchaseHistoryList[i]['discountRp'] = convertToRp($scope.purchaseHistoryList[i]['discount']);
      $scope.purchaseHistoryList[i]['preturnRp'] = convertToRp($scope.purchaseHistoryList[i]['preturn']);
      $scope.purchaseHistoryList[i]['giroRp'] = convertToRp($scope.purchaseHistoryList[i]['giro']);
    }

    $scope.currentPage = 1;
    $scope.entryLimit = 25;
    $scope.filteredItems = $scope.purchaseHistoryList.length;
    $scope.totalItems = $scope.purchaseHistoryList.length;
  });

  /*$scope.generatePurchaseHistory = function(){
    if ($("#phDatepickerStart").val() == ''){
      $.growl.notice({ message: "Fill in Start Date" });
    }
    else if($("#phDatepickerEnd").val() == ''){
      $.growl.notice({ message: "Fill in End Date" });
    }
    else if(Date.parse($("#phDatepickerStart").val()) > Date.parse($("#phDatepickerEnd").val())){
      $.growl.notice({ message: "Start Date must be lower than End Date" });
    }
    else{
      $scope.inputDate = {"start":$("#plDatepickerStart").val(),"end":$("#plDatepickerEnd").val()};

      var json = JSON.stringify($scope.inputDate);

      $.ajax({
        type: 'post',
        url:url_base+'profitloss/generateProfitLoss',
        data: "json="+json,
        success: function(msg){
          $scope.profitlossList = JSON.parse(msg);
          $scope.ydebitcur = 0;
          $scope.ycreditcur = 0;
          $scope.ytotal = 0;

          for (var i = $scope.profitlossList.length - 1; i >= 0; i--) {
            $scope.profitlossList[i]['debitcurrp'] = convertToRp($scope.profitlossList[i]['debitcur']);
            $scope.profitlossList[i]['creditcurrp'] = convertToRp($scope.profitlossList[i]['creditcur']);
            $scope.profitlossList[i]['totalrp'] = convertToRp(($scope.profitlossList[i]['debitcur'] - $scope.profitlossList[i]['creditcur'])*-1);
          };

          var total1 = 0;
          var total2 = 0;
          var total3 = 0;
          var total4 = 0;

          for (var i = $scope.headAccountList.length - 1; i >= 0; i--) {
            for (var j = $scope.profitlossList.length - 1; j >= 0; j--) {
              if ($scope.headAccountList[i]['glno'] == $scope.profitlossList[j]['head']){
                total3 = parseFloat(total3) + parseFloat($scope.profitlossList[j]['debitcur']);
                total4 = parseFloat(total4) + parseFloat($scope.profitlossList[j]['creditcur']);
              }
            };

            $scope.headAccountList[i]['xdebitcur'] = total3;
            $scope.headAccountList[i]['xcreditcur'] = total4;
            $scope.headAccountList[i]['xtotal'] = total3 - total4;
            $scope.headAccountList[i]['xdebitcurrp'] = convertToRp(total3);
            $scope.headAccountList[i]['xcreditcurrp'] = convertToRp(total4);
            $scope.headAccountList[i]['xtotalrp'] = convertToRp($scope.headAccountList[i]['xtotal']*-1);

            $scope.ydebitcur = parseFloat(total3) + parseFloat($scope.ydebitcur);
            $scope.ycreditcur = parseFloat(total4) + parseFloat($scope.ycreditcur);
            $scope.ytotal = parseFloat($scope.ydebitcur) - parseFloat($scope.ycreditcur);

            total1 = 0;
            total2 = 0;
            total3 = 0;
            total4 = 0;
            $scope.$apply();
          };

          $scope.ydebitrp = convertToRp($scope.ydebitcur);
          $scope.ycreditrp = convertToRp($scope.ycreditcur);
          $scope.ytotalrp = convertToRp($scope.ytotal*-1);
             
          $scope.currentPage = 1;
          $scope.entryLimit = 5;
          $scope.filteredItems = $scope.headAccountList.length;
          $scope.totalItems = $scope.headAccountList.length;
          $scope.$apply();
        },
        error: function() {
          $.growl.error({ message: "Failed. <br/>Check connection and try again !" });
        } 
      });
    
    }
  }
  */
});


app.controller('PurchaseHistoryDetailController',['$scope','$routeParams','$http','$timeout',
  function($scope,$routeParams,$http,$timeout){
    var id = $routeParams.id;

    $scope.phTotal = 0;

    function convertToRp(input){
      var rp = '';    
      input = parseFloat(input).toFixed(2);
      var angkarev = input.toString().split('').reverse().join('');
      var dec = angkarev.substr(0,2).split('').reverse().join('');
      var num = angkarev.substr(3,input.length-3).split('').reverse().join('');

      angkarev = num.toString().split('').reverse().join('');

      for(var i = 0; i < angkarev.length; i++){
        if(i%3 == 0){
          rp += angkarev.substr(i,3)+'.';
        } 
      } 

      var output = rp.split('',rp.length-1).reverse().join('')+','+dec;

      if (output.substr(0,1) == '-' && output.substr(1,1) == '.'){
        output = '-'+output.substr(2,output.length-2);
      }

      return output;
    }

    $http.get(url_base+'purchasehistory/getPurchaseHistoryHeader/'+id).success(function (records){
      $scope.phTransactionId = records[0]['transaksiid'];
      $scope.phSupplier = records[0]['supplier'];
    });

    $http.get(url_base+'purchasehistory/getPurchaseHistoryDetail/'+id).success(function (records){
      $scope.purchaseHistoryDetail = records;

      for (var i = 0; i < records.length; i++){
        $scope.purchaseHistoryDetail[i]['jumlahRp'] = convertToRp($scope.purchaseHistoryDetail[i]['jumlah']);

        $scope.phTotal = parseFloat($scope.phTotal) + parseFloat($scope.purchaseHistoryDetail[i]['jumlah']);
      }

      $scope.phTotalRp = convertToRp(Math.round($scope.phTotal*100)/100);
    });
  }
]);
