app.controller('PurchasePaymentController', function($scope,$http, $timeout,$window) {
  $(window).off("keypress");
  $scope.ppTotal = 0;

  $("#ppDatepickerStart").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#ppDatepickerStart").on('changeDate',function(){
    $(this).datepicker("hide");
  });

   $("#ppDatepickerEnd").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#ppDatepickerEnd").on('changeDate',function(){
    $(this).datepicker("hide");
  });

  $scope.setPage = function(pageNo) {
    $scope.currentPage = pageNo;
  };

  function convertToRp(input){
    var rp = '';    
    input = parseFloat(input).toFixed(2);
    var angkarev = input.toString().split('').reverse().join('');
    var dec = angkarev.substr(0,2).split('').reverse().join('');
    var num = angkarev.substr(3,input.length-3).split('').reverse().join('');

    angkarev = num.toString().split('').reverse().join('');

    for(var i = 0; i < angkarev.length; i++){
      if(i%3 == 0){
        rp += angkarev.substr(i,3)+'.';
      } 
    } 

    var output = rp.split('',rp.length-1).reverse().join('')+','+dec;

    if (output.substr(0,1) == '-' && output.substr(1,1) == '.'){
      output = '-'+output.substr(2,output.length-2);
    }

    return output;
  }

  $scope.filter = function() {
    $timeout(function() { 
      $scope.filteredItems = $scope.filtered.length;

      var balance = 0;

      for (var i = 0; i < $scope.filtered.length; i++){
        balance = balance + (parseFloat($scope.filtered[i]['purchase'])-parseFloat($scope.filtered[i]['payment']));
      }

      $scope.ppTotalRp = convertToRp(balance);
      $scope.$apply();
    }, 50);
  };

  $http.get(url_base+'purchasepayment/purchasePaymentAll').success(function (records){
    $scope.purchasePaymentList = records;

    for (var i = 0; i < records.length; i++){
      $scope.purchasePaymentList[i]['purchaseRp'] = convertToRp($scope.purchasePaymentList[i]['purchase']);
      $scope.purchasePaymentList[i]['paymentRp'] = convertToRp($scope.purchasePaymentList[i]['payment']);
      $scope.purchasePaymentList[i]['balanceRp'] = convertToRp(parseFloat($scope.purchasePaymentList[i]['purchase'])-parseFloat($scope.purchasePaymentList[i]['payment']));

      $scope.ppTotal = $scope.ppTotal + (parseFloat($scope.purchasePaymentList[i]['purchase'])-parseFloat($scope.purchasePaymentList[i]['payment']));
    }

    $scope.ppTotalRp = convertToRp($scope.ppTotal);

    $scope.currentPage = 1;
    $scope.entryLimit = 100;
    $scope.filteredItems = $scope.purchasePaymentList.length;
    $scope.totalItems = $scope.purchasePaymentList.length;
  });

  $scope.generatePurchasePayment = function(){
    if ($("#ppDatepickerStart").val() == ''){
      $.growl.notice({ message: "Fill in Start Date" });
    }
    else if($("#ppDatepickerEnd").val() == ''){
      $.growl.notice({ message: "Fill in End Date" });
    }
    else if(Date.parse($("#ppDatepickerStart").val()) > Date.parse($("#ppDatepickerEnd").val())){
      $.growl.notice({ message: "Start Date must be lower than End Date" });
    }
    else{
      $scope.inputDate = {"start":$("#ppDatepickerStart").val(),"end":$("#ppDatepickerEnd").val()};

      var json = JSON.stringify($scope.inputDate);

      $.ajax({
        type: 'post',
        url:url_base+'purchasepayment/generatePurchasePayment',
        data: "json="+json,
        success: function(msg){
          $scope.purchasePaymentList = JSON.parse(msg);
          $scope.ppTotal = 0;

          for (var i = 0; i < $scope.purchasePaymentList.length; i++){
            $scope.purchasePaymentList[i]['purchaseRp'] = convertToRp($scope.purchasePaymentList[i]['purchase']);
            $scope.purchasePaymentList[i]['paymentRp'] = convertToRp($scope.purchasePaymentList[i]['payment']);
            $scope.purchasePaymentList[i]['balanceRp'] = convertToRp(parseFloat($scope.purchasePaymentList[i]['purchase'])-parseFloat($scope.purchasePaymentList[i]['payment']));

            $scope.ppTotal = $scope.ppTotal + (parseFloat($scope.purchasePaymentList[i]['purchase'])-parseFloat($scope.purchasePaymentList[i]['payment']));
          }

          $scope.ppTotalRp = convertToRp($scope.ppTotal);

          $scope.currentPage = 1;
          $scope.entryLimit = 100;
          $scope.filteredItems = $scope.purchasePaymentList.length;
          $scope.totalItems = $scope.purchasePaymentList.length;

          $scope.$apply();
        },
        error: function() {
          $.growl.error({ message: "Failed. <br/>Check connection and try again !" });
        } 
      });
    
    }
  }

});