app.controller('SalesPaymentController', function($scope,$http, $timeout,$window) {
  $(window).off("keypress");
  $scope.spTotal = 0;

  $("#spDatepickerStart").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#spDatepickerStart").on('changeDate',function(){
    $(this).datepicker("hide");
  });

   $("#spDatepickerEnd").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#spDatepickerEnd").on('changeDate',function(){
    $(this).datepicker("hide");
  });

  $scope.setPage = function(pageNo) {
    $scope.currentPage = pageNo;
  };

  function convertToRp(input){
    var rp = '';    
    input = parseFloat(input).toFixed(2);
    var angkarev = input.toString().split('').reverse().join('');
    var dec = angkarev.substr(0,2).split('').reverse().join('');
    var num = angkarev.substr(3,input.length-3).split('').reverse().join('');

    angkarev = num.toString().split('').reverse().join('');

    for(var i = 0; i < angkarev.length; i++){
      if(i%3 == 0){
        rp += angkarev.substr(i,3)+'.';
      } 
    } 

    var output = rp.split('',rp.length-1).reverse().join('')+','+dec;

    if (output.substr(0,1) == '-' && output.substr(1,1) == '.'){
      output = '-'+output.substr(2,output.length-2);
    }

    return output;
  }

  $scope.filter = function() {
    $timeout(function() { 
      $scope.filteredItems = $scope.filtered.length;

      var balance = 0;

      for (var i = 0; i < $scope.filtered.length; i++){
        balance = balance + (parseFloat($scope.filtered[i]['sales'])-parseFloat($scope.filtered[i]['payment']));
      }

      $scope.spTotalRp = convertToRp(balance);
      $scope.$apply();
    }, 50);
  };

  $http.get(url_base+'salespayment/salesPaymentAll').success(function (records){
    $scope.salesPaymentList = records;

    for (var i = 0; i < records.length; i++){
      $scope.salesPaymentList[i]['salesRp'] = convertToRp($scope.salesPaymentList[i]['sales']);
      $scope.salesPaymentList[i]['paymentRp'] = convertToRp($scope.salesPaymentList[i]['payment']);
      $scope.salesPaymentList[i]['balanceRp'] = convertToRp(parseFloat($scope.salesPaymentList[i]['sales'])-parseFloat($scope.salesPaymentList[i]['payment']));

      $scope.spTotal = $scope.spTotal + (parseFloat($scope.salesPaymentList[i]['sales'])-parseFloat($scope.salesPaymentList[i]['payment']));
    }

    $scope.spTotalRp = convertToRp($scope.spTotal);

    $scope.currentPage = 1;
    $scope.entryLimit = 100;
    $scope.filteredItems = $scope.salesPaymentList.length;
    $scope.totalItems = $scope.salesPaymentList.length;
  });

  $scope.generateSalesPayment = function(){
    if ($("#spDatepickerStart").val() == ''){
      $.growl.notice({ message: "Fill in Start Date" });
    }
    else if($("#spDatepickerEnd").val() == ''){
      $.growl.notice({ message: "Fill in End Date" });
    }
    else if(Date.parse($("#spDatepickerStart").val()) > Date.parse($("#spDatepickerEnd").val())){
      $.growl.notice({ message: "Start Date must be lower than End Date" });
    }
    else{
      $scope.inputDate = {"start":$("#spDatepickerStart").val(),"end":$("#spDatepickerEnd").val()};

      var json = JSON.stringify($scope.inputDate);

      $.ajax({
        type: 'post',
        url:url_base+'salespayment/generateSalesPayment',
        data: "json="+json,
        success: function(msg){
          $scope.salesPaymentList = JSON.parse(msg);
          $scope.spTotal = 0;

          for (var i = 0; i < $scope.salesPaymentList.length; i++){          
            $scope.salesPaymentList[i]['salesRp'] = convertToRp($scope.salesPaymentList[i]['sales']);
            $scope.salesPaymentList[i]['paymentRp'] = convertToRp($scope.salesPaymentList[i]['payment']);
            $scope.salesPaymentList[i]['balanceRp'] = convertToRp(parseFloat($scope.salesPaymentList[i]['sales'])-parseFloat($scope.salesPaymentList[i]['payment']));

            $scope.spTotal = $scope.spTotal + (parseFloat($scope.salesPaymentList[i]['sales'])-parseFloat($scope.salesPaymentList[i]['payment']));
          }

          $scope.spTotalRp = convertToRp($scope.spTotal);

          $scope.currentPage = 1;
          $scope.entryLimit = 100;
          $scope.filteredItems = $scope.salesPaymentList.length;
          $scope.totalItems = $scope.salesPaymentList.length;

          $scope.$apply();
        },
        error: function() {
          $.growl.error({ message: "Failed. <br/>Check connection and try again !" });
        } 
      });
    
    }
  }

});