app.controller('AttendanceController',['$scope','$routeParams','$http','$timeout',
  function($scope,$routeParams,$http,$timeout){
		$("#datepickerStartAttendance").datepicker({
	    format:"yyyy-mm-dd"
	  });

	  $("#datepickerStartAttendance").on('changeDate',function(){
	    $(this).datepicker("hide");
	  });

	  $("#datepickerEndAttendance").datepicker({
	    format:"yyyy-mm-dd"
	  });

	  $("#datepickerEndAttendance").on('changeDate',function(){
	    $(this).datepicker("hide");
	  });

		$("#masking").hide();

		$(document).ready(function(){
	    $("#exportExcel").click(function() {
        let table = document.getElementsByTagName("table");
        TableToExcel.convert(table[0], { // html code may contain multiple tables so here we are refering to 1st table tag
          name: `export.xlsx`, // fileName you could use any name
          sheet: {
            name: 'Sheet 1' // sheetName
          }
        });
	    });
		});

		$http.get(url_base+'so_attendance/attendanceView').success(function(data){
			$http.get(url_base+'so_attendance/attendanceSummaryView').success(function (records){
	      $scope.attendanceSummary = records;
	    });
	    
		  $scope.list = data; 
		  $scope.currentPage = 1; //current page
		  $scope.entryLimit = 50; //max no of items to display in a page
		  $scope.filteredItems = $scope.list.length; //Initially for no filter  
		  $scope.totalItems = $scope.list.length;
		});

		$scope.showDivList = function() {
	    $('#divList').modal({
	      backdrop:false,
	    });
	  };

	  $scope.showDivMain = function() {
	    $('#divList').modal('hide');
	  };
		 
		$scope.setPage = function(pageNo) {
		   $scope.currentPage = pageNo;
		};

		$scope.filter = function() {
	    $timeout(function() { 
	      $scope.filteredItems = $scope.filtered.length;
	    }, 50);
		};

		$scope.displayPicture = function(date) {
			$http.get(url_base+'so_attendance/imageView/'+date).success(function(data){
		   	$scope.image = data[0].userimage.replaceAll(" ", "+"); 
			});
			
	    var x = $(window).scrollTop();
	    var y = $(window).width();
	    var z = $("#masking").width(); 
		    
	    $("#masking").css({top:x,left:(y-z)/2,position:"absolute"});
	    $("#masking").css("z-index","9999");
	    $("#masking").show();
	  };

    $scope.closePicture = function() {
	    $("#masking").hide();
	    $scope.image = '';
    };

		$scope.exportExcel = function(){
			$http({
				url: url_base + 'master/products/export',
				method: 'POST',
				dataType: 'json',
			})
			.success(function (data, status, headers, config)
			{
				window.open(data);
			})
			.error(function(data, status, headers, config) {
				alert("AJAX failed!");
			})
		}

		$scope.generateAttendance = function(isgen){
	    if ($("#datepickerStartAttendance").val() == ''){
	      $.growl.notice({ message: "Fill in Start Date" });
	    }
	    else if($("#datepickerEndAttendance").val() == ''){
	      $.growl.notice({ message: "Fill in End Date" });
	    }
	    else if(Date.parse($("#datepickerStartAttendance").val()) > Date.parse($("#datepickerEndAttendance").val())){
	      $.growl.notice({ message: "Start Date must be lower than End Date" });
	    }
	    else{
	      if(!isgen){
	        $scope.loading = true; 
	      };

	      $scope.inputDate = {"start":$("#datepickerStartAttendance").val(),"end":$("#datepickerEndAttendance").val()};

	      var json = JSON.stringify($scope.inputDate);

	      $.ajax({
	        type: 'post',
	        url:url_base+'so_attendance/generateAttendance',
	        data: "json="+json,
	        success: function(msg){
	        	$.growl.notice({ message: "Data fetched" });
	          $timeout(function(){       
	            if(!isgen){
	              $scope.list = JSON.parse(msg);

	              $scope.currentPage = 1; //current page
							  $scope.entryLimit = 50; //max no of items to display in a page
							  $scope.filteredItems = $scope.list.length; //Initially for no filter  
							  $scope.totalItems = $scope.list.length;

							  $scope.search = '';

	              $scope.$apply();
	              $scope.loading = false;
	            }
	          },1000);
	        },
	        error: function() {
	          $timeout(function(){
	            if(!isgen){
	              $scope.loading = false;
	            }
	            $.growl.error({ message: "Failed. <br/>Check connection and try again !" });
	          },1000);
	        } 
	      });

	      $.ajax({
	        type: 'post',
	        url:url_base+'so_attendance/generateAttendanceSummary',
	        data: "json="+json,
	        success: function(msg){
	          $timeout(function(){       
	            $scope.attendanceSummary = JSON.parse(msg);
	          },1000);
	        },
	        error: function() {
	          $timeout(function(){
	            $.growl.error({ message: "Failed. <br/>Check connection and try again !" });
	          },1000);
	        } 
	      });
	    }
	  }

  }
]);

/*app.controller('EditAttendanceController',['$scope','$routeParams','$http','$timeout',
  function($scope,$routeParams,$http,$timeout){
  	var login_id = $routeParams.id;

    $("#datepickerLoginAttendance").datepicker({
	    format:"yyyy-mm-dd"
	  });

	  $("#datepickerLoginAttendance").on('changeDate',function(){
	    $(this).datepicker("hide");
	  });

	  $("#datepickerLogoutAttendance").datepicker({
	    format:"yyyy-mm-dd"
	  });

	  $("#datepickerLogoutAttendance").on('changeDate',function(){
	    $(this).datepicker("hide");
	  });

    $http.get(url_base+'result/selectedAttendance/'+login_id).success(function(data){
		  $scope.log = data; 

		  $("#datepickerLoginAttendance").val(data['login'].substring(0,10));
		  $("#datepickerLogoutAttendance").val(data['logout'].substring(0,10));

		  $("#timeLoginAttendance").val(data['login'].substring(11,19));
		  $("#timeLogoutAttendance").val(data['logout'].substring(11,19));
		});

		$scope.editAttendance = function(isgen){
	    if ($("#datepickerLoginAttendance").val() == ''){
	      $.growl.notice({ message: "Fill in Start Date" });
	    }
	    else if($("#datepickerLogoutAttendance").val() == ''){
	      $.growl.notice({ message: "Fill in End Date" });
	    }
	    else if(Date.parse($("#datepickerLoginAttendance").val()) !== Date.parse($("#datepickerLogoutAttendance").val())){
	      $.growl.notice({ message: "Login & Logout date must be in same day" });
	    }
	    else if($("#timeLoginAttendance").val() > $("#timeLogoutAttendance").val()){
	      $.growl.notice({ message: "Login time must be lower than Logout" });
	    }
	    else{
	      if(!isgen){
	        $scope.loading = true; 
	      };

	      $scope.selectedAttendance = {"userName":$scope.log['name'],"loginId":$scope.log['login_id'],"loginDate":$("#datepickerLoginAttendance").val(),"loginTime":$("#timeLoginAttendance").val(),"logoutId":$scope.log['logout_id'],"logoutDate":$("#datepickerLogoutAttendance").val(),"logoutTime":$("#timeLogoutAttendance").val()};

	      var json = JSON.stringify($scope.selectedAttendance);

	      $.ajax({
	        type: 'post',
	        url:url_base+'result/editAttendance',
	        data: "json="+json,
	        success: function(msg){
	        	var obj = JSON.parse(msg);
	          $timeout(function(){     
	            if(!isgen){
	              $scope.loading = false;

	              if (obj.status == 'sukses') {
	                $.growl.notice({ message: "Data saved" });

	                location.href = "#/result"
	              }
	            }
	          },1000);
	        },
	        error: function() {
	          $timeout(function(){
	            if(!isgen){
	              $scope.loading = false;
	            }
	            $.growl.error({ message: "Failed. <br/>Check connection and try again !" });
	          },1000);
	        } 
	      });
	    }
	  }

  }
]);
*/



