app.controller('SoCustomerController', function($scope,$http, $timeout,$window) {
  $scope.customer = [];

  function convertToRp(input){
    var rp = '';    
    input = parseFloat(input).toFixed(2);
    var angkarev = input.toString().split('').reverse().join('');
    var dec = angkarev.substr(0,2).split('').reverse().join('');
    var num = angkarev.substr(3,input.length-3).split('').reverse().join('');

    angkarev = num.toString().split('').reverse().join('');

    for(var i = 0; i < angkarev.length; i++){
      if(i%3 == 0){
        rp += angkarev.substr(i,3)+'.';
      } 
    } 

    var output = rp.split('',rp.length-1).reverse().join('')+','+dec;

    if (output.substr(0,1) == '-' && output.substr(1,1) == '.'){
      output = '-'+output.substr(2,output.length-2);
    }

    return output;
  }
 
  $scope.setPage = function(pageNo) {
    $scope.currentPage = pageNo;
  };

  $scope.filter = function() {
    $timeout(function() { 
      $scope.filteredItems = $scope.filtered.length;
    }, 50);
  };

  $http.get(url_base+'so_customer/customerList').success(function (records){
    $scope.customer = records;

    for(var i = 0; i < records.length; i++){
      $scope.customer[i]['credit_limit_rp'] = convertToRp(records[i]['credit_limit']);
    } 

    $scope.currentPage = 1;
    $scope.entryLimit = 25;
    $scope.filteredItems = $scope.customer.length;
    $scope.totalItems = $scope.customer.length;
  });

});

app.controller('SoCustomerEditController',['$scope','$routeParams','$http','$timeout',
  function($scope,$routeParams,$http,$timeout){
    var id = $routeParams.id;
    $scope.creditTotal = 0;

    function convertToRp(input){
      var rp = '';    
      input = parseFloat(input).toFixed(2);
      var angkarev = input.toString().split('').reverse().join('');
      var dec = angkarev.substr(0,2).split('').reverse().join('');
      var num = angkarev.substr(3,input.length-3).split('').reverse().join('');

      angkarev = num.toString().split('').reverse().join('');

      for(var i = 0; i < angkarev.length; i++){
        if(i%3 == 0){
          rp += angkarev.substr(i,3)+'.';
        } 
      } 

      var output = rp.split('',rp.length-1).reverse().join('')+','+dec;

      if (output.substr(0,1) == '-' && output.substr(1,1) == '.'){
        output = '-'+output.substr(2,output.length-2);
      }

      return output;
    }

    $http.get(url_base+'so_customer/customerSelected/'+id).success(function (records){
      $scope.customerIdSelected = records[0]['kodelang'];
      $scope.customerNameSelected = records[0]['namalang'];
      $scope.customerAddressSelected = records[0]['almtlang'];
      $scope.customerLimitSelected = records[0]['credit_limit'];
      $scope.customerTopSelected = records[0]['top'];
    });

    $http.get(url_base+'so_customer/customerCreditSelected/'+id).success(function (records){
      $scope.customerCreditSelected = records;

      for(var i = 0; i < records.length; i++){
        $scope.customerCreditSelected[i]['total_rp'] = convertToRp(records[i]['total']);
        $scope.creditTotal = parseFloat($scope.creditTotal) + parseFloat(records[i]['total']);
      } 

      $scope.creditTotalRp = convertToRp($scope.creditTotal);
      $scope.filteredItems = $scope.customerCreditSelected.length;
      $scope.totalItems = $scope.customerCreditSelected.length;
    });

    $scope.editCustomer = function(isgen,status,view) {
      if ($scope.customerLimitSelected == ''){
        $.growl.warning({ message: 'Empty Limit field' });
      }
      else if ($scope.customerLimitSelected == ''){
        $.growl.warning({ message: 'Empty TOP field' });
      }
      else {
        if(!isgen){
          $scope.loading = true; 
        };
  
        $scope.customerSelected = {"kodelang":$scope.customerIdSelected,"credit_limit":$scope.customerLimitSelected,"top":$scope.customerTopSelected};
        var json = JSON.stringify($scope.customerSelected);

        $.ajax({
          type: 'post',
          url:url_base+'so_customer/editCustomer',
          data: "json="+json,
          success: function(msg){
            //alert(msg);
            var obj = JSON.parse(msg);
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
                if (obj.status == 'sukses') {
                  $.growl.notice({ message: "Data saved" });
                  if (view == 0){
                    location.href = "#/customerX";
                  }
                  else {
                    location.href = "#/customer";
                  }
                } 
                else {
                  $.growl.error({ message: "Update failed. Try again !" });
                };
              }
            },1000);
          },
          error: function(XMLHttpRequest, textStatus, errorThrown) {
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
              }
              $.growl.error({ message: "Update failed. <br/>Check connection and try again !" });
            },1000);
          } 
        });
      }
    };
  }


]);