//your directive
app.directive("fileread", [
  function() {
    return {
      scope: {
        fileread: "="
      },
      link: function(scope, element, attributes) {
        element.bind("change", function(changeEvent) {
          //alert('This file size is: ' +Math.round(this.files[0].size/1024,2)+" KB");

          if (this.files && this.files[0]) {
            var reader = new FileReader();
            reader.onload = function(event) {
              var img = new Image();
              img.onload = function() {
                if (img.width > 600) {
                  var oc = document.createElement('canvas'), octx = oc.getContext('2d');
                  oc.width = img.width;
                  oc.height = img.height;
                  octx.drawImage(img, 0, 0);
                  while (oc.width * 0.5 > 600) {
                    oc.width *= 0.5;
                    oc.height *= 0.5;
                    octx.drawImage(oc, 0, 0, oc.width, oc.height);
                  }
                  oc.width = 600;
                  oc.height = oc.width * img.height / img.width;
                  octx.drawImage(img, 0, 0, oc.width, oc.height);
                  //document.getElementById('great-image').src = oc.toDataURL();
                
                  scope.$apply(function() {
                    scope.fileread = oc.toDataURL();
                  });
                  //alert('Compressing image done');
                  alert('Photo compressed to : '+oc.width+' x '+oc.height+' PX');
                } else {
                  //document.getElementById('small-image').src = img.src;
                  scope.$apply(function() {
                    scope.fileread = img.src;
                  });
                  //alert('Compressing image done');
                  alert('Photo compressed to : '+img.width+' x '+img.height+' PX');
                }
              };
              //document.getElementById('original-image').src = event.target.result;
              img.src = event.target.result;
            };
            reader.readAsDataURL(this.files[0]);
          }

          reader.readAsDataURL(changeEvent.target.files[0]);
        });
      }
    }
  }
]);

app.controller('SoHomeController', function($scope,$http,$timeout,$window) {
  $scope.u_name = '';
  $scope.u_image = '';
  $scope.latitude = '';
  $scope.longitude = '';
  $scope.uploadme = '';
  $scope.location = 'Press Get Location!';
  $scope.u_status1 = false;
  $scope.u_status2 = false;

  $scope.uploadme;
  $scope.homeCustomer = '';

  $scope.uploadImage = function() {
    var fd = new FormData();
    var imgBlob = dataURItoBlob($scope.uploadme);
    fd.append('file', imgBlob);
    
    $scope.u_image = imgBlob;

    alert ($scope.u_image);
  }

  function dataURItoBlob(dataURI) {
    var binary = atob(dataURI.split(',')[1]);
    var mimeString = dataURI.split(',')[0].split(':')[1].split(';')[0];
    var array = [];
    for (var i = 0; i < binary.length; i++) {
      array.push(binary.charCodeAt(i));
    }
    return new Blob([new Uint8Array(array)], {
      type: mimeString
    });
  }

  function convertToRp(input){
    if (input == null) {
      return input;
    }
    else {
      var rp = '';    
      input = parseFloat(input).toFixed(2);
      var angkarev = input.toString().split('').reverse().join('');
      var dec = angkarev.substr(0,2).split('').reverse().join('');
      var num = angkarev.substr(3,input.length-3).split('').reverse().join('');

      angkarev = num.toString().split('').reverse().join('');

      for(var i = 0; i < angkarev.length; i++){
        if(i%3 == 0){
          rp += angkarev.substr(i,3)+'.';
        } 
      } 

      var output = rp.split('',rp.length-1).reverse().join('')+','+dec;

      if (output.substr(0,1) == '-' && output.substr(1,1) == '.'){
        output = '-'+output.substr(2,output.length-2);
      }

      return output;
    }
  }

  $scope.getLocation = function(isgen,status){
    if(!isgen){
      $scope.loading2 = true; 
    };

    if(navigator.geolocation) {
      navigator.geolocation.getCurrentPosition(function(position) {
        $scope.location = "Latitude: " + position.coords.latitude + ", " + "Longitude: " + position.coords.longitude;

        $scope.latitude = position.coords.latitude;
        $scope.longitude = position.coords.longitude;
        $scope.loading2 = false;
        $scope.$apply();
      });
    } else {
      alert("Sorry, your browser does not support HTML5 geolocation.");
      $scope.loading2 = false;
    }
  }

  $http.get(url_base+'so_home/customerList').success(function (records){
    $scope.homeCustomerList = records;
  });

  $http.get(url_base+'so_home/countTodayLog').success(function(data){
    if (data['countLog'] % 2 == 0){
      $scope.u_status1 = true;
      $scope.u_status2 = false;
    }
    else {
      $scope.u_status1 = false;
      $scope.u_status2 = true;
    }
  });

  $http.get(url_base+'so_home/getUser').success(function (records){
    $scope.user = records;
  });

  $http.get(url_base+'so_home/getStatusToday').success(function (records){
    $scope.log = records;

    $scope.unvalidated = 0;
    $scope.available = 0;
    $scope.cleared = 0;
    $scope.blocked = 0;

    for (var i = $scope.log.length - 1; i >= 0; i--) {
      if ($scope.log[i]['status2'] == 6){
        $scope.unvalidated = $scope.log[i]['x'];
      }
      else if ($scope.log[i]['status2'] == 0){
        $scope.available = $scope.log[i]['x'];
      }
      else if ($scope.log[i]['status2'] == 1){
        $scope.cleared = $scope.log[i]['x'];
      }
      else{
        $scope.blocked = $scope.log[i]['x'];
      }
    };
  });

  $http.get(url_base+'so_home/getLogToday').success(function (records){
    $scope.log2 = records;

    for (var i = $scope.log2.length - 1; i >= 0; i--) {
      $scope.log2[i]['tunaiRp'] = convertToRp($scope.log2[i]['tunai']);
      $scope.log2[i]['giroRp'] = convertToRp($scope.log2[i]['giro']);
    };
  });

  $http.get(url_base+'so_home/todayLog').success(function(data){
    $scope.login = data['login'];
    $scope.logout = data['logout'];
  });

  $http.get(url_base+'so_home/userLog').success(function(data){
    $scope.log3 = data;
  });

  $scope.saveAttendance = function(isgen,status){
    var valid = 0;

    for (var i = $scope.homeCustomerList.length - 1; i >= 0; i--) {
      if ($scope.homeCustomerList[i]['kodelang'] == $scope.homeCustomer){
        valid = 1;
      }
    };

    if ($scope.latitude == '' || $scope.longitude == ''){
      $.growl.notice({ message: "Location not detected!" });
    }
    /*else if ($scope.uploadme == ''){
      $.growl.notice({ message: "Take your picture first!" });
    }*/
    else if ($scope.homeCustomer == ''){
      $.growl.warning({ message: 'Choose customer' });
    }
    else if (valid == 0){
      $.growl.warning({ message: 'Pick Customer from List' });
    }
    else {
      if(!isgen){
        $scope.loading = true; 
      };

      $scope.result = {"latitude":$scope.latitude,"longitude":$scope.longitude,"customer":$scope.homeCustomer};
      var json = JSON.stringify($scope.result);
      const json2 = JSON.stringify({"image":$scope.uploadme});
    
      $.ajax({
        type: 'post',
        url:url_base+'so_home/saveAttendance',
        data: "json="+json+"&json2="+json2,
        success: function(msg){
          var obj = JSON.parse(msg);
          $timeout(function(){
            //alert(msg);
            if(!isgen){
              $scope.loading = false;
              if (obj.status == 'sukses') {
                $.growl.notice({ message: "Data saved" });

                $http.get(url_base+'so_home/countTodayLog').success(function(data){
                  if (data['countLog'] % 2 == 0){
                    $scope.u_status1 = true;
                    $scope.u_status2 = false;
                  }
                  else {
                    $scope.u_status1 = false;
                    $scope.u_status2 = true;
                  }
                });

                $http.get(url_base+'so_home/todayLog').success(function(data){
                  $scope.login = data['login'];
                  $scope.logout = data['logout'];
                });

                $http.get(url_base+'so_home/userLog').success(function(data){
                  $scope.log3 = data;
                });

                $scope.latitude = '';
                $scope.longitude = '';
                $scope.uploadme = '';
                $scope.location = 'Press Get Location!';
                $scope.homeCustomer = '';

                $scope.$apply();
              } 
              else {
                $.growl.error({ message: "Save failed. Try again !" });
              };
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
            }
            $.growl.error({ message: "Save failed. <br/>Check connection and try again !" });
          },1000);
        } 
      });
      
    }
  }

});