app.controller('SoPaymentHistoryController', function($scope,$http, $timeout) {
  $http.get(url_base+"so_payment/paymentList").success(function (records) {
    $scope.paymentHeader = records;
    $scope.currentPage = 1;
    $scope.entryLimit = 25;
    $scope.filteredItems = $scope.paymentHeader.length;
    $scope.totalItems = $scope.paymentHeader.length;
  });

  $scope.setPage = function(pageNo) {
      $scope.currentPage = pageNo;
  };

  $scope.filter = function() {
      $timeout(function() { 
          $scope.filteredItems = $scope.filtered.length;
      }, 25);
  };
});

app.controller('SoPaymentEditController',['$scope','$routeParams','$http','$timeout',
  function($scope,$routeParams,$http,$timeout){
    var id = $routeParams.id;

    function count(type){
      var count = 0;

      for (var i = $scope.paymentDetail.length - 1; i >= 0; i--) {
        if (type == 0) {
          count = parseFloat($scope.paymentDetail[i]['tunai']) + parseFloat(count);
        }
        else {
          count = parseFloat($scope.paymentDetail[i]['giro']) + parseFloat(count);
        }
      };

      return count;
    };

    function convertToRp(input){
      if (input == null) {
        return input;
      }
      else {
        var rp = '';    
        input = parseFloat(input).toFixed(2);
        var angkarev = input.toString().split('').reverse().join('');
        var dec = angkarev.substr(0,2).split('').reverse().join('');
        var num = angkarev.substr(3,input.length-3).split('').reverse().join('');

        angkarev = num.toString().split('').reverse().join('');

        for(var i = 0; i < angkarev.length; i++){
          if(i%3 == 0){
            rp += angkarev.substr(i,3)+'.';
          } 
        } 

        var output = rp.split('',rp.length-1).reverse().join('')+','+dec;

        if (output.substr(0,1) == '-' && output.substr(1,1) == '.'){
          output = '-'+output.substr(2,output.length-2);
        }

        return output;
      }
    }

    $http.get(url_base+'so_payment/paymentHeaderSelected/'+id).success(function (records){
      $scope.paymentIdSelected = records[0]['no_dt'];
      $scope.paymentDateSelected = records[0]['tg_tagih'];
      $scope.paymentSalesmanSelected = records[0]['nm_jaja'];
    });

    $http.get(url_base+'so_payment/paymentDetailSelected/'+id).success(function (records){
      $scope.paymentDetail = records;

      var now = new Date();

      for(var i = 0; i < records.length; i++){
        $scope.paymentDetail[i].totalRp = convertToRp($scope.paymentDetail[i].total);
        var due = new Date($scope.paymentDetail[i].jt_tempo);

        if (now < due){
          $scope.paymentDetail[i].red = 0;
        }
        else {
          $scope.paymentDetail[i].red = 1;
        }
      }
      
      $scope.cashTotal = convertToRp(count(0));
      $scope.giroTotal = convertToRp(count(1));
    });

    $scope.updateCount = function(index,id,type){
      if (type == 0) {
        var pId = "p"+index;
      }
      else if (type == 1) {
        var pId = "q"+index;
      }
      else {
        var pId = "r"+index;
      }

      var newVal = $("#"+pId).val();

      for (var i = $scope.paymentDetail.length - 1; i >= 0; i--) {
        if ($scope.paymentDetail[i].no_fak == id && type == 0) {
          $scope.paymentDetail[i].tunai = newVal;
          $("#"+pId).val(newVal);
          $scope.cashTotal = convertToRp(count(type));
        };

        if ($scope.paymentDetail[i].no_fak == id && type == 1) {
          $scope.paymentDetail[i].giro = newVal;
          $("#"+pId).val(newVal);
          $scope.giroTotal = convertToRp(count(type));
        };

        if ($scope.paymentDetail[i].no_fak == id && type == 2) {
          $scope.paymentDetail[i].ket = newVal;
          $("#"+pId).val(newVal);
        };
      };
    };

    function makePayment(){
      var result = '';
      result += "<h2 align='center'>DEBT PAYMENT LIST</h4>";
      result += "<h4>Payment ID : "+$scope.paymentIdSelected+"</h4>";
      result += "<h4>Payment Date : "+$scope.paymentDateSelected+"</h4>";
      result += "<h4>Salesman : "+$scope.paymentSalesmanSelected+"</h4>";

      result += "<table width=1100 border=1 class='table table-striped table-bordered' cellpadding='10'>";

      result += "<thead>";
      result += "<th>Invoice no</th>";
      result += "<th>Invoice date</th>";
      result += "<th>Due date</th>";
      result += "<th>Customer</th>";
      result += "<th>Total</th>";
      result += "<th>Cash</th>";
      result += "<th>Giro</th>";
      result += "<th>Description</th>";
      result += "</thead>";

      for (var i = 0; i < $scope.paymentDetail.length; i++){
        result += "<tr>";
        if ($scope.paymentDetail[i]['red'] == 0){
          result += "<td>"+$scope.paymentDetail[i]['no_fak']+"</td>";
          result += "<td>"+$scope.paymentDetail[i]['tg_fak']+"</td>";
          result += "<td>"+$scope.paymentDetail[i]['jt_tempo']+"</td>";
          result += "<td>"+$scope.paymentDetail[i]['namalang']+"</td>";
          result += "<td>"+convertToRp($scope.paymentDetail[i]['total'])+"</td>";
        }
        else {
          result += "<td><font color='red'>"+$scope.paymentDetail[i]['no_fak']+"</td>";
          result += "<td><font color='red'>"+$scope.paymentDetail[i]['tg_fak']+"</td>";
          result += "<td><font color='red'>"+$scope.paymentDetail[i]['jt_tempo']+"</td>";
          result += "<td><font color='red'>"+$scope.paymentDetail[i]['namalang']+"</td>";
          result += "<td><font color='red'>"+convertToRp($scope.paymentDetail[i]['total'])+"</td>";
        }
        result += "<td>"+convertToRp($scope.paymentDetail[i]['tunai'])+"</td>";
        result += "<td>"+convertToRp($scope.paymentDetail[i]['giro'])+"</td>";
        result += "<td><textarea rows='3' cols='40'>"+$scope.paymentDetail[i]['ket']+"</textarea></td>";
        result += "</tr>";
      }

      result += "</table>";
      result += "<br>";

      result += "<br>";
      /*result += "<h2>Cash : "+$scope.cashTotal+"</h2>";
      result += "<h2>Giro : "+$scope.giroTotal+"</h2>";*/

      result += "<table width=1100>";
      result += "<tr>";
      result += "<td align='center'>Acknowledged</td>";
      result += "<td align='center'>Submit</td>";
      result += "<td align='center'>Person In Charged</td>";
      result += "<td></td>";
      result += "</tr>";
      result += "<tr></tr>";
      result += "<td height='60px'></td>";
      result += "<td height='60px'></td>";
      result += "<td height='60px'></td>";
      result += "<td align='left'><h3>Cash : "+$scope.cashTotal+"</h3><h3>Giro : "+$scope.giroTotal+"</h3></td>";
      result += "<tr>";
      result += "<td align='center'>....................</td>";
      result += "<td align='center'>....................</td>";
      result += "<td align='center'>....................</td>";
      result += "<td></td>";
      result += "</tr>";
      result += "</table>";

      return result;
    }

    $scope.printPayment = function() {
      var popupWinindow = window.open('', '_blank', 'width=1130,height=700,scrollbars=yes,menubar=no,toolbar=no,location=no,status=no,titlebar=no');
      popupWinindow.document.open();
      popupWinindow.document.write('<html><body onload="window.print()">' + makePayment() + '</html>');
      popupWinindow.document.close();
    }

    $scope.editPayment = function(isgen,status,view) {
      if (isNaN(count(0)) == true || isNaN(count(1)) == true){
        $.growl.warning({ message: 'Empty field' });
      }
      else {
        if(!isgen){
          $scope.loading = true; 
        };
  
        var json = JSON.stringify($scope.paymentDetail);

        //alert(json);

        $.ajax({
          type: 'post',
          url:url_base+'so_payment/editPayment',
          data: "json="+json,
          success: function(msg){
            //alert(msg);
            var obj = JSON.parse(msg);
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
                if (obj.status == 'sukses') {
                  $.growl.notice({ message: "Data saved" });
                  if (view == 0) {
                    location.href = "#/paymentHistoryX";
                  }
                  else {
                    location.href = "#/paymentHistory";
                  }
                } 
                else {
                  $.growl.error({ message: "Update failed. Try again !" });
                };
              }
            },1000);
          },
          error: function(XMLHttpRequest, textStatus, errorThrown) {
            //alert(errorThrown);
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
              }
              $.growl.error({ message: "Update failed. <br/>Check connection and try again !" });
            },1000);
          } 
        });
      }
    };
  }
]);
