app.controller('SoRouteHistoryController', function($scope,$http, $timeout) {
  $http.get(url_base+"so_route/routeList").success(function (records) {
    $scope.routeHeader = records;
    $scope.currentPage = 1;
    $scope.entryLimit = 25;
    $scope.filteredItems = $scope.routeHeader.length;
    $scope.totalItems = $scope.routeHeader.length;
  });

  $scope.setPage = function(pageNo) {
      $scope.currentPage = pageNo;
  };

  $scope.filter = function() {
      $timeout(function() { 
          $scope.filteredItems = $scope.filtered.length;
      }, 25);
  };

  $scope.deleteRoute = function(id,salesman,customer) {
    if (confirm("Delete confirmation")){
      $scope.dataDelete = {"id":id,"salesman":salesman,"customer":customer};
    
      var json = JSON.stringify($scope.dataDelete);

      $.ajax({
        type: 'post',
        url:url_base+'so_route/deleteRoute',
        data: "json="+json,
        success: function(msg){
          //alert(msg);
          var obj = JSON.parse(msg);
            if (obj.status == 'sukses') {
              for (var i = $scope.routeHeader.length - 1; i >= 0; i--) {
                if ($scope.routeHeader[i]['route_id'] == id && $scope.routeHeader[i]['salesman_name'] == salesman && $scope.routeHeader[i]['customer_id'] == customer){
                  $scope.routeHeader.splice(i,1);
                  $scope.$apply();
                }
              };

              $.growl.notice({ message: "Data deleted" });
            } 
            else if (obj.status == 'gagal'){
              $.growl.error({ message: "Delete failed. Try again !" });
            }
            else{
              $.growl.notice({ message: "Data can't be deleted" });
            };
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          //alert(errorThrown);
          $timeout(function(){
            $.growl.error({ message: "Delete Failed. <br/>Check connection and try again !" });
          },1000);
        } 
      });
    }
    return false;
  };
});

app.controller('SoRouteEditController',['$scope','$routeParams','$http','$timeout',
  function($scope,$routeParams,$http,$timeout){
    $scope.routeIdSelected = '';
    $scope.routeWeekSelected = $routeParams.week;
    $scope.routeDaySelected = $routeParams.day;
    $scope.routeSalesmanSelected = $routeParams.salesman;
    $scope.routeCustomerSelected = $routeParams.customer;
    $scope.routeDetail = [];

    $scope.routeWeekList = [{"route_week":"1"},{"route_week":"2"}];
    $scope.routeDayList = [{"route_day":"Monday"},{"route_day":"Tuesday"},{"route_day":"Wednesday"},{"route_day":"Thursday"},{"route_day":"Friday"}];

    $http.get(url_base+'so_route/routeSalesmanList').success(function (records){
      $scope.routeSalesmanList = records;
    });

    $http.get(url_base+'so_route/routeCustomerList').success(function (records){
      $scope.routeCustomerList = records;
    });

    $scope.editRoute = function(isgen,status) {
      var valid1 = 0;
      var valid2 = 0;
      var valid3 = 0;
      var valid4 = 0;

      for (var i = $scope.routeWeekList.length - 1; i >= 0; i--) {
        if ($scope.routeWeekSelected == $scope.routeWeekList[i].route_week) {
          valid1 = 1;
        }
      }

      for (var j = $scope.routeDayList.length - 1; j >= 0; j--) {
        if ($scope.routeDaySelected == $scope.routeDayList[j].route_day) {
          valid2 = 1;
        }
      }

      for (var k = $scope.routeSalesmanList.length - 1; k >= 0; k--) {
        if ($scope.routeSalesmanSelected == $scope.routeSalesmanList[k].route_salesman) {
          valid3 = 1;
        }
      }

      for (var l = $scope.routeCustomerList.length - 1; l >= 0; l--) {
        if ($scope.routeCustomerSelected == $scope.routeCustomerList[l].route_customer) {
          valid4 = 1;
        }
      }

      if (valid1 == 0){
        $.growl.warning({ message: 'Week field is not valid' });
      }
      else if (valid2 == 0) {
        $.growl.warning({ message: 'Day field is not valid' });
      }
      else if (valid3 == 0) {
        $.growl.warning({ message: 'Salesman field is not valid' });
      }
      else if (valid4 == 0) {
        $.growl.warning({ message: 'Customer field is not valid' });
      }
      else {
        if(!isgen){
          $scope.loading = true; 
        };

        if ($scope.routeWeekSelected == 1 && $scope.routeDaySelected == 'Monday'){
          $scope.routeIdSelected = 1;
        }
        else if ($scope.routeWeekSelected == 1 && $scope.routeDaySelected == 'Tuesday') {
          $scope.routeIdSelected = 2;
        }
        else if ($scope.routeWeekSelected == 1 && $scope.routeDaySelected == 'Wednesday') {
          $scope.routeIdSelected = 3;
        }
        else if ($scope.routeWeekSelected == 1 && $scope.routeDaySelected == 'Thursday') {
          $scope.routeIdSelected = 4;
        }
        else if ($scope.routeWeekSelected == 1 && $scope.routeDaySelected == 'Friday') {
          $scope.routeIdSelected = 5;
        }
        else if ($scope.routeWeekSelected == 2 && $scope.routeDaySelected == 'Monday'){
          $scope.routeIdSelected = 6;
        }
        else if ($scope.routeWeekSelected == 2 && $scope.routeDaySelected == 'Tuesday') {
          $scope.routeIdSelected = 7;
        }
        else if ($scope.routeWeekSelected == 2 && $scope.routeDaySelected == 'Wednesday') {
          $scope.routeIdSelected = 8;
        }
        else if ($scope.routeWeekSelected == 2 && $scope.routeDaySelected == 'Thursday') {
          $scope.routeIdSelected = 9;
        }
        else {
          $scope.routeIdSelected = 10;
        }

        $scope.routeDetail.push({"route_id":$routeParams.id,"route_week":$routeParams.week,"route_day":$routeParams.day,"route_salesman":$routeParams.salesman,"route_customer":$routeParams.customer});
        $scope.routeDetail.push({"route_id":$scope.routeIdSelected,"route_week":$scope.routeWeekSelected,"route_day":$scope.routeDaySelected,"route_salesman":$scope.routeSalesmanSelected,"route_customer":$scope.routeCustomerSelected});
  
        var json = JSON.stringify($scope.routeDetail);

        $.ajax({
          type: 'post',
          url:url_base+'so_route/editRoute',
          data: "json="+json,
          success: function(msg){
            //alert(msg);
            var obj = JSON.parse(msg);
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
                if (obj.status == 'sukses') {
                  $.growl.notice({ message: "Data saved" });
                 
                  location.href = "#/routeHistoryX";
                } 
                else {
                  $.growl.error({ message: "Update failed. Try again !" });
                };
              }
            },1000);
          },
          error: function(XMLHttpRequest, textStatus, errorThrown) {
            //alert(errorThrown);
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
              }
              $.growl.error({ message: "Update failed. <br/>Check connection and try again !" });
            },1000);
          } 
        });
      }
    };
  }
]);

app.controller('SoRouteNewController', function($scope,$http, $timeout) {
  $scope.routeIdNew = '';
  $scope.routeWeekNew = '';
  $scope.routeDayNew = '';
  $scope.routeSalesmanNew = '';
  $scope.routeCustomerNew = '';
  $scope.routeDetail = [];

  $scope.routeWeekList = [{"route_week":"1"},{"route_week":"2"}];
  $scope.routeDayList = [{"route_day":"Monday"},{"route_day":"Tuesday"},{"route_day":"Wednesday"},{"route_day":"Thursday"},{"route_day":"Friday"}];

  $http.get(url_base+'so_route/routeSalesmanList').success(function (records){
    $scope.routeSalesmanList = records;
  });

  $http.get(url_base+'so_route/routeCustomerList').success(function (records){
    $scope.routeCustomerList = records;
  });

  $scope.newRoute = function(isgen,status) {
    var valid1 = 0;
    var valid2 = 0;
    var valid3 = 0;
    var valid4 = 0;

    for (var i = $scope.routeWeekList.length - 1; i >= 0; i--) {
      if ($scope.routeWeekNew == $scope.routeWeekList[i].route_week) {
        valid1 = 1;
      }
    }

    for (var j = $scope.routeDayList.length - 1; j >= 0; j--) {
      if ($scope.routeDayNew == $scope.routeDayList[j].route_day) {
        valid2 = 1;
      }
    }

    for (var k = $scope.routeSalesmanList.length - 1; k >= 0; k--) {
      if ($scope.routeSalesmanNew == $scope.routeSalesmanList[k].route_salesman) {
        valid3 = 1;
      }
    }

    for (var l = $scope.routeCustomerList.length - 1; l >= 0; l--) {
      if ($scope.routeCustomerNew == $scope.routeCustomerList[l].route_customer) {
        valid4 = 1;
      }
    }

    if (valid1 == 0){
      $.growl.warning({ message: 'Week field is not valid' });
    }
    else if (valid2 == 0) {
      $.growl.warning({ message: 'Day field is not valid' });
    }
    else if (valid3 == 0) {
      $.growl.warning({ message: 'Salesman field is not valid' });
    }
    else if (valid4 == 0) {
      $.growl.warning({ message: 'Customer field is not valid' });
    }
    else {
      if(!isgen){
        $scope.loading = true; 
      };

      if ($scope.routeWeekNew == 1 && $scope.routeDayNew == 'Monday'){
        $scope.routeIdNew = 1;
      }
      else if ($scope.routeWeekNew == 1 && $scope.routeDayNew == 'Tuesday') {
        $scope.routeIdNew = 2;
      }
      else if ($scope.routeWeekNew == 1 && $scope.routeDayNew == 'Wednesday') {
        $scope.routeIdNew = 3;
      }
      else if ($scope.routeWeekNew == 1 && $scope.routeDayNew == 'Thursday') {
        $scope.routeIdNew = 4;
      }
      else if ($scope.routeWeekNew == 1 && $scope.routeDayNew == 'Friday') {
        $scope.routeIdNew = 5;
      }
      else if ($scope.routeWeekNew == 2 && $scope.routeDayNew == 'Monday'){
        $scope.routeIdNew = 6;
      }
      else if ($scope.routeWeekNew == 2 && $scope.routeDayNew == 'Tuesday') {
        $scope.routeIdNew = 7;
      }
      else if ($scope.routeWeekNew == 2 && $scope.routeDayNew == 'Wednesday') {
        $scope.routeIdNew = 8;
      }
      else if ($scope.routeWeekNew == 2 && $scope.routeDayNew == 'Thursday') {
        $scope.routeIdNew = 9;
      }
      else {
        $scope.routeIdNew = 10;
      }

      $scope.routeDetail = {"route_id":$scope.routeIdNew,"route_week":$scope.routeWeekNew,"route_day":$scope.routeDayNew,"route_salesman":$scope.routeSalesmanNew,"route_customer":$scope.routeCustomerNew};

      var json = JSON.stringify($scope.routeDetail);

      $.ajax({
        type: 'post',
        url:url_base+'so_route/newRoute',
        data: "json="+json,
        success: function(msg){
          //alert(msg);
          var obj = JSON.parse(msg);
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              if (obj.status == 'sukses') {
                $.growl.notice({ message: "Data saved" });
               
                location.href = "#/routeHistoryX";
              } 
              else {
                $.growl.error({ message: "Insert failed. Try again !" });
              };
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          //alert(errorThrown);
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
            }
            $.growl.error({ message: "Insert failed. <br/>Check connection and try again !" });
          },1000);
        } 
      });
    }
  };
});

