app.controller('StockController',function($scope, $http, $timeout){
    $scope.pageClass = 'page-home';
    $http.get(url_base+'stocks').success(function(data){
        $scope.list = data.list;
		$scope.periode_start = data.periode_start;
		$scope.periode_end = data.periode_end;
        $scope.currentPage = 1; //current page
        $scope.entryLimit = 50; //max no of items to display in a page
        $scope.filteredItems = $scope.list.length; //Initially for no filter  
        $scope.totalItems = $scope.list.length;
    });
	
    $scope.setPage = function(pageNo) {
        $scope.currentPage = pageNo;
    };

    $scope.filter = function() {
        $timeout(function() { 
            $scope.filteredItems = $scope.filtered.length;
        }, 50);
    }; 
});

app.controller('ViewStockController',function($scope, $http, $timeout,UtilList){
    $scope.pageClass = 'page-home';
	
	UtilList.outletList(function(data) {
		$scope.outlets = data;
	});

	Date.prototype.yyyymmdd = function() {
		var yyyy = this.getFullYear().toString();
		var mm = (this.getMonth()+1).toString(); // getMonth() is zero-based
		var dd  = this.getDate().toString();
		return yyyy + '-' + (mm[1]?mm:"0"+mm[0]) + '-' + (dd[1]?dd:"0"+dd[0]); // padding
	};

	var d = new Date();
	var dateNow = d.yyyymmdd();
	
	$scope.stocks = {periode_start:dateNow, periode_end:dateNow};
	$scope.list = [];
	$scope.currentPage = 1;
	$scope.entryLimit = 50;
	$scope.filteredItems = $scope.list.length;
	$scope.totalItems = $scope.list.length;
	
	$scope.viewStock = function(stocks)
	{
		var url = url_base + 'stocks';
		var responseData = $http.post(url,{'Stocks':stocks});
		
		responseData.success(function(data, status, headers, config)
		{
			$scope.list = data;
			$scope.currentPage = 1;
			$scope.entryLimit = 50;
			$scope.filteredItems = $scope.list.length;
			$scope.totalItems = $scope.list.length;
		});
		
		responseData.error(function(data, status, headers, config) {
			//alert("AJAX failed!");
		});
	}
	
	$scope.checkForm = function(stocks)
	{
		if((stocks.outlet_id != '') && (!isNaN(stocks.outlet_id)) && (stocks.outlet_id > 0))
			return false;
		return true;
	}
	
    $scope.setPage = function(pageNo) {
        $scope.currentPage = pageNo;
    };

    $scope.filter = function() {
        $timeout(function() { 
            $scope.filteredItems = $scope.filtered.length;
        }, 50);
    }; 
});

app.controller('StockOpnameController',function($scope, $http, $timeout){
    $scope.pageClass = 'page-home';
    $http.get(url_base+'stock/opnames').success(function(data){
        $scope.list = data;
        $scope.currentPage = 1; //current page
        $scope.entryLimit = 50; //max no of items to display in a page
        $scope.filteredItems = $scope.list.length; //Initially for no filter  
        $scope.totalItems = $scope.list.length;
    });
	
    $scope.setPage = function(pageNo) {
        $scope.currentPage = pageNo;
    };

    $scope.filter = function() {
        $timeout(function() { 
            $scope.filteredItems = $scope.filtered.length;
        }, 50);
    };
});

app.controller("NewStockOpnameController",function ($scope,$routeParams,$http,$timeout,UtilList)
{ 
	var edit_id = +($routeParams.eid);
	$scope.save_success = '';
	$scope.save_error = '';
	$scope.outlet_id = 0;
	UtilList.outletList(function(data) {
		$scope.outlets = data;
	});

	if((angular.isNumber(edit_id) && !isNaN(edit_id)) || (angular.isUndefined($routeParams.eid)))
	{
		if(angular.isNumber(edit_id) && !isNaN(edit_id))
		{
			$scope.title = 'Ubah Stock Opname';	
			var url = url_base + 'stock/opnames/update/' + edit_id;

			var responseData = $http.get(url);
			responseData.success(function(data, status, headers, config) {
				$scope.opname = data.opname[0];
				$scope.details = data.details;
				$scope.currentPage = 1; //current page
				$scope.entryLimit = 25; //max no of items to display in a page
				$scope.filteredItems = $scope.details.length; //Initially for no filter  
				$scope.totalItems = $scope.details.length;
				$scope.isDisable = true;
				$scope.isNew = false;
			});
			responseData.error(function(data, status, headers, config) {
				alert("Data tidak bisa di ambil !");
			});
		} else if(angular.isUndefined($routeParams.eid)) {
			$scope.title = 'Tambah Stock Opname';
			$scope.opname = {};
			$scope.isDisable = false;
			$scope.isNew = true;
		}
		
		$scope.submitForm = function (products)
		{
			var edit_id = +($routeParams.eid);
			if(angular.isNumber(edit_id) && !isNaN(edit_id))
			{
				var url = url_base + 'stock/opnames/update/' + edit_id;
				var responseData = $http.post(url,{'Products':products});
			} else {
				var url = url_base + 'stock/opnames/create';
				var responseData = $http.post(url,{'Products':products});
			}
			
			responseData.success(function(data, status, headers, config)
			{
				$scope.save_success = '';
				if(data.success) {
					$scope.save_success = data.success.msg;
				}
				if(data.success) {
					$scope.save_success = data.success.msg;
					if(!(angular.isNumber(edit_id) && !isNaN(edit_id)))
						$routeParams.eid = data.product[0].product_id;
					$location.path('product_new/' + $routeParams.eid, false);
				}
				$scope.save_error = '';
				if(data.error) {
					$scope.save_error = data.error.msg;
				}
				if(data.status) {		
					$location.path('products');			
				}
			});
			
			responseData.error(function(data, status, headers, config) {
				//alert("AJAX failed!");
			});
		};
	} else {
		$scope.msg = 'Wrong url input';
	}
	
	$scope.setPage = function(pageNo) {
		$scope.currentPage = pageNo;
	};

	$scope.filter = function() {
		$timeout(function() { 
		//	$scope.filteredItems = $scope.filtered.length;
		}, 25);
	};
	
	$scope.sumeriza_dev = function(id){
		var value = $('#sf_'+id).val();
		var stock_end = $('#se_'+id).val(); 


		$('#dev_'+id).html(value-stock_end);
	}
	
	$scope.getOpnameData = function()
	{
		var url = url_base + 'stock/opnames/getperiode';

		var responseData = $http.post(url,{'outlet_id':$scope.opname.outlet_id});
		responseData.success(function(data, status, headers, config) {
			$scope.opname.periode_start = data.periode_start;
			$scope.opname.periode_end = data.periode_end;
		});
		responseData.error(function(data, status, headers, config) {
			alert("Data tidak bisa di ambil !");
		});
	}

	$scope.submit_data = function()
	{	var data_post = [];
		for (var i = $scope.details.length - 1; i >= 0; i--) {
			var obj = $scope.details[i];
			if ($('#stock_edit_'+obj.product_code).val()!= '') {
				obj.stok_actual = $('#stock_edit_'+obj.product_code).val();
				obj.stock_dev   = $('#stock_deviation_'+obj.product_code).val();
				data_post.push(obj);
			};
		};

		var x = JSON.stringify(data_post);
		$scope.loading = true;
		$.ajax({
			url:url_base+'index.php/stock_opname/update_data',
			type:'post',
			data:'json='+x,
			success:function(msg){
				console.log(msg);
				 console.log(msg);
                    $timeout(function(){
                        $scope.loading = false; // stop loading
                        if (msg!= 'gagal') {
                            $.growl.notice({ message: "data telah kirim" });
                        } else{
                            $.growl.error({ message: "something wrong" });
                        };
                    },1000);
			}
		});
		
	}
	
	$scope.generateOpname = function(opname)
	{
		var url = url_base + 'stock/opnames/create';

		var responseData = $http.post(url,{'opname':opname});
		responseData.success(function(data, status, headers, config) {
			$scope.opname = data.opname[0];
			$scope.details = data.details;
			$scope.currentPage = 1; //current page
			$scope.entryLimit = 50; //max no of items to display in a page
			$scope.filteredItems = $scope.details.length; //Initially for no filter  
			$scope.totalItems = $scope.details.length;
			$scope.isDisable = true;
			$scope.isNew = false;
		});
		responseData.error(function(data, status, headers, config) {
			alert("Data tidak bisa di ambil !");
		});
	}

	$scope.add_stock = function(data){
		var data_fisik = $('#stock_edit_'+data.product_code).val();
		var data_end   = $('#stock_akhir_'+data.product_code).val();
		var data_dev = parseFloat(data_fisik) - parseFloat(data_end);
		$('#html_data_deviation_'+data.product_code).html(data_dev);
		$('#stock_deviation_'+data.product_code).val(data_dev)
	}

	$scope.add_stokc = function(data){

	}

	$scope.show_modal = function(){
		$('#modal_opname_product').modal({backdrop:true});

	}

	$scope.modal_product_hide = function(){
		$('#modal_opname_product').modal('hide');
	}
});


app.controller('ViewStockOpnameController',function($scope,$routeParams, $http, $timeout){
    var pk = $routeParams.eid;
	$scope.pid = $routeParams.eid;
	$scope.detail = [];
	$http.get(url_base+'stock/opnames/view/'+pk).success(function(data){
		$scope.header = data.opname[0];
		$scope.detail = data.details;
	 });
	
	$scope.exportExcel = function(reports)
	{
		$http({
			url: 'stock/opnames/export/'+pk,
			method: 'POST',
			dataType: 'json',
		})
		.success(function (data, status, headers, config)
		{
			window.open(data);
		})
		.error(function(data, status, headers, config) {
			alert("AJAX failed!");
		})
	}
});