app.controller('TrialBalanceController', function($scope,$http, $timeout,$window) {
  $(window).off("keypress");
  $scope.yprevrp = 0.00;
  $scope.ydebitrp = 0.00;
  $scope.ycreditrp = 0.00;
  $scope.ynextrp = 0.00;

  $scope.acuHide = true;

  $("#tbDatepickerStart").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#tbDatepickerStart").on('changeDate',function(){
    $(this).datepicker("hide");
  });

   $("#tbDatepickerEnd").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#tbDatepickerEnd").on('changeDate',function(){
    $(this).datepicker("hide");
  });

  $http.get(url_base+'trialbalance/headAccount').success(function (records){
    $http.get(url_base+'trialbalance/lastMonthTrialBalance').success(function (records2){
      $scope.trialbalanceList = records2;

      $scope.yprev = 0;
      $scope.ydebitcur = 0;
      $scope.ycreditcur = 0;
      $scope.ynext = 0;

      for (var i = $scope.trialbalanceList.length - 1; i >= 0; i--) {
        if ($scope.trialbalanceList[i]['type'] == 0){
          $scope.trialbalanceList[i]['debitprev'] = parseFloat($scope.trialbalanceList[i]['debitprev']) + parseFloat($scope.trialbalanceList[i]['saldo']);
        }
        else{
          $scope.trialbalanceList[i]['creditprev'] = parseFloat($scope.trialbalanceList[i]['creditprev']) + parseFloat($scope.trialbalanceList[i]['saldo']);
        }


        $scope.trialbalanceList[i]['prev'] = parseFloat($scope.trialbalanceList[i]['debitprev'])-parseFloat($scope.trialbalanceList[i]['creditprev'])
        $scope.trialbalanceList[i]['prevrp'] = convertToRp($scope.trialbalanceList[i]['prev']);

        $scope.trialbalanceList[i]['debitcurrp'] = convertToRp($scope.trialbalanceList[i]['debitcur']);
        $scope.trialbalanceList[i]['creditcurrp'] = convertToRp($scope.trialbalanceList[i]['creditcur']);
        
        if ($scope.trialbalanceList[i]['acctype'] == 'd'){
          $scope.trialbalanceList[i]['prev'] = parseFloat($scope.trialbalanceList[i]['debitprev']) - parseFloat($scope.trialbalanceList[i]['creditprev']);
          $scope.trialbalanceList[i]['next'] = parseFloat($scope.trialbalanceList[i]['debitprev']) - parseFloat($scope.trialbalanceList[i]['creditprev']) + parseFloat($scope.trialbalanceList[i]['debitcur']) - parseFloat($scope.trialbalanceList[i]['creditcur']);
        }
        else {
          $scope.trialbalanceList[i]['prev'] = parseFloat($scope.trialbalanceList[i]['creditprev']) - parseFloat($scope.trialbalanceList[i]['debitprev'])
          $scope.trialbalanceList[i]['next'] = parseFloat($scope.trialbalanceList[i]['creditprev']) - parseFloat($scope.trialbalanceList[i]['debitprev']) - parseFloat($scope.trialbalanceList[i]['debitcur']) + parseFloat($scope.trialbalanceList[i]['creditcur']);
        }

        $scope.trialbalanceList[i]['prevrp'] = convertToRp($scope.trialbalanceList[i]['prev']);
        $scope.trialbalanceList[i]['nextrp'] = convertToRp($scope.trialbalanceList[i]['next']);
      };

      var total1 = 0;
      var total2 = 0;
      var total3 = 0;
      var total4 = 0;

      $scope.headAccountList = records;

      for (var i = $scope.headAccountList.length - 1; i >= 0; i--) {
        for (var j = $scope.trialbalanceList.length - 1; j >= 0; j--) {
          if ($scope.headAccountList[i]['glno'] == $scope.trialbalanceList[j]['head']){
            total1 = parseFloat(total1) + parseFloat($scope.trialbalanceList[j]['prev']);
            total2 = parseFloat(total2) + parseFloat($scope.trialbalanceList[j]['next']);
            total3 = parseFloat(total3) + parseFloat($scope.trialbalanceList[j]['debitcur']);
            total4 = parseFloat(total4) + parseFloat($scope.trialbalanceList[j]['creditcur']);
          }
        };

        $scope.headAccountList[i]['xprev'] = total1;
        $scope.headAccountList[i]['xnext'] = total2;
        $scope.headAccountList[i]['xdebitcur'] = total3;
        $scope.headAccountList[i]['xcreditcur'] = total4;

        $scope.headAccountList[i]['xprevrp'] = convertToRp(total1);
        $scope.headAccountList[i]['xnextrp'] = convertToRp(total2);
        $scope.headAccountList[i]['xdebitcurrp'] = convertToRp(total3);
        $scope.headAccountList[i]['xcreditcurrp'] = convertToRp(total4);

        $scope.yprev = parseFloat(total1) + parseFloat($scope.yprev);
        $scope.ynext = parseFloat(total2) + parseFloat($scope.ynext);
        $scope.ydebitcur = parseFloat(total3) + parseFloat($scope.ydebitcur);
        $scope.ycreditcur = parseFloat(total4) + parseFloat($scope.ycreditcur);

        total1 = 0;
        total2 = 0;
        total3 = 0;
        total4 = 0;
      };

      $scope.yprevrp = convertToRp($scope.yprev);
      $scope.ydebitrp = convertToRp($scope.ydebitcur);
      $scope.ycreditrp = convertToRp($scope.ycreditcur);
      $scope.ynextrp = convertToRp($scope.ynext);

      $scope.acuHide = false;
      $scope.$apply();
    
      $scope.currentPage = 1;
      $scope.entryLimit = 5;
      $scope.filteredItems = $scope.headAccountList.length;
      $scope.totalItems = $scope.headAccountList.length;
    });
  });

  $scope.setPage = function(pageNo) {
    $scope.currentPage = pageNo;
  };

  function convertToRp(input){
    var rp = '';    
    input = parseFloat(input).toFixed(2);
    var angkarev = input.toString().split('').reverse().join('');
    var dec = angkarev.substr(0,2).split('').reverse().join('');
    var num = angkarev.substr(3,input.length-3).split('').reverse().join('');

    angkarev = num.toString().split('').reverse().join('');

    for(var i = 0; i < angkarev.length; i++){
      if(i%3 == 0){
        rp += angkarev.substr(i,3)+'.';
      } 
    } 

    var output = rp.split('',rp.length-1).reverse().join('')+','+dec;

    if (output.substr(0,1) == '-' && output.substr(1,1) == '.'){
      output = '-'+output.substr(2,output.length-2);
    }

    return output;
  }

  $scope.filter = function() {
    $timeout(function() { 
      $scope.filteredItems = $scope.filtered.length;
    }, 50);
  };

  $scope.generateTrialBalance = function(isgen,status){
    if ($("#tbDatepickerStart").val() == ''){
      $.growl.notice({ message: "Fill in Start Date" });
    }
    else if($("#tbDatepickerEnd").val() == ''){
      $.growl.notice({ message: "Fill in End Date" });
    }
    else if(Date.parse($("#tbDatepickerStart").val()) > Date.parse($("#tbDatepickerEnd").val())){
      $.growl.notice({ message: "Start Date must be lower than End Date" });
    }
    else{
      if(!isgen){
        $scope.loading = true; 
      };

      $scope.inputDate = {"start":$("#tbDatepickerStart").val(),"end":$("#tbDatepickerEnd").val()};

      var json = JSON.stringify($scope.inputDate);

      $.ajax({
        type: 'post',
        url:url_base+'trialbalance/generateTrialBalance',
        data: "json="+json,
        success: function(msg){
          //$scope.testt = $("#tbDatepickerStart").val() + " - " + $("#tbDatepickerEnd").val();
          $scope.trialbalanceList = JSON.parse(msg);

          $timeout(function(){       
            if(!isgen){
              if ($scope.trialbalanceList[0]['status'] == 'sukses') {
                $scope.yprev = 0;
                $scope.ydebitcur = 0;
                $scope.ycreditcur = 0;
                $scope.ynext = 0;

                for (var i = $scope.trialbalanceList.length - 1; i >= 0; i--) {
                  if ($scope.trialbalanceList[i]['type'] == 0){
                    $scope.trialbalanceList[i]['debitprev'] = parseFloat($scope.trialbalanceList[i]['debitprev']) + parseFloat($scope.trialbalanceList[i]['saldo']);
                  }
                  else{
                    $scope.trialbalanceList[i]['creditprev'] = parseFloat($scope.trialbalanceList[i]['creditprev']) + parseFloat($scope.trialbalanceList[i]['saldo']);
                  }

                  $scope.trialbalanceList[i]['debitcurrp'] = convertToRp($scope.trialbalanceList[i]['debitcur']);
                  $scope.trialbalanceList[i]['creditcurrp'] = convertToRp($scope.trialbalanceList[i]['creditcur']);
                  
                  if ($scope.trialbalanceList[i]['acctype'] == 'd'){
                    $scope.trialbalanceList[i]['prev'] = parseFloat($scope.trialbalanceList[i]['debitprev']) - parseFloat($scope.trialbalanceList[i]['creditprev']);
                    $scope.trialbalanceList[i]['next'] = parseFloat($scope.trialbalanceList[i]['debitprev']) - parseFloat($scope.trialbalanceList[i]['creditprev']) + parseFloat($scope.trialbalanceList[i]['debitcur']) - parseFloat($scope.trialbalanceList[i]['creditcur']);
                  }
                  else {
                    $scope.trialbalanceList[i]['prev'] = parseFloat($scope.trialbalanceList[i]['creditprev']) - parseFloat($scope.trialbalanceList[i]['debitprev'])
                    $scope.trialbalanceList[i]['next'] = parseFloat($scope.trialbalanceList[i]['creditprev']) - parseFloat($scope.trialbalanceList[i]['debitprev']) - parseFloat($scope.trialbalanceList[i]['debitcur']) + parseFloat($scope.trialbalanceList[i]['creditcur']);
                  }

                  $scope.trialbalanceList[i]['prevrp'] = convertToRp($scope.trialbalanceList[i]['prev']);
                  $scope.trialbalanceList[i]['nextrp'] = convertToRp($scope.trialbalanceList[i]['next']);
                };

                var total1 = 0;
                var total2 = 0;
                var total3 = 0;
                var total4 = 0;

                for (var i = $scope.headAccountList.length - 1; i >= 0; i--) {
                  for (var j = $scope.trialbalanceList.length - 1; j >= 0; j--) {
                    if ($scope.headAccountList[i]['glno'] == $scope.trialbalanceList[j]['head']){
                      total1 = parseFloat(total1) + parseFloat($scope.trialbalanceList[j]['prev']);
                      total2 = parseFloat(total2) + parseFloat($scope.trialbalanceList[j]['next']);
                      total3 = parseFloat(total3) + parseFloat($scope.trialbalanceList[j]['debitcur']);
                      total4 = parseFloat(total4) + parseFloat($scope.trialbalanceList[j]['creditcur']);
                    }
                  };

                  $scope.headAccountList[i]['xprev'] = total1;
                  $scope.headAccountList[i]['xnext'] = total2;
                  $scope.headAccountList[i]['xdebitcur'] = total3;
                  $scope.headAccountList[i]['xcreditcur'] = total4;

                  $scope.headAccountList[i]['xprevrp'] = convertToRp(total1);
                  $scope.headAccountList[i]['xnextrp'] = convertToRp(total2);
                  $scope.headAccountList[i]['xdebitcurrp'] = convertToRp(total3);
                  $scope.headAccountList[i]['xcreditcurrp'] = convertToRp(total4);

                  $scope.yprev = parseFloat(total1) + parseFloat($scope.yprev);
                  $scope.ynext = parseFloat(total2) + parseFloat($scope.ynext);
                  $scope.ydebitcur = parseFloat(total3) + parseFloat($scope.ydebitcur);
                  $scope.ycreditcur = parseFloat(total4) + parseFloat($scope.ycreditcur);

                  total1 = 0;
                  total2 = 0;
                  total3 = 0;
                  total4 = 0;
                  $scope.$apply();
                };

                $scope.yprevrp = convertToRp($scope.yprev);
                $scope.ydebitrp = convertToRp($scope.ydebitcur);
                $scope.ycreditrp = convertToRp($scope.ycreditcur);
                $scope.ynextrp = convertToRp($scope.ynext);
                   
                $scope.currentPage = 1;
                $scope.entryLimit = 5;
                $scope.filteredItems = $scope.headAccountList.length;
                $scope.totalItems = $scope.headAccountList.length;
                $scope.$apply();

                $.growl.notice({ message: "Process done" });
              } 
              else {
                $.growl.error({ message: "Process failed. Try again !" });
              };
              $scope.loading = false;
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
            }
            $.growl.error({ message: "Failed. <br/>Check connection and try again !" });
          },1000);
        }
      });
    }
  }

});
