app.controller('waste_new',function($scope,$http,$timeout,$location){
	$scope.pageClass = 'page-home';

	$http.get(url_base+'master_products/find_all').success(function(data){
        $scope.list = data; 
        array_product = data;
        $scope.currentPage = 1; //current page
        $scope.entryLimit = 10; //max no of items to display in a page
        $scope.filteredItems = $scope.list.length; //Initially for no filter  
        $scope.totalItems = $scope.list.length;
     });


    $http.get(url_base+'waste_menu/header_tanggal_closing').success(function(data){
        $scope.header = data;
    });


    $scope.setPage = function(pageNo) {
        $scope.currentPage = pageNo;
    };

    $scope.filter = function() {
        $timeout(function() { 
            $scope.filteredItems = $scope.filtered.length;
        }, 10);
    };

    $scope.add_items = function(){
    	$('#modal_list_prodict').modal({show:true,backdrop:false,});
		$('#product_items_filter').focus();
    }

    $scope.modal_product_hide = function(){
        $('#modal_list_prodict').modal('hide');
    }
    $scope.current_open;
    $scope.list_data = [];
	
    $scope.add_product = function(data){
		$('#modal_confirmation').modal({show:true,backdrop:false,});
    	$('#field_name').html(data.product_name);
		$('#field_unit').html('1 '+data.unit_large+' = '+data.conversion+' '+data.unit_small);
		$('#subfield_qty').html(data.unit_small);
		$('#quantity_item').val("");
        $('#comments').val("");
        $('#form_qty').removeClass('has-error');
        $('.help-block').html('');
		$('#quantity_item').focus();
    	$scope.current_open = data;
    }

    $scope.modal_confirmation_add = function(){
    	if ($('#quantity_item').val() == '' || $('#quantity_item').val() == '0') {
            $('#form_qty').addClass('has-error');
            $('.help-block').html('data jumlah tidak boleh kosong atau 0');
            $('#quantity_item').focus();
        } else{
           // $scope.current_open.qty = $('#quantity_item').val();
            $scope.current_open.comments = $('#comments').val();
            $scope.insert_temporary();
            $('#quantity_item').val("");
            $('#comments').val("");
            $('#modal_confirmation').modal('hide');
            $('#form_qty').removeClass('has-error');
            $('.help-block').html('')
        };
    }

    $scope.insert_temporary  = function(){
    	 if ($scope.cek_avaliable() == true) {
            $scope.replaces_data();
        } else{
            $scope.add_data();
        };
    }

    $scope.replaces_data = function(){
        var data_temp = [];
        for (var i = $scope.list_data.length - 1; i >= 0; i--) {
            var temp = $scope.list_data[i];
            if (temp.product_code == $scope.current_open.product_code) {
                var sumarize = parseFloat(temp.qty)+parseFloat($('#quantity_item').val());
                $scope.current_open.qty = sumarize;
                data_temp.push($scope.current_open);
            }else{
                data_temp.push(temp);
            };
        };
        $scope.list_data = data_temp;
    }

    $scope.add_data = function(){
        $scope.current_open.qty = $('#quantity_item').val();
        $scope.list_data.push($scope.current_open);
    }

    $scope.cek_avaliable = function(){
        var check_avaliable  = false;
        for (var i = $scope.list_data.length - 1; i >= 0; i--) {
            var temp = $scope.list_data[i];
            if (temp.product_code == $scope.current_open.product_code) {
                cek_avaliable = true;
                return true;
            };
        };

        return check_avaliable;
    }
    //cek double 

     $scope.temp_delete;

    $scope.remove_data = function(data){
        $scope.temp_delete = data;
		$('#del_field_name').html($scope.temp_delete.product_name);
		$('#del_field_qty').html($scope.temp_delete.qty+' '+$scope.temp_delete.unit_small);
        $('#modal_confirmation_delete').modal({
            backdrop:false,
            show:true
        });
    }

    $scope.modal_confirmation_yes = function(){
        var data_temp = [];
        for (var i = $scope.list_data.length - 1; i >= 0; i--) {
            var temp = $scope.list_data[i];
            if (temp.product_code == $scope.temp_delete.product_code) {

            }else{
                data_temp.push(temp);
            };
        };
        $scope.list_data = data_temp;
        $('#modal_confirmation_delete').modal('hide');
    }

    $scope.modal_confirmation_no = function(){
        $('#modal_confirmation_delete').modal('hide');
    }

    $scope.edit_data = function(data){
        $('#modal_confirmation_edit').modal({show:true,backdrop:false,});
		$('#field_name_edit').html(data.product_name);
		$('#field_unit_edit').html('1 '+data.unit_large+' = '+data.conversion+' '+data.unit_small);
		$('#subfield_qty_edit').html(data.unit_small);
        $('#edit_quantity_item').val(data.qty);
        $('#edit_comments').val(data.comments);
		$('#edit_quantity_item').focus();
        $scope.current_open = data;
    }

    $scope.modal_confirmation_close = function(){
        $('#edit_quantity_item').val("");
        $('#edit_comments').val("");
        $('#modal_confirmation_edit').modal('hide');
        $('#edit_form_qty').removeClass('has-error');
        $('.help-block-edit').html('')
    }

    $scope.modal_confirmation_edit = function(){
        if ($('#edit_quantity_item').val() == '' || $('#edit_quantity_item').val() == '0') {
            $('#form_qty').addClass('has-error');
            $('.help-block').html('data jumlah tidak boleh kosong atau 0')
        } else{
            $scope.current_open.qty = $('#edit_quantity_item').val();
            $scope.current_open.comments = $('#edit_comments').val();
          //  $scope.insert_temporary();
            $('#edit_quantity_item').val("");
            $('#edit_comments').val("");
            $('#modal_confirmation_edit').modal('hide');
            $('#edit_form_qty').removeClass('has-error');
            $('.help-block-edit').html('')
        };
    }


    $scope.send_data = function(){
    	 if ($scope.list_data.length > 0) {
                $scope.loading = true;
                var data = JSON.stringify($scope.list_data);
                $.ajax({
	                url:url_base+'waste/create_waste',
                    type:'post',
                    data:'json='+data,
					dataType:'json',
					success:function(msg){
						$timeout(function(){
							$scope.loading = false;
							if (msg.status == 'success') {
								$.growl.notice({ message: "Data BERHASIL di Simpan" });
								$location.path('/waste/'+msg.pk, false);
							} else {
								$.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
							};
						},1000);
					},
					error: function(XMLHttpRequest, textStatus, errorThrown) {
						$timeout(function(){
							$scope.loading = false;
							$.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
						},5000);
					}
                });
            }else{
                $.growl.warning({ message: "Belum ada data untuk di simpan" });
            };
    }
});