app.controller('DoController', function($scope,$http, $timeout) {
  $(window).off("keypress");
  $http.get(url_base+"wh_do/doView").success(function (records) {
    $scope.wh_do = records;
    $scope.currentPage = 1;
    $scope.entryLimit = 25;
    $scope.filteredItems = $scope.wh_do.length;
    $scope.totalItems = $scope.wh_do.length;
  });

  $scope.setPage = function(pageNo) {
      $scope.currentPage = pageNo;
  };

  $scope.filter = function() {
      $timeout(function() { 
          $scope.filteredItems = $scope.filtered.length;
      }, 25);
  };
});

app.controller('DoDetailController',['$scope','$routeParams','$http',
  function($scope,$routeParams,$http){
    var id = $routeParams.id;

    $http.get(url_base+'wh_do/doViewDetailHeader/'+id).success(function (records){
      $scope.doDetailHeader = records;
      $scope.codeDoSelected = $scope.doDetailHeader[0]['do_code'];
      $scope.dateDoSelected = $scope.doDetailHeader[0]['do_date'];
      $scope.codeSoSelected = $scope.doDetailHeader[0]['so_code'];
      $scope.driverSelected = $scope.doDetailHeader[0]['driver_name'];
      $scope.atSelected = $scope.doDetailHeader[0]['created_at'];  
      $scope.bySelected = $scope.doDetailHeader[0]['full_name'];  
      $scope.distinctItem =  $scope.doDetailHeader[0]['item_count'];  
      $scope.countTotal =  $scope.doDetailHeader[0]['total_item_qty'];  
    });

    $http.get(url_base+'wh_do/doViewDetail/'+id).success(function (records){
      $scope.doDetail = records;
    });

    $http.get(url_base+'wh_do/statusSent/'+id).success(function (records){
      $scope.status = records[0]['status'];
    });

    $scope.print = function() {
      //$scope.doParam = {id,};

     // var json = JSON.stringify($scope.doParam);

      $.ajax({
        type: 'post',
        url:'http://localhost:8080/syno/index.php?c=closing&a=test',
        data: "json="+id,
        success: function(){
          $.growl.notice({ message: "Success" });
        }
      });
    }

    $scope.sent = function() {
      $scope.doParam = {"doId":id,};

      var json = JSON.stringify($scope.doParam);

      $.ajax({
        type: 'post',
        url:'wh_do/updateStatus',
        data: "json="+json,
        success: function(msg){
          var obj = JSON.parse(msg);
          if (obj.status == 'sukses') {
            $.growl.notice({ message: "Pengiriman sedang diproses" });
            $http.get(url_base+'wh_do/statusSent/'+id).success(function (records){
              $scope.status = records[0]['status'];
            });
          }
          else {
            $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
          };   
        },
        error: function() {
          $.growl.error({ message: "Error" });
        } 
      });
    }



      /*
      var json = JSON.stringify($scope.productList);
      var json2 = JSON.stringify($scope.productHeader);
      var json3 = JSON.stringify($scope.barcodeX);

      $.ajax({
        type: 'post',
        url:url_base+'wh_do/saveDeliveryOrder',
        data: "json="+json+"&json2="+json2+"&json3="+json3,
        success: function(msg){
          var obj = JSON.parse(msg);
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              $scope.loading2 = false;
              if (obj.status == 'sukses') {
                $http.get(url_base+"wh_do/getNotif").success(function (records) {
                  $scope.dateDoNotif = records[0]['do_date'];
                  $scope.codeNotif = records[0]['do_code'];
                  $scope.soNotif = records[0]['so_code'];
                  $scope.driverNotif = records[0]['driver_name'];
                  $scope.atNotif = records[0]['at'];
                  $scope.byNotif = records[0]['full_name'];
                  
                  $("#divMain").hide();
                  $("#divNotif").show();
                });
                $.growl.notice({ message: "Data BERHASIL diSimpan" });
              } else {
                $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
              };
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              $scope.loading2 = false;
            }
            $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
          },1000);
        } 
      });*/
  }

]);

app.controller('DoNewController', function($scope,$http, $timeout) {
  $scope.productList = [];
  $scope.barcodeX = [];
  $scope.barcodeY = [];
  $scope.driverName = '';
  $scope.soCode = '';
  $scope.outletCode = '';
  $scope.distinctItem = 0;
  $scope.countTotal = 0;
  $scope.searchCode = '';
  $scope.searchName = '';
  $scope.statusBarcode = true;
  $scope.soId = '';
  $("#masking").hide();
  $("#divList").hide();
  $("#divList2").hide();
  $("#divNotif").hide();
  $("#outletHidden").hide();
  $("#soHidden").hide();
  var pressed = false; 
  var chars = [];

  $http.get(url_base+"po/storageView").success(function (records){
    $scope.storageList = records;
  });

  $http.get(url_base+"wh_do/getInputMethod").success(function (records){
    if (records['input_method'] == 0){
      $("#tableEdit").hide();
      $("#buttonProduct").hide();

      $(window).on("keypress",function(ev) {
        //$("#barcode").focus();
        
        if ((ev.which >= 48 && ev.which <= 57) || (ev.which >= 65 && ev.which <= 90)) {
          chars.push(String.fromCharCode(ev.which));
        }

        if (pressed == false) {
          setTimeout(function(){
            if (chars.length == 12) {
              var barcode = chars.join("");   
              $("#barcode").val(barcode);

              if($("#barcode").val().length == 12){
                var barcode = $("#barcode").val().substring(0,6);

                var is_barcode_exist_local = false;
                var is_barcode_exist_global = false;

                for (var i = 0; i < $scope.barcodeX.length; i++) {
                  if ($scope.barcodeX[i] == $("#barcode").val()){
                    is_barcode_exist_local = true;
                    $.growl.warning({ message: 'Produk sudah di scan di DO ini' });
                  }
                }

                for (var i = 0; i < $scope.barcodeY.length; i++) {
                  if ($scope.barcodeY[i] == $("#barcode").val()){
                    is_barcode_exist_global = true;
                    $.growl.warning({ message: 'Produk sudah di scan di DO sebelumnya' });
                  }
                }

                if (is_barcode_exist_local == false && is_barcode_exist_global == false){
                  $http.get(url_base+"wh_do/getProduct?code="+barcode).success(function (records){
                    $scope.productBarcode = records; 
                    if ($scope.productBarcode.length == 1){
                      var id = $scope.productBarcode[0]['product_id'];
                      var code = $scope.productBarcode[0]['product_code'];
                      var name = $scope.productBarcode[0]['product_name'];
                      var unitL = $scope.productBarcode[0]['unit_large'];
                      var quantity = $scope.productBarcode[0]['quantity'];
                      var quantity2 = $scope.productBarcode[0]['quantity2'];
                      var quantity3 = $scope.productBarcode[0]['quantity3'];

                      if (isExist(code) == false && $scope.statusBarcode == true) {
                        $scope.productList.push({"id":id,"code":code,"name":name,"unitL":unitL,"quantity":quantity,"quantity2":quantity2,"quantity3":quantity3});
                      }
                      else {
                        for (var i = $scope.productList.length - 1; i >= 0; i--) {
                          if ($scope.productList[i].code == code) {
                            var qty = parseFloat($scope.productList[i].quantity) + parseFloat(quantity);

                            $scope.productList[i].quantity = qty;
                          };
                        };
                      };
                      
                      for (var i = $scope.productList.length - 1; i >= 0; i--) {
                        if ($scope.productList[i].code == code) {
                          if (parseFloat($scope.productList[i].quantity) > parseFloat($scope.productList[i].quantity2)) {
                            $scope.productList[i].quantity = $scope.productList[i].quantity2
                            $.growl.warning({ message: 'Jumlah produk sudah melebihi jumlah DO' });
                          }
                          else{
                            $scope.barcodeX[$scope.barcodeX.length] = $("#barcode").val();

                            $scope.codeBarcodeView = $("#barcode").val();
                            $scope.nameBarcodeView = $scope.productList[i].name;
                            $scope.currentQtyBarcodeView = $scope.productList[i].quantity;
                            $scope.leftQtyBarcodeView = $scope.productList[i].quantity2;
                            if ($scope.leftQtyBarcodeView > 0){
                              $scope.separator = '/';
                            }
                            else{
                              $scope.separator = '';
                            }
                          };
                        };
                      };

                      if (isExist(code) == false && $scope.statusBarcode == false) {
                        $.growl.warning({ message: 'Produk tidak ada di list' });
                      }

                      $scope.distinctItem = $scope.productList.length;
                      $scope.countTotal = count();
                    }
                  });
                }
              }
            }
            chars = [];
            pressed = false;
          },500);
        }
        pressed = true;
      });
    }
    else{
      $("#tableNoEdit").hide();
      $("#divBarcode").hide();
    }
  });

  $("#datepickerDo").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#datepickerDo").on('changeDate',function(){
    $(this).datepicker("hide");
  });

  $(window).resize(function(){
    if ($(window).width() < 752){
      $("#divExtend").height(80);
    }
    else{
      $("#divExtend").height(0);
    }
  });

  $(document).on("change","#soSelected",function(){
    var id = $("#soSelected").val();

    if (id != ""){
      $("#outletSelected").hide();
      $("#outletHidden").show();

      $http.get(url_base+"wh_do/getOutletCode/"+id).success(function (records){
        $("#outletHidden").val(records[0]['outlets_code']);
        $("#outletSelected").val(records[0]['outlets_id']);
      });
    }
    else {
      $("#outletSelected").show();
      $("#outletHidden").hide();
      $("#outletHidden").val("");
      $("#outletSelected").val("");
    }
  });

  /*$(document).on("change","#outletSelected",function(){
    if ($("#outletSelected").val() != ""){
      $("#chooseSo").hide();
    }
    else {
      $("#chooseSo").show();
    }
  });*/

  $http.get(url_base+"wh_do/getBarcode").success(function (records){
    $scope.barcodeList = records; 

    for (var i = $scope.barcodeList.length - 1; i >= 0; i--) {
      $scope.barcodeY[$scope.barcodeY.length] = $scope.barcodeList[i].code;
    };
  });

  /*$http.get(url_base+"wh_do/soView").success(function (records){
    $scope.soList = records; 
  });*/

  $http.get(url_base+"wh_do/outletView").success(function (records){
    $scope.outletList = records; 
  });

  $http.get(url_base+"wh_do/driverView").success(function (records){
    $scope.driverList = records; 
  });

  $http.get(url_base+"wh_do/categoryView").success(function (records){
    $scope.categoryList = records; 
  });

  $http.get(url_base+"wh_do/groupView").success(function (records){
    $scope.groupList = records; 
  });

  function isExist(code){
    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      if ($scope.productList[i].code == code) {
        return true;
      };
    };
    return false;
  };

  function count(){
    var count = 0;

    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      count = parseFloat($scope.productList[i]['quantity']) + parseFloat(count);
    };

    return count;
  };

  /*function parsingDate(date) {
    var identify1 = date.substring(2,3);
    var identify2 = date.substring(5,6);
    if (identify1 == '/' && identify2 == '/'){
      if (date == '') {
        return '';
      }
      else {
        var dd = date.substring(3,5);
        var mm = date.substring(0,2);
        var yyyy = date.substring(6,10);
        var parsing = yyyy+"-"+mm+"-"+dd;

        return parsing;
      }
    }
    else{
      return date;
    }
  }*/

  /*$scope.testBarcode = function(ev) {
    if(ev.keyCode == 13 && $scope.barcode.length == 12){
      $scope.barcode = '';
    }
  };*/

  $scope.inputBarcode = function() {
    if($scope.barcode.length == 12){
      var barcode = $scope.barcode.substring(0,6);

      var is_barcode_exist_local = false;
      var is_barcode_exist_global = false;

      for (var i = 0; i < $scope.barcodeX.length; i++) {
        if ($scope.barcodeX[i] == $scope.barcode){
          is_barcode_exist_local = true;
          $.growl.warning({ message: 'Produk sudah di scan di DO ini' });
        }
      }

      for (var i = 0; i < $scope.barcodeY.length; i++) {
        if ($scope.barcodeY[i] == $scope.barcode){
          is_barcode_exist_global = true;
          $.growl.warning({ message: 'Produk sudah di scan di DO sebelumnya' });
        }
      }

      if (is_barcode_exist_local == false && is_barcode_exist_global == false){
        $http.get(url_base+"wh_do/getProduct?code="+barcode).success(function (records){
          $scope.productBarcode = records; 
          if ($scope.productBarcode.length == 1){
            var id = $scope.productBarcode[0]['product_id'];
            var code = $scope.productBarcode[0]['product_code'];
            var name = $scope.productBarcode[0]['product_name'];
            var unitL = $scope.productBarcode[0]['unit_large'];
            var quantity = $scope.productBarcode[0]['quantity'];
            var quantity2 = $scope.productBarcode[0]['quantity2'];
            var quantity3 = $scope.productBarcode[0]['quantity3'];

            if (isExist(code) == false && $scope.statusBarcode == true) {
              $scope.productList.push({"id":id,"code":code,"name":name,"unitL":unitL,"quantity":quantity,"quantity2":quantity2,"quantity3":quantity3});
            }
            else {
              for (var i = $scope.productList.length - 1; i >= 0; i--) {
                if ($scope.productList[i].code == code) {
                  var qty = parseFloat($scope.productList[i].quantity) + parseFloat(quantity);

                  $scope.productList[i].quantity = qty;
                };
              };
            };
            
            for (var i = $scope.productList.length - 1; i >= 0; i--) {
              if ($scope.productList[i].code == code) {
                if (parseFloat($scope.productList[i].quantity) > parseFloat($scope.productList[i].quantity2)) {
                  $scope.productList[i].quantity = $scope.productList[i].quantity2
                  $.growl.warning({ message: 'Jumlah produk sudah melebihi jumlah SO' });
                }
                else{
                  $scope.barcodeX[$scope.barcodeX.length] = $scope.barcode;

                  $scope.codeBarcodeView = $scope.barcode;
                  $scope.nameBarcodeView = $scope.productList[i].name;
                  $scope.currentQtyBarcodeView = $scope.productList[i].quantity;
                  $scope.leftQtyBarcodeView = $scope.productList[i].quantity2;
                  $scope.separator = '/';
                };
              };
            };

            if (isExist(code) == false && $scope.statusBarcode == false) {
              $.growl.warning({ message: 'Produk tidak ada di list' });
            }

            $scope.distinctItem = $scope.productList.length;
            $scope.countTotal = count();
          }
           $scope.barcode = '';
        });
      }
      else{
        $scope.barcode = '';
      }
    }
  };

  $scope.searchProductList = function(code,name) {
    var soId = $scope.soId;
    var category = $("#categorySelected").val();
    var group = $("#groupSelected").val();

    if ($("#soSelected").val() == ""){
      $http.get(url_base+"wh_do/searchProductNullList?code="+code+"&name="+name+"&category="+category+"&group="+group).success(function (records) {
        $scope.products = records;
      });
    }
    else{
      $http.get(url_base+"wh_do/searchProductList?soId="+soId+"&code="+code+"&name="+name+"&category="+category+"&group="+group).success(function (records) {
        $scope.products = records;
      });
    }
  };

  $scope.addProduct = function(id,code,name,unitL,quantity2,quantity3) {
    $scope.productName = name;
    $scope.unitL = unitL;

    $("#masking").css({top:0,left:0,position:"absolute"});
    $("#masking").css({"height": $("#divList2").height()+"px","width": $("#divList2").width()+"px"});
    $("#masking").css("z-index","9999");
    $("#masking").show();

    var x = $(window).scrollTop();
    var y = $("#masking").width();
    var z = $("#divCount").width();
    $("#divCount").css({top:x,left:(y-z)/2,position:"absolute"});

    $("#autofocus").focus();

    $scope.addCount = function(quantity) {
      if ($scope.count > 0) {
        if (isExist(code) == false) {
          if (quantity > quantity2){
            $scope.productList.push({"id":id,"code":code,"name":name,"unitL":unitL,"quantity":quantity2,"quantity2":quantity2,"quantity3":quantity3});
          }
          else{
            $scope.productList.push({"id":id,"code":code,"name":name,"unitL":unitL,"quantity":quantity,"quantity2":quantity2,"quantity3":quantity3});
          }
        }
        else {
          for (var i = $scope.productList.length - 1; i >= 0; i--) {
            if ($scope.productList[i].id == id) {
              var qty = parseFloat($scope.productList[i].quantity) + parseFloat(quantity);

              $scope.productList[i].quantity = qty;

              if (parseFloat($scope.productList[i].quantity) > parseFloat($scope.productList[i].quantity2)) {
                $scope.productList[i].quantity = $scope.productList[i].quantity2;
              }

              var pId = "p"+id;
              $("#"+pId).val($scope.productList[i].quantity);
            };
          };
        };

        /*for (var i = $scope.productList.length - 1; i >= 0; i--) {
          if ($scope.productList[i].id == id) {
            if (parseFloat($scope.productList[i].quantity) > parseFloat($scope.productList[i].quantity2)) {
              $scope.productList[i].quantity = $scope.productList[i].quantity2
              $("#"+pId).val($scope.productList[i].quantity);
            };
          };
        };*/

        $scope.distinctItem = $scope.productList.length;
        $scope.countTotal = count();
        $scope.count = '';
        $("#masking").hide();
      }
      else{
        $.growl.notice({ message: "Jumlah harus diatas 0" });
      };
    };
  };

  $scope.updateCount = function(id){
    var pId = "p"+id;
    var newVal = $("#"+pId).val();

    if (newVal == ''){
      newVal = 0;
    }

    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      if ($scope.productList[i].id == id) {
        $scope.productList[i].quantity = newVal;

        if (parseFloat($scope.productList[i].quantity) > parseFloat($scope.productList[i].quantity2)) {
          $scope.productList[i].quantity = $scope.productList[i].quantity2
        }

        $("#"+pId).val($scope.productList[i].quantity);

        $scope.countTotal = count();
      };
    };
  };

  /*$scope.updateCount = function(id){
    var pId = "p"+id;
    var newVal = $("#"+pId).val();

    if (newVal == ''){
      newVal = 0;
    }

    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      if ($scope.productList[i].id == id) {
        if (parseFloat($scope.productList[i].quantity2) < parseFloat(newVal)){
          newVal = $scope.productList[i].quantity2;
          $("#"+pId).val(newVal);
        }

        $scope.productList[i].quantity = newVal;
       
        $scope.countTotal = count();
      };
    };
  };*/

  $scope.deleteProduct = function(index) {
    for (var i = $scope.barcodeX.length - 1; i >= 0; i--) {
      if ($scope.barcodeX[i].substring(0,6) == $scope.productList[index].code) {
        $scope.barcodeX.splice(i,1);
      }
    };

    $scope.productList.splice(index,1);
    $scope.distinctItem = $scope.productList.length;
    $scope.countTotal = count();
  };

  $scope.saveDeliveryOrder = function(isgen,status) {
    var dateDo = $("#datepickerDo").val();
    var soId = $scope.soId;
    var outletId = $("#outletSelected").val();
    var driverId = $("#driverSelected").val();

    if(soId == "") {
      soId = "null";
    };
    
    if (dateDo === ''){
      $.growl.warning({ message: 'Tanggal DO belum diisi' });
    }
    else if (outletId === ''){
      $.growl.warning({ message: 'Salah satu dari Kode SO atau Kode Outlet harus diisi' });
    }
    else if (driverId === ''){
      $.growl.warning({ message: 'Supir belum diisi' });
    }
    else if ($scope.productList.length == 0){
      $.growl.warning({ message: 'Data produk belum diisi' });
    }
    else {
      if(!isgen){
        if (status == 'save') {
          $scope.loading = true; 
        }
        else {
          $scope.loading2 = true; 
        }
      };

      $scope.productHeader = {"st":$("#storageSelected").val(),"dateDo":dateDo,"soId":soId,"outletId":outletId,"driverId":driverId,"itemCount":$scope.distinctItem,"totalItemQty":$scope.countTotal,"status":status};

      var json = JSON.stringify($scope.productList);
      var json2 = JSON.stringify($scope.productHeader);
      var json3 = JSON.stringify($scope.barcodeX);

      $.ajax({
        type: 'post',
        url:url_base+'wh_do/saveDeliveryOrder',
        data: "json="+json+"&json2="+json2+"&json3="+json3,
        success: function(msg){
          var obj = JSON.parse(msg);
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              $scope.loading2 = false;
              if (obj.status == 'sukses') {
                $http.get(url_base+"wh_do/getNotif").success(function (records) {
                  $scope.dateDoNotif = records[0]['do_date'];
                  $scope.codeNotif = records[0]['do_code'];
                  $scope.soNotif = records[0]['so_code'];
                  $scope.driverNotif = records[0]['driver_name'];
                  $scope.atNotif = records[0]['at'];
                  $scope.byNotif = records[0]['full_name'];
                  
                  $("#divMain").hide();
                  $("#divNotif").show();
                });
                $.growl.notice({ message: "Data BERHASIL diSimpan" });
              } 
              else {
                $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
              };
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              $scope.loading2 = false;
            }
            $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
          },1000);
        } 
      });
    }
  };

  $scope.showDivList = function() {
    $http.get(url_base+"wh_do/soView2").success(function (records){
      $scope.so = records; 
      $scope.currentPage = 1;
      $scope.entryLimit = 100;
      $scope.filteredItems = $scope.so.length;
      $scope.totalItems = $scope.so.length;

      window.scrollTo(0,0);
      $("#divMain").hide();
      $("#divList").css({top:-80,left:0,position:"absolute"});
      $("#divList").css("z-index","9998");
      $("#divList").show(function(){
        $("#divList").css({"height": $(document).height()+"px","width": $(document).width()+"px"});
      
        if ($(window).width() < 752){
          $("#divExtend").height(80);
        }
        else{
          $("#divExtend").height(0);
        }
      });
    });

    $scope.barcodeX = [];
    $scope.codeBarcodeView = '';
    $scope.nameBarcodeView = '';
    $scope.currentQtyBarcodeView = '';
    $scope.leftQtyBarcodeView = '';
    $scope.separator = '';
    $scope.productList = [];
    $scope.distinctItem = 0;
    $scope.countTotal = 0;
    $scope.separator = '/';
    /*if($scope.soCode == ''){
      $http.get(url_base+"wh_do/soDetailNullView").success(function (records){
        $scope.products = records; 
        $scope.currentPage = 1;
        $scope.entryLimit = 100;
        $scope.filteredItems = $scope.products.length;
        $scope.totalItems = $scope.products.length;
      });
    }
    else {
      var soId = $("#soSelected").val();

      $http.get(url_base+"wh_do/soDetailView?soId="+soId).success(function (records){
        $scope.products = records; 
        $scope.currentPage = 1;
        $scope.entryLimit = 100;
        $scope.filteredItems = $scope.products.length;
        $scope.totalItems = $scope.products.length;
      });
    };*/
  };

  $scope.showDivList2 = function() {
    if($scope.soCode == ''){
      $http.get(url_base+"wh_do/productView").success(function (records){
        $scope.products = records; 
        $scope.currentPage = 1;
        $scope.entryLimit = 100;
        $scope.filteredItems = $scope.products.length;
        $scope.totalItems = $scope.products.length;

        window.scrollTo(0,0);
        $("#divMain").hide();
        $("#divList2").css({top:-80,left:0,position:"absolute"});
        $("#divList2").css("z-index","9998");
        $("#divList2").show(function(){
          $("#divList2").css({"height": $(document).height()+"px","width": $(document).width()+"px"});
        
          if ($(window).width() < 752){
            $("#divExtend2").height(80);
          }
          else{
            $("#divExtend2").height(0);
          }
        });
      });
    }
    else {
      var soId = $scope.soId;

      $http.get(url_base+"wh_do/productView2?soId="+soId).success(function (records){
        $scope.products = records; 
        $scope.currentPage = 1;
        $scope.entryLimit = 100;
        $scope.filteredItems = $scope.products.length;
        $scope.totalItems = $scope.products.length;

        window.scrollTo(0,0);
        $("#divMain").hide();
        $("#divList2").css({top:-80,left:0,position:"absolute"});
        $("#divList2").css("z-index","9998");
        $("#divList2").show(function(){
          $("#divList2").css({"height": $(document).height()+"px","width": $(document).width()+"px"});
        
          if ($(window).width() < 752){
            $("#divExtend").height(80);
          }
          else{
            $("#divExtend").height(0);
          }
        });
      });
    };
  };

  $scope.showDivMain = function() {
    $("#divMain").show();
    $("#divList").hide();
    $scope.search = '';
  };

  $scope.showDivMain2 = function() {
    $("#divMain").show();
    $("#divList2").hide();
    $scope.searchCode = '';
    $scope.searchName = '';
    $("#categorySelected").val("");
    $("#groupSelected").val("");
  };

  $scope.backMain = function(outletId,outletCode,soCode,soId) {
    $("#divMain").show();
    $("#divList").hide();
    //$scope.searchCode = '';
    //$scope.searchName = '';

    $scope.soCode = soCode;
    $scope.statusBarcode = false;
    //$("#barcode").focus();

    $scope.soId = soId;
    $("#outletSelected").hide();
    $("#outletHidden").show();

    $("#outletHidden").val(outletCode);
    $("#outletSelected").val(outletId);

    $http.get(url_base+"wh_do/soDetailView?soId="+soId).success(function (records){
      $scope.productList = records; 
      $scope.currentPage = 1;
      $scope.entryLimit = 100;
      $scope.filteredItems = $scope.productList.length;
      $scope.totalItems = $scope.productList.length;
      $scope.distinctItem = $scope.productList.length;
      $scope.countTotal = count();
    });
  };

  $scope.hideDivCount = function() {
    $("#masking").hide();
    $scope.count = '';
  };

  $("#barcode").keypress(function(ev){
    if (ev.which === 13 ) {
      ev.preventDefault();
    }
  });

  $("button").click(function(){
    $(this).blur();
  });
});