app.controller('GroupController', function($scope,$http, $timeout) {
  $(window).off("keypress");
  $("#a").hide();
  //$("#b").hide();
  //$("#c").hide();
  $scope.b = true;
  $scope.c = true;
  
  $http.get(url_base+"wh_group/groupView").success(function (records) {
    $scope.wh_group = records;
    $scope.currentPage = 1;
    $scope.entryLimit = 25;
    $scope.filteredItems = $scope.wh_group.length;
    $scope.totalItems = $scope.wh_group.length;
  });

  $http.get(url_base+"wh_group/getLv").success(function (records) {
    if (records[0]['level'] == 5){
      //$("#c").show();
      $scope.c = false
    }
    else{
      $("#a").show();
      //$("#b").show(); 
      $scope.b = false;   
    }
  });

  $scope.saveDelete = function(id,name) {
    if (confirm("Hapus kelompok "+name+"?")){
      $scope.dataDelete = {"id":id};

      var json = JSON.stringify($scope.dataDelete);

      $.ajax({
        type: 'post',
        url:url_base+'wh_group/saveDelete',
        data: "json="+json,
        success: function(msg){
          var obj = JSON.parse(msg);
            if (obj.status == 'sukses') {
              $.growl.notice({ message: "Data BERHASIL diHapus" });

              $http.get(url_base+"wh_group/groupView").success(function (records) {
                $scope.wh_group = records;
                $scope.currentPage = 1;
                $scope.entryLimit = 25;
                $scope.filteredItems = $scope.wh_group.length;
                $scope.totalItems = $scope.wh_group.length;
              });
            } 
            else if (obj.status == 'gagal'){
              $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
            }
            else{
              $.growl.notice({ message: "Data TIDAK BISA dihapus" });
            };
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
          },1000);
        } 
      });
    }
    return false;
  };

  $scope.setPage = function(pageNo) {
      $scope.currentPage = pageNo;
  };

  $scope.filter = function() {
      $timeout(function() { 
          $scope.filteredItems = $scope.filtered.length;
      }, 25);
  };
});

app.controller('GroupNewController', function($scope,$http, $timeout) {
  $scope.saveNew = function(isgen,status) {
    if ($scope.groupName === ''){
      $.growl.warning({ message: 'Nama tidak boleh kosong' });
    }
    else if($("#groupSelected").val() == ''){
      $.growl.warning({ message: 'Status tidak boleh kosong' });
    }
    else {
      if(!isgen){
        $scope.loading = true; 
      };

      $scope.dataNew = {"name":$scope.groupName,"active":$("#groupSelected").val()};

      var json = JSON.stringify($scope.dataNew);

      $.ajax({
        type: 'post',
        url:url_base+'wh_group/saveNew',
        data: "json="+json,
        success: function(msg){
          var obj = JSON.parse(msg);
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              if (obj.status == 'sukses') {
                $.growl.notice({ message: "Data BERHASIL diSimpan" });
              } else {
                $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
              };
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
            }
            $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
          },1000);
        } 
      });
    }
  };
});

app.controller('GroupEditController',['$scope','$routeParams','$http','$timeout',
  function($scope,$routeParams,$http,$timeout){
    var id = $routeParams.id;

    $http.get(url_base+'wh_group/groupEditView/'+id).success(function (records){
      $scope.groupName = records[0]['group_name'];
      $scope.isActive = records[0]['is_active'];

      $("#groupSelected").val($scope.isActive);
    });

    $scope.saveEdit = function(isgen,status) {
      if ($scope.groupName === ''){
        $.growl.warning({ message: 'Nama tidak boleh kosong' });
      }
      else {
        if(!isgen){
          $scope.loading = true; 
        };

        $scope.dataEdit = {"id":id,"name":$scope.groupName,"active":$("#groupSelected").val()};

        var json = JSON.stringify($scope.dataEdit);

        $.ajax({
          type: 'post',
          url:url_base+'wh_group/saveEdit',
          data: "json="+json,
          success: function(msg){
            var obj = JSON.parse(msg);
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
                if (obj.status == 'sukses') {
                  $.growl.notice({ message: "Data BERHASIL diSimpan" });
                } 
                else {
                  $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
                };
              }
            },1000);
          },
          error: function(XMLHttpRequest, textStatus, errorThrown) {
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
              }
              $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
            },1000);
          } 
        });
      }
    };
  }
]);
