app.controller('MtController', function($scope,$http, $timeout) {
  $(window).off("keypress");
  $http.get(url_base+"wh_mt/mtView").success(function (records) {
    $scope.wh_mt = records;
    $scope.currentPage = 1;
    $scope.entryLimit = 25;
    $scope.filteredItems = $scope.wh_mt.length;
    $scope.totalItems = $scope.wh_mt.length;
  });

  $scope.setPage = function(pageNo) {
      $scope.currentPage = pageNo;
  };

  $scope.filter = function() {
      $timeout(function() { 
          $scope.filteredItems = $scope.filtered.length;
      }, 25);
  };
});

app.controller('MtDetailController',['$scope','$routeParams','$http',
  function($scope,$routeParams,$http){
    var id = $routeParams.id;

    $http.get(url_base+'wh_mt/mtViewDetailHeader/'+id).success(function (records){
      $scope.mtDetailHeader = records;
      $scope.codeMtSelected = $scope.mtDetailHeader[0]['mt_code'];
      $scope.dateMtSelected = $scope.mtDetailHeader[0]['out_date'];
      $scope.codeMoSelected = $scope.mtDetailHeader[0]['mo_code'];
      $scope.atSelected = $scope.mtDetailHeader[0]['createdat']; 
      $scope.bySelected = $scope.mtDetailHeader[0]['full_name'];  
      $scope.distinctItem =  $scope.mtDetailHeader[0]['item_count'];  
      $scope.countTotal =  $scope.mtDetailHeader[0]['total_item_qty'];  
    });

    $http.get(url_base+'wh_mt/mtViewDetail/'+id).success(function (records){
      $scope.mtDetail = records;
    });
  }
]);

app.controller('MtNewController', function($scope,$http, $timeout) {
  $scope.productList = [];
  $scope.moCode = '';
  $scope.moId = '';
  $scope.distinctItem = 0;
  $scope.countTotal = 0;
  $("#divList").hide();
  $("#divNotif").hide();
  var pressed = false; 
  var chars = [];

  $http.get(url_base+"po/storageView").success(function (records){
    $scope.storageList = records;
  });

  $(window).resize(function(){
    if ($(window).width() < 752){
      $("#divExtend").height(80);
    }
    else{
      $("#divExtend").height(0);
    }
  });

  function isExist(code){
    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      if ($scope.productList[i].code == code) {
        return true;
      };
    };
    return false;
  };

  function count(){
    var count = 0;

    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      count = parseFloat($scope.productList[i]['quantity']) + parseFloat(count);
    };

    return count;
  };

  function curDate(){
    var today = new Date();
    var dd = today.getDate();
    var mm = today.getMonth() + 1;
    var yyyy = today.getFullYear();

    if (dd < 10){
      dd = '0'+dd;
    };

    if (mm < 10){
      mm = '0'+mm;
    };  

    today = yyyy+'-'+mm+'-'+dd; 

    return today;
  }

  $scope.dateMt = curDate();

  $scope.updateCount = function(id){
    var pId = "p"+id;
    var newVal = $("#"+pId).val();

    if (newVal == ''){
      newVal = 0;
    }

    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      if ($scope.productList[i].id == id) {
        $scope.productList[i].quantity = newVal;

        if (parseFloat($scope.productList[i].quantity) > parseFloat($scope.productList[i].quantity2)) {
          $scope.productList[i].quantity = $scope.productList[i].quantity2
        }

        $("#"+pId).val($scope.productList[i].quantity);

        $scope.countTotal = count();
      };
    };
  };

  $scope.deleteProduct = function(index) {
    $scope.productList.splice(index,1);
    $scope.distinctItem = $scope.productList.length;
    $scope.countTotal = count();
  };

  $scope.saveMaterialOut = function(isgen,status) {
    var dateMt = $scope.dateMt;
    var moId = $scope.moId;
    
    if (moId === ''){
      $.growl.warning({ message: 'Kode MO belum diisi' });
    }
    else if ($scope.productList.length == 0){
      $.growl.warning({ message: 'Data produk belum diisi' });
    }
    else {
      if(!isgen){
        $scope.loading = true; 
      };

      $scope.productHeader = {"st":$("#storageSelected").val(),"dateMt":dateMt,"moId":moId,"itemCount":$scope.distinctItem,"totalItemQty":$scope.countTotal};

      var json = JSON.stringify($scope.productList);
      var json2 = JSON.stringify($scope.productHeader);

      $.ajax({
        type: 'post',
        url:url_base+'wh_mt/saveMaterialOut',
        data: "json="+json+"&json2="+json2,
        success: function(msg){
          var obj = JSON.parse(msg);
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              if (obj.status == 'sukses') {
                $http.get(url_base+"wh_mt/getNotif").success(function (records) {
                  $scope.codeNotif = records[0]['mt_code'];
                  $scope.moNotif = records[0]['mo_code'];
                  $scope.atNotif = records[0]['at'];
                  $scope.byNotif = records[0]['full_name'];
                  
                  $("#divMain").hide();
                  $("#divNotif").show();
                });
                $.growl.notice({ message: "Data BERHASIL diSimpan" });
              } else {
                $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
              };
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
            }
            $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
          },1000);
        } 
      });
    }
  };

  $scope.showDivList = function() {
    /*if($scope.moCode == ''){
      $.growl.warning({ message: 'Pilih Kode MO terlebih dahulu' });
    }
    else {
      var moId = $("#moSelected").val();*/

      $http.get(url_base+"wh_mt/moView2").success(function (records){
        $scope.mo = records; 
        $scope.currentPage = 1;
        $scope.entryLimit = 100;
        $scope.filteredItems = $scope.mo.length;
        $scope.totalItems = $scope.mo.length;

        window.scrollTo(0,0);
        $("#divMain").hide();
        $("#divList").css({top:-80,left:0,position:"absolute"});
        $("#divList").css("z-index","9998");
        $("#divList").show(function(){
          $("#divList").css({"height": $(document).height()+"px","width": $(document).width()+"px"});
        
          if ($(window).width() < 752){
            $("#divExtend").height(80);
          }
          else{
            $("#divExtend").height(0);
          }
        });
      });

      //$scope.barcodeX = [];
      //$scope.codeBarcodeView = '';
      //$scope.nameBarcodeView = '';
      //$scope.currentQtyBarcodeView = '';
      //$scope.leftQtyBarcodeView = '';
      //$scope.separator = '';
      $scope.productList = [];
      $scope.distinctItem = 0;
      $scope.countTotal = 0;
    //};
  };

  /*$scope.showDivList2 = function() {
    if($scope.moCode == ''){
      $.growl.warning({ message: 'Pilih Kode MO terlebih dahulu' });
    }
    else {
      var moId = $scope.moId;

      $http.get(url_base+"wh_mr/productView2?moId="+moId).success(function (records){
        $scope.products = records; 
        $scope.currentPage = 1;
        $scope.entryLimit = 100;
        $scope.filteredItems = $scope.products.length;
        $scope.totalItems = $scope.products.length;

        window.scrollTo(0,0);
        $("#divMain").hide();
        $("#divList2").css({top:-80,left:0,position:"absolute"});
        $("#divList2").css("z-index","9998");
        $("#divList2").show(function(){
          $("#divList2").css({"height": $(document).height()+"px","width": $(document).width()+"px"});
        
          if ($(window).width() < 752){
            $("#divExtend2").height(80);
          }
          else{
            $("#divExtend2").height(0);
          }
        });
      });
    };
  };*/

  $scope.backMain = function(moId,moCode) {
    $("#divMain").show();
    $("#divList").hide();
    //$scope.searchCode = '';
    //$scope.searchName = '';

    $scope.moId = moId;
    $scope.moCode = moCode;
    $scope.statusBarcode = false;
    //$("#barcode").focus();

    $http.get(url_base+"wh_mt/moDetailView?moId="+moId).success(function (records){
      $scope.productList = records; 
      $scope.currentPage = 1;
      $scope.entryLimit = 100;
      $scope.filteredItems = $scope.productList.length;
      $scope.totalItems = $scope.productList.length;
      $scope.distinctItem = $scope.productList.length;
      $scope.countTotal = count();
    });
  };

  $scope.showDivMain = function() {
    $("#divMain").show();
    $("#divList").hide();
    $scope.search = '';
    //$scope.searchCode = '';
    //$scope.searchName = '';

    /*$(function() {
      $("#categorySelected").val("");
      $("#groupSelected").val("");
    });*/
  };

  /*$scope.showDivMain2 = function() {
    $("#divMain").show();
    $("#divList2").hide();
    $scope.searchCode = '';
    $scope.searchName = '';
    $("#categorySelected").val("");
    $("#groupSelected").val("");
  };*/

  $scope.hideDivCount = function() {
    $("#masking").hide();
    $scope.count = '';
  };

  /*$("#barcode").keypress(function(ev){
    if (ev.which === 13 ) {
      ev.preventDefault();
    }
  });

  $("button").click(function(){
    $(this).blur();
  });*/
});