app.controller('ProductController', function($scope,$http, $timeout) {
  $(window).off("keypress");
  $("#a").hide();
  //$("#b").hide();
  //$("#c").hide();
  $scope.b = true;
  $scope.c = true;

  $http.get(url_base+"wh_product/productView").success(function (records) {
    $scope.wh_product = records;
    $scope.currentPage = 1;
    $scope.entryLimit = 25;
    $scope.filteredItems = $scope.wh_product.length;
    $scope.totalItems = $scope.wh_product.length;
  });

  $http.get(url_base+"wh_product/getLv").success(function (records) {
    if (records[0]['level'] == 5){
      //$("#c").show();
      $scope.c = false
    }
    else{
      $("#a").show();
      //$("#b").show(); 
      $scope.b = false;   
    }
  });

  $scope.saveDelete = function(id,name) {
    if (confirm("Hapus produk "+name+"?")){
      $scope.dataDelete = {"id":id};

      var json = JSON.stringify($scope.dataDelete);

      $.ajax({
        type: 'post',
        url:url_base+'wh_product/saveDelete',
        data: "json="+json,
        success: function(msg){
          var obj = JSON.parse(msg);
            if (obj.status == 'sukses') {
              $.growl.notice({ message: "Data BERHASIL diHapus" });

              $http.get(url_base+"wh_product/productView").success(function (records) {
                $scope.wh_product = records;
                $scope.currentPage = 1;
                $scope.entryLimit = 25;
                $scope.filteredItems = $scope.wh_product.length;
                $scope.totalItems = $scope.wh_product.length;
              });
            } 
            else if (obj.status == 'gagal'){
              $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
            }
            else{
              $.growl.notice({ message: "Data TIDAK BISA dihapus" });
            };
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
          },1000);
        } 
      });
    }
    return false;
  };

  $scope.setPage = function(pageNo) {
      $scope.currentPage = pageNo;
  };

  $scope.filter = function() {
      $timeout(function() { 
          $scope.filteredItems = $scope.filtered.length;
      }, 25);
  };
});

app.controller('ProductNewController', function($scope,$http, $timeout) {
  $scope.code = '';
  $scope.name = '';
  $scope.price1 = '';
  $scope.price2 = '';
  $scope.unitL = '';
  $scope.unitS = '';
  $scope.conv = '';
  $scope.exp = '';
  $scope.barcode = '';
  $scope.mlt = '';
  $("#divList").hide();
  $("#masking").hide();
  $scope.sp = [];
  $scope.hide = true;

  $http.get(url_base+"wh_product/stView").success(function (records){
    $scope.stList = records; 
  });

  $http.get(url_base+"wh_product/categoryView").success(function (records){
    $scope.categoryList = records; 
  });

  $http.get(url_base+"wh_product/groupView").success(function (records){
    $scope.groupList = records; 
  });

  $scope.setPage = function(pageNo) {
    $scope.currentPage = pageNo;
  };

  $scope.filter = function() {
      $timeout(function() { 
          $scope.filteredItems = $scope.filtered.length;
      }, 25);
  };

  $scope.showDivList = function() {
    $http.get(url_base+'wh_product/supplierView').success(function (records){
      $scope.suppliers = records;
      $scope.currentPage = 1;
      $scope.entryLimit = 100;
      $scope.filteredItems = $scope.suppliers.length;
      $scope.totalItems = $scope.suppliers.length;

      window.scrollTo(0,0);
      $("#divMain").hide();
      $("#divList").css({top:-80,left:0,position:"absolute"});
      $("#divList").css("z-index","9998");
      $("#divList").show(function(){
        $("#divList").css({"height": $(document).height()+"px","width": $(document).width()+"px"});
      
        if ($(window).width() < 752){
          $("#divExtend").height(80);
        }
        else{
          $("#divExtend").height(0);
        }
      });
    });
  };

  $scope.showDivMain = function() {
    $("#divMain").show();
    $("#divList").hide();
    $scope.search = '';
  };

  $scope.hideDivCount = function() {
    $("#masking").hide();
    $scope.sku = '';
    $scope.snp = '' ;       
    $scope.price = '';
  };

  function isExist(code){
    for (var i = $scope.sp.length - 1; i >= 0; i--) {
      if ($scope.sp[i].code == code) {
        return true;
      };
    };
    return false;
  };

  $scope.addSupplier = function(id,code,name) {
    $scope.supplierName = name;

    $("#masking").css({top:0,left:0,position:"absolute"});
    $("#masking").css({"height": $("#divList").height()+"px","width": $("#divList").width()+"px"});
    $("#masking").css("z-index","9999");
    $("#masking").show();

    var x = $(window).scrollTop();
    var y = $("#masking").width();
    var z = $("#divCount").width();
    $("#divCount").css({top:x,left:(y-z)/2,position:"absolute"});

    $("#autofocus").focus();

    $scope.addRow = function(sku,snp,price) {
      if (isExist(code) == false) {
        $scope.sp.push({"id":id,"code":code,"name":name,"sku":sku,"snp":snp,"price":price,"prodId":$scope.newId});
      }
      else {
        for (var i = $scope.sp.length - 1; i >= 0; i--) {
          if ($scope.sp[i].id == id) {
            $scope.sp[i].sku = sku;
            $scope.sp[i].snp = snp;
            $scope.sp[i].price = price;
          };
        };
      };

      $scope.sku = '';
      $scope.snp = '' ;       
      $scope.price = '';
      $("#masking").hide();
    };
  };

  $scope.deleteProduct = function(index) {
    $scope.sp.splice(index,1);
  };

  $scope.updateSku = function(id){
    var pId = "p"+id;
    var newVal = $("#"+pId).val();

    for (var i = $scope.sp.length - 1; i >= 0; i--) {
      if ($scope.sp[i].id == id) {
        $scope.sp[i].sku = newVal;

        $("#"+pId).val(newVal);
      };
    };
  };

  $scope.updateSnp = function(id){
    var pId = "p2"+id;
    var newVal = $("#"+pId).val();

    for (var i = $scope.sp.length - 1; i >= 0; i--) {
      if ($scope.sp[i].id == id) {
        $scope.sp[i].snp = newVal;

        $("#"+pId).val(newVal);
      };
    };
  };

  $scope.updatePrice = function(id){
    var pId = "p3"+id;
    var newVal = $("#"+pId).val();

    for (var i = $scope.sp.length - 1; i >= 0; i--) {
      if ($scope.sp[i].id == id) {
        $scope.sp[i].price = newVal;

        $("#"+pId).val(newVal);
      };
    };
  };

  $scope.saveSupplierProduct = function(isgen,status) {
    if(!isgen){
      $scope.loading = true; 
    };

    var json = JSON.stringify($scope.sp);

    $.ajax({
      type: 'post',
      url:url_base+'wh_product/saveSupplierProduct',
      data: "json="+json,
      success: function(msg){
        var obj = JSON.parse(msg);
        $timeout(function(){
          if(!isgen){
            $scope.loading = false;
            if (obj.status == 'sukses') {
              $.growl.notice({ message: "Data BERHASIL diSimpan" });
            } else {
              $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
            };
          }
        },1000);
      },
      error: function(XMLHttpRequest, textStatus, errorThrown) {
        $timeout(function(){
          if(!isgen){
            $scope.loading = false;
          }
          $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
        },1000);
      } 
    });
  };

  $scope.saveNew = function(isgen,status) {
    //var x = $('input[name="chk"]:checked');
    
    //x.each(function(){
    //  alert("Aaa");
    //})

    var counter = 0;
    var st = [];

    $http.get(url_base+"wh_product/stView").success(function (records){
      for (var i = 0; i < records.length; i++){
        //alert($("#x"+records[i]['id']).is(":checked"));
        if ($("#x"+records[i]['id']).is(":checked") == true){
          st[counter] = records[i]['id'];
          counter = counter + 1;
        };
      }

      if($("#categorySelected").val() == ''){
        $.growl.warning({ message: 'Kategori tidak boleh kosong' });
      }
      else if($("#groupSelected").val() == ''){
        $.growl.warning({ message: 'Group tidak boleh kosong' });
      }
      else if($("#b").val() == ''){
        $.growl.warning({ message: 'Kode tidak boleh kosong' });
      }
      else if($("#c").val() == ''){
        $.growl.warning({ message: 'Nama tidak boleh kosong' });
      }
      else if($("#d").val() == ''){
        $.growl.warning({ message: 'Harga Pokok tidak boleh kosong' });
      }
      else if($("#e").val() == ''){
        $.growl.warning({ message: 'Harga Ganti tidak boleh kosong' });
      }
      else if($("#g").val() == ''){
        $.growl.warning({ message: 'Satuan Kecil tidak boleh kosong' });
      }
      else if($("#f").val() == ''){
        $.growl.warning({ message: 'Satuan Besar tidak boleh kosong' });
      }
      else if($("#h").val() == ''){
        $.growl.warning({ message: 'Konversi tidak boleh kosong' });
      }
      else if($("#isSent").val() == ''){
        $.growl.warning({ message: 'Kirim Outlet tidak boleh kosong' });
      }
      else if($("#supplyMethod").val() == ''){
        $.growl.warning({ message: 'Metode Supply tidak boleh kosong' });
      }
      else if($("#j").val() == ''){
        $.growl.warning({ message: 'Lama Kadaluarsa tidak boleh kosong' });
      }
      else {
        if(!isgen){
          $scope.loading = true; 
        };

        if ($scope.mlt == ''){
          $scope.mlt = 0;
        }

        $scope.dataNew = {"st":st,"category":$("#categorySelected").val(),"group":$("#groupSelected").val(),"code":$("#b").val(),"name":$("#c").val(),"barcode":$("#a").val(),"price1":$("#d").val(),"price2":$("#e").val(),"isActive":$("#isActive").val(),"unitS":$("#g").val(),"unitL":$("#f").val(),"conv":$("#h").val(),"isSent":$("#isSent").val(),"supplyMethod":$("#supplyMethod").val(),"mlt":$scope.mlt,"exp":$("#j").val()};

        var json = JSON.stringify($scope.dataNew);

        $.ajax({
          type: 'post',
          url:url_base+'wh_product/saveNew',
          data: "json="+json,
          success: function(msg){
            var obj = JSON.parse(msg);
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
                if (obj.status == 'sukses') {
                  $.growl.notice({ message: "Data BERHASIL diSimpan" });
                  $scope.newId = obj.prodId;
                  $scope.hide = false;
                } 
                else if(obj.status == 'duplikat') {
                  $.growl.error({ message: "Kode Produk sudah ada. Ganti Kode Produk !" });
                }
                else {
                  $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
                };
              }
            },1000);
          },
          error: function(XMLHttpRequest, textStatus, errorThrown) {
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
              }
              $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
            },1000);
          } 
        });
      }
    });
  };
});

app.controller('ProductEditController',['$scope','$routeParams','$http','$timeout',
  function($scope,$routeParams,$http,$timeout){
    var id = $routeParams.id;
    $("#divList").hide();
    $("#masking").hide();
    $scope.sp = [];

    $http.get(url_base+"wh_product/stView").success(function (records){
      $scope.stList = records; 
    });

    $http.get(url_base+"wh_product/categoryView").success(function (records){
      $scope.categoryList = records; 

      $http.get(url_base+"wh_product/groupView").success(function (records){
        $scope.groupList = records; 

        $http.get(url_base+'wh_product/productEditView/'+id).success(function (records){
          $scope.categorySelected = records[0]['category_id'];
          $scope.groupSelected = records[0]['group_id'];
          $scope.isActive = records[0]['is_active'];
          $scope.isSent = records[0]['is_sent_to_outlet'];
          $scope.supplyMethod = records[0]['supply_method'];
          $scope.barcode = records[0]['barcode'];
          $scope.code = records[0]['product_code'];
          $scope.name = records[0]['product_name'];
          $scope.price1 = records[0]['price'];
          $scope.price2 = records[0]['price_change'];
          $scope.unitS = records[0]['unit_small'];
          $scope.unitL = records[0]['unit_large'];
          $scope.conv = records[0]['conversion'];
          $scope.mlt = records[0]['manufacturing_lead_time'];
          $scope.exp = records[0]['expire_days'];
        });

        $http.get(url_base+'wh_product/productStorageView/'+id).success(function (records){
          for (var i = 0; i < records.length; i++){
           // alert(records[i]['storage_id']);
            $("#x"+records[i]['storage_id']).prop({checked:true});
            //alert($("#x"+records[i]['id']).is(":checked"));
            
            // if ($("#x"+records[i]['id']).is(":checked") == true){
            //   st[counter] = records[i]['id'];
            //   counter = counter + 1;
            //};
          }
        });
      });
    });

    $http.get(url_base+'wh_product/initSupplierProduct/'+id).success(function (records){
      $scope.sp = records;
    });

    $scope.setPage = function(pageNo) {
      $scope.currentPage = pageNo;
    };

    $scope.filter = function() {
        $timeout(function() { 
            $scope.filteredItems = $scope.filtered.length;
        }, 25);
    };

    $scope.showDivList = function() {
      $http.get(url_base+'wh_product/supplierView').success(function (records){
        $scope.suppliers = records;
        $scope.currentPage = 1;
        $scope.entryLimit = 100;
        $scope.filteredItems = $scope.suppliers.length;
        $scope.totalItems = $scope.suppliers.length;

        window.scrollTo(0,0);
        $("#divMain").hide();
        $("#divList").css({top:-80,left:0,position:"absolute"});
        $("#divList").css("z-index","9998");
        $("#divList").show(function(){
          $("#divList").css({"height": $(document).height()+"px","width": $(document).width()+"px"});
        
          if ($(window).width() < 752){
            $("#divExtend").height(80);
          }
          else{
            $("#divExtend").height(0);
          }
        });
      });
    };

    $scope.showDivMain = function() {
      $("#divMain").show();
      $("#divList").hide();
      $scope.search = '';
    };

    $scope.hideDivCount = function() {
      $("#masking").hide();
      $scope.sku = '';
      $scope.snp = '' ;       
      $scope.price = '';
    };

    function isExist(code){
      for (var i = $scope.sp.length - 1; i >= 0; i--) {
        if ($scope.sp[i].code == code) {
          return true;
        };
      };
      return false;
    };

    $scope.addSupplier = function(id,code,name) {
      $scope.supplierName = name;

      $("#masking").css({top:0,left:0,position:"absolute"});
      $("#masking").css({"height": $("#divList").height()+"px","width": $("#divList").width()+"px"});
      $("#masking").css("z-index","9999");
      $("#masking").show();

      var x = $(window).scrollTop();
      var y = $("#masking").width();
      var z = $("#divCount").width();
      $("#divCount").css({top:x,left:(y-z)/2,position:"absolute"});

      $("#autofocus").focus();

      $scope.addRow = function(sku,snp,price) {
        if (isExist(code) == false) {
          $scope.sp.push({"id":id,"code":code,"name":name,"sku":sku,"snp":snp,"price":price,"prodId":$routeParams.id});
        }
        else {
          for (var i = $scope.sp.length - 1; i >= 0; i--) {
            if ($scope.sp[i].id == id) {
              $scope.sp[i].sku = sku;
              $scope.sp[i].snp = snp;
              $scope.sp[i].price = price;
            };
          };
        };

        $scope.sku = '';
        $scope.snp = '' ;       
        $scope.price = '';
        $("#masking").hide();
      };
    };

    $scope.deleteProduct = function(index) {
      $scope.sp.splice(index,1);
    };

    $scope.updateSku = function(id){
      var pId = "p"+id;
      var newVal = $("#"+pId).val();

      for (var i = $scope.sp.length - 1; i >= 0; i--) {
        if ($scope.sp[i].id == id) {
          $scope.sp[i].sku = newVal;

          $("#"+pId).val(newVal);
        };
      };
    };

    $scope.updateSnp = function(id){
      var pId = "p2"+id;
      var newVal = $("#"+pId).val();

      for (var i = $scope.sp.length - 1; i >= 0; i--) {
        if ($scope.sp[i].id == id) {
          $scope.sp[i].snp = newVal;

          $("#"+pId).val(newVal);
        };
      };
    };

    $scope.updatePrice = function(id){
      var pId = "p3"+id;
      var newVal = $("#"+pId).val();

      for (var i = $scope.sp.length - 1; i >= 0; i--) {
        if ($scope.sp[i].id == id) {
          $scope.sp[i].price = newVal;

          $("#"+pId).val(newVal);
        };
      };
    };

    $scope.saveSupplierProduct = function(isgen,status) {
      if(!isgen){
        $scope.loading = true; 
      };

      var json = JSON.stringify($scope.sp);

      $.ajax({
        type: 'post',
        url:url_base+'wh_product/saveSupplierProduct',
        data: "json="+json,
        success: function(msg){
          var obj = JSON.parse(msg);
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              if (obj.status == 'sukses') {
                $.growl.notice({ message: "Data BERHASIL diSimpan" });
              } else {
                $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
              };
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
            }
            $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
          },1000);
        } 
      });
    };

    $scope.saveEdit = function(isgen,status) {
      var counter = 0;
      var st = [];

      $http.get(url_base+"wh_product/stView").success(function (records){
      for (var i = 0; i < records.length; i++){
        if ($("#x"+records[i]['id']).is(":checked") == true){
          st[counter] = records[i]['id'];
          counter = counter + 1;
        };
      }

      if($("#categorySelected").val() == ''){
        $.growl.warning({ message: 'Kategori tidak boleh kosong' });
      }
      else if($("#groupSelected").val() == ''){
        $.growl.warning({ message: 'Group tidak boleh kosong' });
      }
      else if($("#b").val() == ''){
        $.growl.warning({ message: 'Kode tidak boleh kosong' });
      }
      else if($("#c").val() == ''){
        $.growl.warning({ message: 'Nama tidak boleh kosong' });
      }
      else if($("#d").val() == ''){
        $.growl.warning({ message: 'Harga Pokok tidak boleh kosong' });
      }
      else if($("#e").val() == ''){
        $.growl.warning({ message: 'Harga Ganti tidak boleh kosong' });
      }
      else if($("#g").val() == ''){
        $.growl.warning({ message: 'Satuan Kecil tidak boleh kosong' });
      }
      else if($("#f").val() == ''){
        $.growl.warning({ message: 'Satuan Besar tidak boleh kosong' });
      }
      else if($("#h").val() == ''){
        $.growl.warning({ message: 'Konversi tidak boleh kosong' });
      }
      else if($("#isSent").val() == ''){
        $.growl.warning({ message: 'Kirim Outlet tidak boleh kosong' });
      }
      else if($("#supplyMethod").val() == ''){
        $.growl.warning({ message: 'Metode Supply tidak boleh kosong' });
      }
      else if($("#j").val() == ''){
        $.growl.warning({ message: 'Lama Kadaluarsa tidak boleh kosong' });
      }
      else {
        if(!isgen){
          $scope.loading = true; 
        };

        if ($scope.mlt == ''){
          $scope.mlt = 0;
        }

        $scope.dataNew = {"id":id,"st":st,"category":$("#categorySelected").val(),"group":$("#groupSelected").val(),"code":$("#b").val(),"name":$("#c").val(),"barcode":$("#a").val(),"price1":$("#d").val(),"price2":$("#e").val(),"isActive":$("#isActive").val(),"unitS":$("#g").val(),"unitL":$("#f").val(),"conv":$("#h").val(),"isSent":$("#isSent").val(),"supplyMethod":$("#supplyMethod").val(),"mlt":$scope.mlt,"exp":$("#j").val()};

        var json = JSON.stringify($scope.dataNew);

        $.ajax({
          type: 'post',
          url:url_base+'wh_product/saveEdit',
          data: "json="+json,
          success: function(msg){
            var obj = JSON.parse(msg);
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
                if (obj.status == 'sukses') {
                  $.growl.notice({ message: "Data BERHASIL diSimpan" });
                } 
                else if(obj.status == 'duplikat') {
                  $.growl.error({ message: "Kode Produk sudah ada. Ganti Kode Produk !" });
                }
                else {
                  $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
                };
              }
            },1000);
          },
          error: function(XMLHttpRequest, textStatus, errorThrown) {
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
              }
              $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
            },1000);
          } 
        });
      }
    });

    };
  }
]);