app.controller('ProjectionController', function($scope,$http, $timeout) {
  $(window).off("keypress");
  //$("#a").hide();
  //$("#b").hide();
  //$("#c").hide();
  //$scope.b = true;
  //$scope.c = true;
  $scope.status = false;

  $("#datepickerPj").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#datepickerPj").on('changeDate',function(){
    $(this).datepicker("hide");
    $scope.status = true;
  });
  
  $http.get(url_base+"wh_projection/projectionView").success(function (records) {
    $scope.wh_projection = records;
    $scope.currentPage = 1;
    $scope.entryLimit = 25;
    $scope.filteredItems = $scope.wh_projection.length;
    $scope.totalItems = $scope.wh_projection.length;
  });

  //$http.get(url_base+"wh_projection/getLv").success(function (records) {
    //if (records[0]['level'] == 5){
      //$("#c").show();
      //$scope.c = false
    //}
    //else{
      //$("#a").show();
      //$("#b").show(); 
      //$scope.b = false;   
    //}
  //});

  $scope.saveDelete = function(id,code) {
    if (confirm("Hapus proyeksi "+code+"?")){
      $scope.dataDelete = {"id":id};

      var json = JSON.stringify($scope.dataDelete);

      $.ajax({
        type: 'post',
        url:url_base+'wh_projection/saveDelete',
        data: "json="+json,
        success: function(msg){
          var obj = JSON.parse(msg);
            if (obj.status == 'sukses') {
              $.growl.notice({ message: "Data BERHASIL diHapus" });

              $http.get(url_base+"wh_projection/projectionView").success(function (records) {
                $scope.wh_projection = records;
                $scope.currentPage = 1;
                $scope.entryLimit = 25;
                $scope.filteredItems = $scope.wh_projection.length;
                $scope.totalItems = $scope.wh_projection.length;
              });
            } 
            else if (obj.status == 'gagal'){
              $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
            }
            else{
              $.growl.notice({ message: "Data TIDAK BISA dihapus" });
            };
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
          },1000);
        } 
      });
    }
    return false;
  };

  $scope.setPage = function(pageNo) {
      $scope.currentPage = pageNo;
  };

  $scope.filter = function() {
      $timeout(function() { 
          $scope.filteredItems = $scope.filtered.length;
      }, 25);
  };

  $scope.exportExcel = function(){
    var x = $('input[name=x]:checked').val();

    if ($scope.status == false){
      $.growl.notice({ message: "Isi tanggal Export terlebih dahulu" });
    }
    else if(x != 0 && x != 1){
      $.growl.notice({ message: "Isi jenis data yang akan di export" });
    }
    else{
      $http({
        url: url_base+"wh_projection/export",
        method: 'POST',
        dataType: 'json',
        data: {'date':$('#datepickerPj').val(),'type':x},
      })
      .success(function (data, status, headers, config){
        window.open(data);
      })
      .error(function(data, status, headers, config){
        $.growl.error({ message: "Export GAGAL. <br/>Cek koneksi internet dan ulangi Lagi !" });
      })
    }
  }
});

app.controller('ProjectionNewController', function($scope,$http, $timeout) {
  $scope.status = false;

  $("#datepicker").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#datepicker").on('changeDate',function(){
    $(this).datepicker("hide");
  });

  $http.get(url_base+"wh_projection/sectionView").success(function (records) {
    $scope.sectionList = records;
    $scope.currentPage = 1;
    $scope.entryLimit = 25;
    $scope.filteredItems = $scope.sectionList.length;
    $scope.totalItems = $scope.sectionList.length;
  });

  $scope.updateProjection = function(id) {
    var pId = "p"+id;
    var p2Id = "p2"+id;
    var newVal = $("#"+pId).val();

    $http({
      url: url_base+"wh_projection/ceilProduct",
      method: 'POST',
      dataType: 'json',
      data: {"id":id},
    })
    .success(function (records){
      var ceil = records[0]['x'];

      newVal = Math.ceil(newVal / ceil) * ceil;

      for (var i = $scope.pjDetail.length - 1; i >= 0; i--) {
        if ($scope.pjDetail[i].product_id == id) {
          $scope.pjDetail[i].y = newVal;
          $("#"+p2Id).val(newVal);
        };
      };
    })
    .error(function(data, status, headers, config){
      $.growl.error({ message: "Export GAGAL. <br/>Cek koneksi internet dan ulangi Lagi !" });
      })
  };

  $scope.generateProjection = function() {
    if($("#sectionSelected").val() == ''){
      $.growl.warning({ message: 'Seksi tidak boleh kosong' });
    }
    else{
      $http({
        url: url_base+"wh_projection/generateProjection",
        method: 'POST',
        dataType: 'json',
        data: {"section":$("#sectionSelected").val()},
      })
      .success(function (records){
        $scope.pjDetail = records;
        $scope.status = true;
      })
      .error(function(data, status, headers, config){
        $.growl.error({ message: "Export GAGAL. <br/>Cek koneksi internet dan ulangi Lagi !" });
      })
    }
  };

  $scope.saveProjection = function(isgen) {
    if($("#datepicker").val() == '' || $("#sectionSelected").val() == ''){
      $.growl.warning({ message: 'Proyeksi Untuk dan Seksi tidak boleh kosong' });
    }
    else if($scope.status == false) {
      $.growl.warning({ message: 'Generate Proyeksi terlebih dahulu' });
    }
    else{
       if(!isgen){
          $scope.loading = true; 
        }

      var json = JSON.stringify($scope.pjDetail);
      var json2 = JSON.stringify({"section":$("#sectionSelected").val(),"date":$("#datepicker").val()});

      $.ajax({
        type: 'post',
        url:url_base+'wh_projection/saveProjection',
        data: "json="+json+"&json2="+json2,
        success: function(msg){
          var obj = JSON.parse(msg);
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              if (obj.status == 'sukses') {
                $.growl.notice({ message: "Data BERHASIL diSimpan" });
              } 
              else {
                $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
              };
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
            }
            $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
          },1000);
        } 
      });
    }

    
    /*if ($scope.sectionName === ''){
      $.growl.warning({ message: 'Nama tidak boleh kosong' });
    }
    else if($scope.sectionCode === ''){
      $.growl.warning({ message: 'Kode tidak boleh kosong' });
    }
    else if($scope.sectionCode.length != 3){
      $.growl.warning({ message: 'Kode Seksi harus 3 karakter' });
    }
    else if($("#sectionSelected").val() == ''){
      $.growl.warning({ message: 'Status tidak boleh kosong' });
    }
    else {
      if(!isgen){
        $scope.loading = true; 
      };

      $scope.dataNew = {"name":$scope.sectionName,"code":$scope.sectionCode,"active":$("#sectionSelected").val()};

      var json = JSON.stringify($scope.dataNew);

      $.ajax({
        type: 'post',
        url:url_base+'wh_section/saveNew',
        data: "json="+json,
        success: function(msg){
          var obj = JSON.parse(msg);
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              if (obj.status == 'sukses') {
                $.growl.notice({ message: "Data BERHASIL diSimpan" });
              } 
              else if (obj.status == 'duplikat') {
                $.growl.notice({ message: "Kode sudah ada. Ganti Kode Seksi" });
              }
              else {
                $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
              };
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
            }
            $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
          },1000);
        } 
      });
    }*/
  };
});

app.controller('ProjectionDetailController',['$scope','$routeParams','$http',
  function($scope,$routeParams,$http){
    var id = $routeParams.id;

    $scope.projectionId = id;

    $http.get(url_base+'wh_projection/pjViewDetailHeader/'+id).success(function (records){
      $scope.codeSelected = records[0]['code'];
      $scope.dateSelected = records[0]['date'];
      $scope.sectionSelected = records[0]['section_name'];
    });

    $http.get(url_base+'wh_projection/pjViewDetail/'+id).success(function (records){
      $scope.pjDetail = records;
    });
  }

  

]);

app.controller('ProjectionBreakDownController',['$scope','$routeParams','$http','$timeout',
  function($scope,$routeParams,$http,$timeout){
    var id = $routeParams.id;

    $http.get(url_base+'wh_projection/pjViewDetailHeader/'+id).success(function (records){
      $scope.codeSelected = records[0]['code'];
      $scope.dateSelected = records[0]['date'];
      $scope.sectionSelected = records[0]['section_name'];
      $scope.sectionId =  records[0]['section_id'];
    });

    $http.get(url_base+'wh_projection/pjViewDetail/'+id).success(function (records){
      $scope.pjDetail = records;
    });

    $http.get(url_base+'wh_projection/ProjectionBreakDown/'+id).success(function (records){
      $scope.bdDetail = records;
    });

    $scope.exportExcel = function(){
      $http({
        url: url_base+"wh_projection/exportDetail",
        method: 'POST',
        dataType: 'json',
        data: {'id':$routeParams.id},
      })
      .success(function (data, status, headers, config){
        window.open(data);
      })
      .error(function(data, status, headers, config){
        $.growl.error({ message: "Export GAGAL. <br/>Cek koneksi internet dan ulangi Lagi !" });
      })
    }

    $scope.importMo = function(isgen){      
      if(!isgen){
        $scope.loading = true; 
      }

      var json = JSON.stringify($scope.bdDetail);
      var json2 = JSON.stringify({"sectionId":$scope.sectionId,"dateSchedulle":$scope.dateSelected,"distinctCount":$scope.bdDetail.length});
      var json3 = JSON.stringify($scope.pjDetail);

      $.ajax({
        type: 'post',
        url:url_base+'wh_projection/import',
        data: "json="+json+"&json2="+json2+"&json3="+json3,
        success: function(msg){
          var obj = JSON.parse(msg);
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              if (obj.status == 'sukses') {
                $.growl.notice({ message: "Data BERHASIL diSimpan" });
              } 
              else {
                $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
              };
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
            }
            $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
          },1000);
        } 
      });
            
    }
  }
]);


app.controller('ProjectionEditController',['$scope','$routeParams','$http','$timeout',
  function($scope,$routeParams,$http,$timeout){
    var id = $routeParams.id;

    $("#datepicker").datepicker({
      format:"yyyy-mm-dd"
    });

    $("#datepicker").on('changeDate',function(){
        $(this).datepicker("hide");
      });

    $http.get(url_base+'wh_projection/pjViewDetailHeader/'+id).success(function (records){
      $scope.codeSelected = records[0]['code'];
      $scope.periodFor = records[0]['date'];
      $scope.sectionSelected = records[0]['section_name'];
    });

    $http.get(url_base+'wh_projection/pjViewDetail/'+id).success(function (records){
      $scope.pjDetail = records;
    });

    $scope.updateProjection = function(id) {
      var pId = "p"+id;
      var p2Id = "p2"+id;
      var newVal = $("#"+pId).val();

      $http({
        url: url_base+"wh_projection/ceilProduct",
        method: 'POST',
        dataType: 'json',
        data: {"id":id},
      })
      .success(function (records){
        var ceil = records[0]['x'];

        newVal = Math.ceil(newVal / ceil) * ceil;

        for (var i = $scope.pjDetail.length - 1; i >= 0; i--) {
          if ($scope.pjDetail[i].product_id == id) {
            $scope.pjDetail[i].projection_qty = newVal;
            $("#"+p2Id).val(newVal);
          };
        };
      })
      .error(function(data, status, headers, config){
        $.growl.error({ message: "Export GAGAL. <br/>Cek koneksi internet dan ulangi Lagi !" });
      })
    };

    $scope.saveEdit = function(isgen) {
      if($("#datepicker").val() == ''){
        $.growl.warning({ message: 'Proyeksi Untuk dan Seksi tidak boleh kosong' });
      }
      else{
         if(!isgen){
            $scope.loading = true; 
          }

        var json = JSON.stringify($scope.pjDetail);
        var json2 = JSON.stringify({"id":id,"date":$("#datepicker").val()});

        $.ajax({
          type: 'post',
          url:url_base+'wh_projection/saveEdit',
          data: "json="+json+"&json2="+json2,
          success: function(msg){
            var obj = JSON.parse(msg);
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
                if (obj.status == 'sukses') {
                  $.growl.notice({ message: "Data BERHASIL diSimpan" });
                } 
                else {
                  $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
                };
              }
            },1000);
          },
          error: function(XMLHttpRequest, textStatus, errorThrown) {
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
              }
              $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
            },1000);
          } 
        });
      }
    };
  }
]);