app.controller('SectionController', function($scope,$http, $timeout) {
  $(window).off("keypress");
  $("#a").hide();
  //$("#b").hide();
  //$("#c").hide();
  $scope.b = true;
  $scope.c = true;
  
  $http.get(url_base+"wh_section/sectionView").success(function (records) {
    $scope.wh_section = records;
    $scope.currentPage = 1;
    $scope.entryLimit = 25;
    $scope.filteredItems = $scope.wh_section.length;
    $scope.totalItems = $scope.wh_section.length;
  });

  $http.get(url_base+"wh_section/getLv").success(function (records) {
    if (records[0]['level'] == 5){
      //$("#c").show();
      $scope.c = false
    }
    else{
      $("#a").show();
      //$("#b").show(); 
      $scope.b = false;   
    }
  });

  $scope.saveDelete = function(id,name) {
    if (confirm("Hapus kategori "+name+"?")){
      $scope.dataDelete = {"id":id};

      var json = JSON.stringify($scope.dataDelete);

      $.ajax({
        type: 'post',
        url:url_base+'wh_section/saveDelete',
        data: "json="+json,
        success: function(msg){
          var obj = JSON.parse(msg);
            if (obj.status == 'sukses') {
              $.growl.notice({ message: "Data BERHASIL diHapus" });

              $http.get(url_base+"wh_section/sectionView").success(function (records) {
                $scope.wh_section = records;
                $scope.currentPage = 1;
                $scope.entryLimit = 25;
                $scope.filteredItems = $scope.wh_section.length;
                $scope.totalItems = $scope.wh_section.length;
              });
            } 
            else if (obj.status == 'gagal'){
              $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
            }
            else{
              $.growl.notice({ message: "Data TIDAK BISA dihapus" });
            };
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
          },1000);
        } 
      });
    }
    return false;
  };

  $scope.setPage = function(pageNo) {
      $scope.currentPage = pageNo;
  };

  $scope.filter = function() {
      $timeout(function() { 
          $scope.filteredItems = $scope.filtered.length;
      }, 25);
  };
});

app.controller('SectionNewController', function($scope,$http, $timeout) {
  $scope.saveNew = function(isgen,status) {
    //alert ($scope.sectionCode);
    if ($scope.sectionName === ''){
      $.growl.warning({ message: 'Nama tidak boleh kosong' });
    }
    else if($scope.sectionCode === ''){
      $.growl.warning({ message: 'Kode tidak boleh kosong' });
    }
    else if($scope.sectionCode.length != 3){
      $.growl.warning({ message: 'Kode Seksi harus 3 karakter' });
    }
    else if($("#sectionSelected").val() == ''){
      $.growl.warning({ message: 'Status tidak boleh kosong' });
    }
    else {
      if(!isgen){
        $scope.loading = true; 
      };

      $scope.dataNew = {"name":$scope.sectionName,"code":$scope.sectionCode,"active":$("#sectionSelected").val()};

      var json = JSON.stringify($scope.dataNew);

      $.ajax({
        type: 'post',
        url:url_base+'wh_section/saveNew',
        data: "json="+json,
        success: function(msg){
          var obj = JSON.parse(msg);
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              if (obj.status == 'sukses') {
                $.growl.notice({ message: "Data BERHASIL diSimpan" });
              } 
              else if (obj.status == 'duplikat') {
                $.growl.error({ message: "Kode sudah ada. Ganti Kode Seksi" });
              }
              else {
                $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
              };
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
            }
            $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
          },1000);
        } 
      });
    }
  };
});

app.controller('SectionEditController',['$scope','$routeParams','$http','$timeout',
  function($scope,$routeParams,$http,$timeout){
    var id = $routeParams.id;

    $http.get(url_base+'wh_section/sectionEditView/'+id).success(function (records){
      $scope.sectionName = records[0]['section_name'];
      $scope.sectionCode = records[0]['section_code'];
      $("#categorySelected").val(records[0]['is_active']);
    });

    $scope.saveEdit = function(isgen,status) {
      if ($scope.sectionName === ''){
        $.growl.warning({ message: 'Nama tidak boleh kosong' });
      }
      else if($scope.sectionCode == '') {
        $.growl.warning({ message: 'Kode tidak boleh kosong' });
      }
      else if($scope.sectionCode.length != 3) {
        $.growl.warning({ message: 'Kode harus 3 karakter' });
      }
      else {
        if(!isgen){
          $scope.loading = true; 
        };

        $scope.dataEdit = {"id":id,"code":$scope.sectionCode,"name":$scope.sectionName,"active":$("#sectionSelected").val()};

        var json = JSON.stringify($scope.dataEdit);

        $.ajax({
          type: 'post',
          url:url_base+'wh_section/saveEdit',
          data: "json="+json,
          success: function(msg){
            var obj = JSON.parse(msg);
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
                if (obj.status == 'sukses') {
                  $.growl.notice({ message: "Data BERHASIL diSimpan" });
                } 
                else if (obj.status == 'duplikat'){
                  $.growl.error({ message: "Kode Seksi sudah ada. Ganti kode !" });
                }
                else {
                  $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
                };
              }
            },1000);
          },
          error: function(XMLHttpRequest, textStatus, errorThrown) {
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
              }
              $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
            },1000);
          } 
        });
      }
    };
  }
]);