app.controller('ToController', function($scope,$http, $timeout) {
  $(window).off("keypress");
  $http.get(url_base+"wh_to/toView").success(function (records) {
    $scope.wh_to = records;
    $scope.currentPage = 1;
    $scope.entryLimit = 25;
    $scope.filteredItems = $scope.wh_to.length;
    $scope.totalItems = $scope.wh_to.length;
  });

  $scope.setPage = function(pageNo) {
      $scope.currentPage = pageNo;
  };

  $scope.filter = function() {
      $timeout(function() { 
          $scope.filteredItems = $scope.filtered.length;
      }, 25);
  };
});

app.controller('ToDetailController',['$scope','$routeParams','$http',
  function($scope,$routeParams,$http){
    var id = $routeParams.id;

    $http.get(url_base+'wh_to/toViewDetailHeader/'+id).success(function (records){
      $scope.codeToSelected = records[0]['tr_code'];
      $scope.dateToSelected = records[0]['tr_date'];
      $scope.st1Selected = records[0]['tr_from'];
      $scope.st2Selected = records[0]['tr_to'];
      $scope.atSelected = records[0]['createdat']; 
      $scope.bySelected = records[0]['full_name'];  
      $scope.distinctItem =  records[0]['item_count'];  
      $scope.countTotal =  records[0]['total_item_qty'];  
    });

    $http.get(url_base+'wh_to/toViewDetail/'+id).success(function (records){
      $scope.toDetail = records;
    });
  }
]);

app.controller('ToNewController', function($scope,$http, $timeout) {
  $scope.productList = [];
  $scope.barcodeX = [];
  $scope.barcodeY = [];
  $scope.distinctItem = 0;
  $scope.countTotal = 0;
  $scope.statusBarcode = true;
  $scope.searchCode = '';
  $scope.searchName = '';
  $("#masking").hide();
  $("#divList2").hide();
  $("#divNotif").hide();
  var pressed = false; 
  var chars = [];

  $http.get(url_base+"wh_to/getInputMethod").success(function (records){
    if (records['input_method'] == 0){
      $("#tableEdit").hide();
      $("#buttonProduct").hide();

      $(window).on("keypress",function(ev) {
        //$("#barcode").focus();
        
        if ((ev.which >= 48 && ev.which <= 57) || (ev.which >= 65 && ev.which <= 90)) {
          chars.push(String.fromCharCode(ev.which));
        }

        if (pressed == false) {
          setTimeout(function(){
            if (chars.length == 12) {
              var barcode = chars.join("");   
              $("#barcode").val(barcode);

              if($("#barcode").val().length == 12){
                var barcode = $("#barcode").val().substring(0,6);

                var is_barcode_exist_local = false;
                var is_barcode_exist_global = false;

                for (var i = 0; i < $scope.barcodeX.length; i++) {
                  if ($scope.barcodeX[i] == $("#barcode").val()){
                    is_barcode_exist_local = true;
                    $.growl.warning({ message: 'Produk sudah di scan di TO ini' });
                  }
                }

                for (var i = 0; i < $scope.barcodeY.length; i++) {
                  if ($scope.barcodeY[i] == $("#barcode").val()){
                    is_barcode_exist_global = true;
                    $.growl.warning({ message: 'Produk sudah di scan di TO sebelumnya' });
                  }
                }

                if (is_barcode_exist_local == false && is_barcode_exist_global == false){
                  $http.get(url_base+"wh_to/getProduct?code="+barcode).success(function (records){
                    $scope.productBarcode = records; 
                    if ($scope.productBarcode.length == 1){
                      var id = $scope.productBarcode[0]['product_id'];
                      var code = $scope.productBarcode[0]['product_code'];
                      var name = $scope.productBarcode[0]['product_name'];
                      var unitL = $scope.productBarcode[0]['unit_large'];
                      var quantity = $scope.productBarcode[0]['quantity'];
                      var quantity2 = $scope.productBarcode[0]['quantity2'];
                      var quantity3 = $scope.productBarcode[0]['quantity3'];

                      if (isExist(code) == false && $scope.statusBarcode == true) {
                        $scope.productList.push({"id":id,"code":code,"name":name,"unitL":unitL,"quantity":quantity,"quantity2":quantity2,"quantity3":quantity3});
                      }
                      else {
                        for (var i = $scope.productList.length - 1; i >= 0; i--) {
                          if ($scope.productList[i].code == code) {
                            var qty = parseFloat($scope.productList[i].quantity) + parseFloat(quantity);

                            $scope.productList[i].quantity = qty;
                          };
                        };
                      };
                      
                      for (var i = $scope.productList.length - 1; i >= 0; i--) {
                        if ($scope.productList[i].code == code) {
                          if (parseFloat($scope.productList[i].quantity) > parseFloat($scope.productList[i].quantity2)) {
                            $scope.productList[i].quantity = $scope.productList[i].quantity2
                            $.growl.warning({ message: 'Jumlah produk sudah melebihi jumlah TO' });
                          }
                          else{
                            $scope.barcodeX[$scope.barcodeX.length] = $("#barcode").val();

                            $scope.codeBarcodeView = $("#barcode").val();
                            $scope.nameBarcodeView = $scope.productList[i].name;
                            $scope.currentQtyBarcodeView = $scope.productList[i].quantity;
                            $scope.leftQtyBarcodeView = $scope.productList[i].quantity2;
                            //$scope.separator = '/';
                          };
                        };
                      };

                      if (isExist(code) == false && $scope.statusBarcode == false) {
                        $.growl.warning({ message: 'Produk tidak ada di list' });
                      }

                      $scope.distinctItem = $scope.productList.length;
                      $scope.countTotal = count();
                    }
                  });
                }
              }
            }
            chars = [];
            pressed = false;
          },500);
        }
        pressed = true;
      });
    }
    else{
      $("#tableNoEdit").hide();
      $("#divBarcode").hide();
    }
  });

  $scope.inputBarcode = function() {
    if($scope.barcode.length == 12){
      var barcode = $scope.barcode.substring(0,6);

      var is_barcode_exist_local = false;
      var is_barcode_exist_global = false;

      for (var i = 0; i < $scope.barcodeX.length; i++) {
        if ($scope.barcodeX[i] == $scope.barcode){
          is_barcode_exist_local = true;
          $.growl.warning({ message: 'Produk sudah di scan di TO ini' });
        }
      }

      for (var i = 0; i < $scope.barcodeY.length; i++) {
        if ($scope.barcodeY[i] == $scope.barcode){
          is_barcode_exist_global = true;
          $.growl.warning({ message: 'Produk sudah di scan di TO sebelumnya' });
        }
      }

      if (is_barcode_exist_local == false && is_barcode_exist_global == false){
        $http.get(url_base+"wh_ti/getProduct?code="+barcode).success(function (records){
          $scope.productBarcode = records; 
          if ($scope.productBarcode.length == 1){
            var id = $scope.productBarcode[0]['product_id'];
            var code = $scope.productBarcode[0]['product_code'];
            var name = $scope.productBarcode[0]['product_name'];
            var unitL = $scope.productBarcode[0]['unit_large'];
            var quantity = $scope.productBarcode[0]['quantity'];
            var quantity2 = $scope.productBarcode[0]['quantity2'];
            var quantity3 = $scope.productBarcode[0]['quantity3'];

            if (isExist(code) == false && $scope.statusBarcode == true) {
              $scope.productList.push({"id":id,"code":code,"name":name,"unitL":unitL,"quantity":quantity,"quantity2":quantity2,"quantity3":quantity3});
            }
            else {
              for (var i = $scope.productList.length - 1; i >= 0; i--) {
                if ($scope.productList[i].code == code) {
                  var qty = parseFloat($scope.productList[i].quantity) + parseFloat(quantity);

                  $scope.productList[i].quantity = qty;
                };
              };
            };
            
            for (var i = $scope.productList.length - 1; i >= 0; i--) {
              if ($scope.productList[i].code == code) {
                if (parseFloat($scope.productList[i].quantity) > parseFloat($scope.productList[i].quantity2)) {
                  $scope.productList[i].quantity = $scope.productList[i].quantity2
                  $.growl.warning({ message: 'Jumlah produk sudah melebihi jumlah TO' });
                }
                else{
                  $scope.barcodeX[$scope.barcodeX.length] = $scope.barcode;

                  $scope.codeBarcodeView = $scope.barcode;
                  $scope.nameBarcodeView = $scope.productList[i].name;
                  $scope.currentQtyBarcodeView = $scope.productList[i].quantity;
                  $scope.leftQtyBarcodeView = $scope.productList[i].quantity2;
                  //$scope.separator = '/';
                };
              };
            };

            if (isExist(code) == false && $scope.statusBarcode == false) {
              $.growl.warning({ message: 'Produk tidak ada di list' });
            }

            $scope.distinctItem = $scope.productList.length;
            $scope.countTotal = count();
          }
           $scope.barcode = '';
        });
      }
      else{
        $scope.barcode = '';
      }
    }
  };

  $http.get(url_base+"po/storageView").success(function (records){
    $scope.storageList = records;
  });

  $http.get(url_base+"wh_to/categoryView").success(function (records){
    $scope.categoryList = records; 
  });

  $http.get(url_base+"wh_to/groupView").success(function (records){
    $scope.groupList = records; 
  });

  $http.get(url_base+"wh_to/stView").success(function (records){
    $scope.stList = records; 
  });

  $http.get(url_base+"wh_to/getBarcode").success(function (records){
    $scope.barcodeList = records; 

    for (var i = $scope.barcodeList.length - 1; i >= 0; i--) {
      $scope.barcodeY[$scope.barcodeY.length] = $scope.barcodeList[i].code;
    };
  });

  function isExist(code){
    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      if ($scope.productList[i].code == code) {
        return true;
      };
    };
    return false;
  };

  function count(){
    var count = 0;

    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      count = parseFloat($scope.productList[i]['quantity']) + parseFloat(count);
    };

    return count;
  };

  function curDate(){
    var today = new Date();
    var dd = today.getDate();
    var mm = today.getMonth() + 1;
    var yyyy = today.getFullYear();

    if (dd < 10){
      dd = '0'+dd;
    };

    if (mm < 10){
      mm = '0'+mm;
    };  

    today = yyyy+'-'+mm+'-'+dd; 

    return today;
  }

  $scope.dateTo = curDate();

  $(window).resize(function(){
    if ($(window).width() < 752){
      $("#divExtend").height(80);
    }
    else{
      $("#divExtend").height(0);
    }
  });

  $scope.addProduct = function(id,code,name,unitL) {
    $scope.productName = name;
    $scope.unitL = unitL;

    $("#masking").css({top:0,left:0,position:"absolute"});
    $("#masking").css({"height": $("#divList2").height()+"px","width": $("#divList2").width()+"px"});
    $("#masking").css("z-index","9999");
    $("#masking").show();

    var x = $(window).scrollTop();
    var y = $("#masking").width();
    var z = $("#divCount").width();
    $("#divCount").css({top:x,left:(y-z)/2,position:"absolute"});

    $("#autofocus").focus();

    $scope.addCount = function(quantity) {
      if ($scope.count > 0) {
        if (isExist(code) == false) {
          $scope.productList.push({"id":id,"code":code,"name":name,"unitL":unitL,"quantity":quantity,"quantity2":"","quantity3":""});
        }
        else {
          for (var i = $scope.productList.length - 1; i >= 0; i--) {
            if ($scope.productList[i].id == id) {
              var qty = parseFloat($scope.productList[i].quantity) + parseFloat(quantity);

              $scope.productList[i].quantity = qty;

              if (parseFloat($scope.productList[i].quantity) > parseFloat($scope.productList[i].quantity2)) {
                $scope.productList[i].quantity = $scope.productList[i].quantity2;
              }

              var pId = "p"+id;
              $("#"+pId).val($scope.productList[i].quantity);
            };
          };
        };

        $scope.distinctItem = $scope.productList.length;
        $scope.countTotal = count();
        $scope.count = '';
        $("#masking").hide();
      }
      else{
        $.growl.notice({ message: "Jumlah harus diatas 0" });
      };
    };
  };

  $scope.updateCount = function(id){
    var pId = "p"+id;
    var newVal = $("#"+pId).val();

    if (newVal == ''){
      newVal = 0;
    }

    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      if ($scope.productList[i].id == id) {
        $scope.productList[i].quantity = newVal;

        if (parseFloat($scope.productList[i].quantity) > parseFloat($scope.productList[i].quantity2)) {
          $scope.productList[i].quantity = $scope.productList[i].quantity2
        }

        $("#"+pId).val($scope.productList[i].quantity);

        $scope.countTotal = count();
      };
    };
  };

  $scope.deleteProduct = function(index) {
    for (var i = $scope.barcodeX.length - 1; i >= 0; i--) {
      if ($scope.barcodeX[i].substring(0,6) == $scope.productList[index].code) {
        $scope.barcodeX.splice(i,1);
      }
    };

    $scope.productList.splice(index,1);
    $scope.distinctItem = $scope.productList.length;
    $scope.countTotal = count();
  };

  $scope.saveTransferOut = function(isgen,status) {
    var dateTo = $scope.dateTo;
    //var st1 = $("#st1Selected").val();
    var st2 = $("#st2Selected").val();
    
    /*if (st1 === ''){
      $.growl.warning({ message: 'Gudang asal belum diisi' });
    }
    else */
    if (st2 === ''){
      $.growl.warning({ message: 'Gudang tujuan belum diisi' });
    }
    else if ($("#storageSelected").val() == $("#st2Selected").val()){
      $.growl.warning({ message: 'Gudang asal dan gudang tujuan harus beda' });
    }
    else if ($scope.productList.length == 0){
      $.growl.warning({ message: 'Data produk belum diisi' });
    }
    else {
      if(!isgen){
        $scope.loading = true; 
      };

      $scope.productHeader = {"st":$("#storageSelected").val(),"dateTr":dateTo,"st2":st2,"itemCount":$scope.distinctItem,"totalItemQty":$scope.countTotal};

      var json = JSON.stringify($scope.productList);
      var json2 = JSON.stringify($scope.productHeader);
      var json3 = JSON.stringify($scope.barcodeX);

      $.ajax({
        type: 'post',
        url:url_base+'wh_to/saveTransferOut',
        data: "json="+json+"&json2="+json2+"&json3="+json3,
        success: function(msg){
          var obj = JSON.parse(msg);
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              if (obj.status == 'sukses') {
                $http.get(url_base+"wh_to/getNotif").success(function (records) {
                  $scope.codeNotif = records[0]['tr_code'];
                  $scope.dateNotif = records[0]['tr_date'];
                  $scope.toNotif = records[0]['st_name'];
                  $scope.atNotif = records[0]['at'];
                  $scope.byNotif = records[0]['full_name'];
                  
                  $("#divMain").hide();
                  $("#divNotif").show();
                });
                $.growl.notice({ message: "Data BERHASIL diSimpan" });
              } else {
                $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
              };
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
            }
            $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
          },1000);
        } 
      });
    }
  };

  $scope.showDivList2 = function() {
    $http.get(url_base+"wh_to/productView").success(function (records){
      $scope.products = records; 
      $scope.currentPage = 1;
      $scope.entryLimit = 100;
      $scope.filteredItems = $scope.products.length;
      $scope.totalItems = $scope.products.length;

      window.scrollTo(0,0);
      $("#divMain").hide();
      $("#divList2").css({top:-80,left:0,position:"absolute"});
      $("#divList2").css("z-index","9998");
      $("#divList2").show(function(){
        $("#divList2").css({"height": $(document).height()+"px","width": $(document).width()+"px"});
      
        if ($(window).width() < 752){
          $("#divExtend2").height(80);
        }
        else{
          $("#divExtend2").height(0);
        }
      });
    });
  };

  $scope.showDivMain2 = function() {
    $("#divMain").show();
    $("#divList2").hide();
    $scope.searchCode = '';
    $scope.searchName = '';
    $("#categorySelected").val("");
    $("#groupSelected").val("");
  };

  $scope.hideDivCount = function() {
    $("#masking").hide();
    $scope.count = '';
  };

  $scope.searchProductList = function(code,name) {
    var category = $("#categorySelected").val();
    var group = $("#groupSelected").val();

    $http.get(url_base+"wh_to/searchProductList?code="+code+"&name="+name+"&category="+category+"&group="+group).success(function (records) {
      $scope.products = records;
    });

    /*$scope.searchInput = {"code":code,"name":name,"category":category,"group":group};

    var json = JSON.stringify($scope.searchInput);

    $.ajax({
      type: 'post',
      url:url_base+'wh_to/searchProductList',
      data: "json="+json,
      success: function(msg){
        var temp = JSON.parse(msg);
        $scope.products = msg;
        alert (msg);
        alert ($scope.products);
      },
      error: function() {
        $.growl.error({ message: "Pencarian GAGAL. <br/>Cek koneksi internet dan ulangi Lagi !" });
      } 
    });*/
  };

  $("#barcode").keypress(function(ev){
    if (ev.which === 13 ) {
      ev.preventDefault();
    }
  });

  $("button").click(function(){
    $(this).blur();
  });

});