<?php

class Purchase {
	
	function printBon()
	{
		global $config;
		
		$url = 'php://input';
		$data = json_decode(file_get_contents($url));

		$string = "\x1b\x21\x10";
		$string .= "PEMBELIAN BARANG\n";
		$string .= "\x1b\x21\x00";
		$string .= "\x1b\x4d\x01";
		$string .= "No. Bon : ".$data->header->code."\n";
		$string .= "Outlet : ".$data->header->author_name."\n";
		$string .= "User : ".$data->header->author_name."\n";
		
		$string .= "Tanggal : ".$data->header->closing_date."\n";
		$string .= "Print : ".date('d/m/Y H:i:s')."\n\n";
		$string .= "----------------------------------------\n";
		$total = 0;
		$qty = 0;
		foreach ($data->body as $row) {
			$subtotal = $row->qty * $row->price * ($row->is_cons_bon == 1 ? -1 : 1);
			$total = $total + ($subtotal > 0 ? $subtotal : 0);
			$qty = $qty + $row->qty;

			$string .= $row->product_code."  ".$row->product_name."\n";
			if($row->comments <> '')
				$string .= ' >> '.$row->comments."\n";
			$string .= my_helper::renderContent($row->qty, ' ', 'right', 5)."  x  ".my_helper::renderContent(number_format($row->price, 0, ",", "."), ' ', 'right', 10)
					.my_helper::renderContent(number_format($subtotal, 0, ",", "."), ' ', 'right', 20)."\n";
		}
		$string .= "----------------------------------------\n";
		$string .= "\n \n";
		$string .= "Total Pembelian    :".my_helper::renderContent(number_format($total, 0, ",", "."), ' ', 'right', 20)."\n";
		$string .= "Jumlah Barang      :".my_helper::renderContent(number_format(count($data->body), 0, ",", "."), ' ', 'right', 20)."\n";
		$string .= "\n \n";
		$string .= "                          RM/SPV/CPT    ";
		$string .= "\n \n";
		$string .= "\n \n";
		$string .= "                    (                  )";
		$string .= "\n \n";
		$string .= "\n \n";
		$string .= "\n \n";
		$string .= "\n \n";
		$string .= "\n \n";
		$string .= "\x0a";
		$string .= "\x1d\x56\x00";

    	my_helper::printString($string);
	}
}

?>
