<?php /**
* 
*/
class Drivers extends CI_Controller
{
	function index()
	{
		$result = $this->find_all();
		echo json_encode($result);
	}

	function create()
	{
		try {
			$data = json_decode(file_get_contents('php://input'));
			if(isset($data->Drivers))
			{
				$data = $data->Drivers;
				$result = $this->db->insert('master_driver',$data);
				$result = $this->findby_pk($this->db->insert_id());
				$log_history = array('treatment' =>'create' ,'date_time' =>date("Y-m-d H:i:s"),'author_id'=>$this->session->userdata('author_id'),
				'datatable'=>'Driver');
				$this->db->insert('log_history',$log_history);
				echo '{"success":{"msg":"Data driver BERHASIL disimpan !"}, "driver":'.json_encode($result).'}';
			}
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menyimpan data driver !", "text":'. $e->getMessage() .'}}';
		}
	}

	function update($id)
	{
		try {
			$data = json_decode(file_get_contents('php://input'));
			if(isset($data->Drivers))
			{
				$data = $data->Drivers;
				$this->db->where('id', $id);
				$result = $this->db->update('master_driver',$data);
				$result = $this->findby_pk($id);
				$log_history = array('treatment' =>'update' ,'date_time' =>date("Y-m-d H:i:s"),'author_id'=>$this->session->userdata('author_id'),
				'datatable'=>'Driver');
				$this->db->insert('log_history',$log_history);

				echo '{"success":{"msg":"Data driver BERHASIL disimpan !"}, "driver":'.json_encode($result).'}';
			} else {
				$result = $this->findby_pk($id);
				echo json_encode($result);
			}
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menyimpan data driver !", "text":'. $e->getMessage() .'}}';
		}
	}

	function delete($id)
	{
		try {
			$this->db->where('id', $id);
			$this->db->delete('master_driver');
			$log_history = array('treatment' =>'delete' ,'date_time' =>date("Y-m-d H:i:s"),'author_id'=>$this->session->userdata('author_id'),
				'datatable'=>'Driver');
				$this->db->insert('log_history',$log_history);

			$result = $this->find_all();
			echo json_encode($result);
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menghapus data driver !", "text":'. $e->getMessage() .'}}';
		}
	}
	
	function view($id)
	{
		try {
			$result = $this->findby_pk($id);
			echo json_encode($result);
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL mengambil data driver !", "text":'. $e->getMessage() .'}}';
		}
	}
	
	function find_all()
	{
		$sql = "select * from master_driver";
		return $this->db->query($sql)->result();
	}

	function findby_pk($id)
	{
		$id_ = addslashes($id);
		$sql = "select * from master_driver where id= ".$id_;
		return $this->db->query($sql)->result();
	}
} ?>