<?php /**
* 
*/
class Menus extends CI_Controller
{
	function index()
	{
		$result = $this->find_all();
		echo json_encode($result);
	}

	function create()
	{
		try {
			$data = json_decode(file_get_contents('php://input'));
			if(isset($data->Menus))
			{
				$data = $data->Menus;
				$result = $this->db->insert('master_menus',$data);
				$result = $this->findby_pk($this->db->insert_id());
				echo '{"success":{"msg":"Data menu BERHASIL disimpan !"}, "menu":'.json_encode($result).'}';
			} else {
				echo json_encode(array('categories'=>$this->find_all_categories()));
			}
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menyimpan data menu !", "text":'. $e->getMessage() .'}}';
		}
	}

	function update($id)
	{
		try {
			$data = json_decode(file_get_contents('php://input'));
			if(isset($data->Menus))
			{
				$data = $data->Menus;
				$this->db->where('menu_id', $id);
				$result = $this->db->update('master_menus',$data);
				$result = $this->findby_pk($id);
				echo '{"success":{"msg":"Data menu BERHASIL disimpan !"}, "menu":'.json_encode($result).'}';
			} else {
				$result = $this->findby_pk($id);
				echo json_encode(array(
							'list'=>$result,
							'packages'=>$this->find_menu_packages($id),
							'compositions'=>$this->find_menu_compositions($id),
							'package_compositions'=>$this->find_menu_package_compositions($id),
							'categories'=>$this->find_all_categories()));
			}
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menyimpan data menu !", "text":'. $e->getMessage() .'}}';
		}
	}

	function delete($id)
	{
		try {
			$this->db->where('menu_id', $id);
			$this->db->delete('master_menus');
			
			$result = $this->find_all();
			echo json_encode($result);
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menghapus data menu !", "text":'. $e->getMessage() .'}}';
		}
	}
	
	function view($id)
	{
		try {
			$result = $this->findby_pk($id);
			echo json_encode(array(
						'list'=>$result,
						'packages'=>$this->find_menu_packages($id),
						'compositions'=>$this->find_menu_compositions($id),
						'package_compositions'=>$this->find_menu_package_compositions($id),
						'categories'=>$this->find_all_categories()));
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menyimpan data menu !", "text":'. $e->getMessage() .'}}';
		}
	}
	
	function find_all()
	{
		$sql = "select menu_id, category_id, menu_code, menu_name, menu_nick, fc_format_rupiah(menu_price) AS menu_price, is_active, is_package from master_menus";
		return $this->db->query($sql)->result();
	}

	function findby_pk($id)
	{
		$id_ = addslashes($id);
		$sql = "select * from master_menus where menu_id= ".$id_;
		return $this->db->query($sql)->result();
	}
	
	function find_all_categories()
	{
		$sql = "select * from master_menu_categories";
		return $this->db->query($sql)->result();
	}
	
	function find_menu_packages($id)
	{
		$sql = "SELECT A.*, B.menu_code, B.menu_name, B.menu_nick, B.menu_price, B.is_active 
				FROM `master_menu_packages` A INNER JOIN `master_menus` B ON A.menu_id = B.menu_id 
				WHERE A.package_id = ".$id;
		return $this->db->query($sql)->result();
	}
	
	function find_menu_compositions($id)
	{
		$sql = "SELECT A.*, B.product_name, B.unit_small, B.is_active 
				FROM `master_menu_compositions` A INNER JOIN `master_products` B ON A.product_id = B.product_id 
				WHERE A.menu_id = ".$id;
		return $this->db->query($sql)->result();
	}
	
	function find_menu_package_compositions($id)
	{
		$sql = "SELECT C.product_id, D.product_code, D.product_name, unit_small, SUM(MENU.qty * qty_dynein) AS qty_dynein, SUM(MENU.qty * qty_deltak) AS qty_deltak, D.is_active
				FROM (SELECT A.menu_id AS `package_id`
							  , CASE WHEN B.menu_id IS NULL THEN A.menu_id ELSE B.menu_id END AS `menu_id`
							, CASE WHEN B.menu_id IS NULL THEN 1 ELSE B.qty END AS `qty`
					FROM `master_menus` A LEFT JOIN `master_menu_packages` B ON A.menu_id = B.package_id
					WHERE A.menu_id = ".$id.") MENU INNER JOIN `master_menu_compositions` C ON MENU.menu_id = C.menu_id
							INNER JOIN `master_products` D ON C.product_id = D.product_id
				GROUP BY C.product_id, D.product_code, D.product_name, unit_small";
		return $this->db->query($sql)->result();
	}
} ?>