<?php /**
* 
*/
class Waste extends CI_Controller
{
	function get_author($id){
		$sql = "select full_name from user_apps where id = ".$id;
		$person = $this->db->query($sql);
		if ($person->num_rows() >0) {
			return $person->row()->full_name;
		}else{
			return "-";
		}
	}

	function get_waste_detail($id){
		$sql = "select d.*, p.* from outlet_product_waste_details d inner join master_products p on (d.product_id = p.product_id) where d.waste_id = ".$id;
		$data = $this->db->query($sql)->result();
		return $data;
	}

	
	function find_all(){
		$sql = "select * from outlet_product_waste where outlet_id = ".$this->session->userdata('outlet_id')." and closing_date = '".$this->get_tanggal_closing()."' order by id  desc";
		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function findby_pk($id){
		$this->db->trans_begin();
		$sql = "select * from outlet_product_waste where outlet_id = ".$this->session->userdata('outlet_id')." and id = ".$id." ";
		$header = $this->db->query($sql);
		$person = $header->row();
		$person->author_name = $this->get_author($person->author_id);
		$data['body'] = $this->get_waste_detail($id);
		//$person['sasa'] = "pian";
		$data['header'] = $person;
		echo json_encode($data);
	} 

	function create_waste(){
		$array = json_decode($this->input->post('json'));
		$detail = $array;
		$closing_date = $this->get_tanggal_closing();

		$new_purchase  = array(
			'code' => $this->generate($this->session->userdata('outlet_id')), 
			'outlet_id' => $this->session->userdata('outlet_id'), 
			'closing_date'=>$closing_date,
			'author_id' => $this->session->userdata('author_id'), 
			'created_at' => date("Y-m-d H:i:s"), 
		);
		$this->db->trans_begin();		
		$this->db->insert('outlet_product_waste',$new_purchase);
		$id = $this->db->insert_id();
		$this->create_waste_detail($detail,$id);
		if ($this->db->trans_status() === FALSE)
		{
		    $this->db->trans_rollback();
		    echo "gagal";
		}
		else
		{
			$log_history = array('treatment' =>'create' ,'date_time' =>date("Y-m-d H:i:s"),'author_id'=>$this->session->userdata('author_id'),
			'datatable'=>'waste before process','closing_date'=>$closing_date,'outlet_id'=>$this->session->userdata('outlet_id'));
			$this->db->insert('log_history',$log_history);
		    $this->db->trans_commit();
		    echo $id;
		}	
		//var_dump(sizeof($detail));

	}


	function create_waste_detail($detail,$id){
		foreach ($detail as $d) {
			$new_detail = array(
				'waste_id'=>$id,
				'product_id'=>$d->product_id,
				'unit_large'=>$d->unit_large,
				'unit_small'=>$d->unit_small,
				'conversion'=>$d->conversion,
				'type_id'=>1,
				'comment'=>$d->comments,
				'qty'=>$d->qty
				);

			$this->db->insert('outlet_product_waste_details',$new_detail);
		}
	}

	function generate($_outlet_id){
		$year = date("Y");
        $month = date("m");

		$this->load->model('outlets');
		$code = "WP-".$this->outlets->getOutletCode($_outlet_id).'-';
		
		$select = "select count(id) as total from outlet_product_waste where MONTH(created_at) = $month and YEAR(created_at) = $year AND code like '".$code."%'";
		$data = $this->db->query($select)->row();
		
		return $code.substr($year, 2)."".$month."".$this->get_zero($data->total+1);
	}

	function generates(){
		$year = date("Y");
        $month = date("m");

		$select = "select count(id) as total from outlet_product_waste where MONTH(created_at) = $month and YEAR(created_at) = $year";
		$data = $this->db->query($select)->row();
		echo $select."<br>";
		echo "WP-".substr($year, 2)."".$month."".$this->get_zero($data->total+1);
	}

	function get_tanggal_closing()
	{
		$sql = "select value from outlet_config where code = 'closing_date' and outlet_id = ".$this->session->userdata('outlet_id');
		$result = $this->db->query($sql)->row();
		return $result->value;
	}

	function get_zero($id){
		$zero = "";
		for ($i=0; $i < 4-strlen($id.""); $i++) { 
			$zero.="0";
		}
		return $zero.$id;
	}


	function update_waste(){
		$array = json_decode($this->input->post('json'));
		$id = $this->input->post('id');
		$detail = $array;
		$closing_date = $this->get_tanggal_closing();	
		$this->db->trans_begin();		
		$this->db->query('Delete from outlet_product_waste_details where waste_id = '.$id);
		$this->update_waste_detail($detail,$id);
		if ($this->db->trans_status() === FALSE)
		{
		    $this->db->trans_rollback();
		    echo "gagal";
		}
		else
		{
			$log_history = array('treatment' =>'update' ,'date_time' =>date("Y-m-d H:i:s"),'author_id'=>$this->session->userdata('author_id'),
			'datatable'=>'waste before process','closing_date'=>$closing_date,'outlet_id'=>$this->session->userdata('outlet_id'));
			$this->db->insert('log_history',$log_history);
		    $this->db->trans_commit();
		    echo $id;
		}	
		//var_dump(sizeof($detail));

	}
	

	function update_waste_detail($detail,$id){
		foreach ($detail as $d) {
			$new_detail = array(
				'waste_id'=>$id,
				'product_id'=>$d->product_id,
				'unit_large'=>$d->unit_large,
				'unit_small'=>$d->unit_small,
				'conversion'=>$d->conversion,
				'type_id'=>1,
				'comment'=>$d->comment,
				'qty'=>$d->qty
				);

			$this->db->insert('outlet_product_waste_details',$new_detail);
		}
	}




} ?>