<?php
class Reports_model extends CI_Model
{
	function __construct()
	{
		parent::__construct();
	}

	function viewMonthly($data)
	{
		$start = new DateTime($data->periode_start);
		$end = new DateTime($data->periode_end);

		$_newDate = new DateTime($start->format('Y').'-'.$start->format('m').'-01');
		$fields = array();
		$sql = '';
		while($_newDate <= $end)
		{
			$fields[] = $_newDate->format('Ym');
			$sql .= ", SUM(CASE WHEN DATE_FORMAT(A.closing_date,'%Y%m') = '".$_newDate->format('Ym')."' THEN B.qty ELSE 0 END) AS `q".$_newDate->format('Ym')."`";
			$_newDate->add(new DateInterval("P1M"));
		}
		
		$result = $this->runQuery($sql, $data);
		echo json_encode(array('fields'=>$fields, 'field_values'=>$result));
	}
	
	function viewDaily($data)
	{
		$start = new DateTime($data->periode_start);
		$end = new DateTime($data->periode_end);

		$_newDate = clone $start;
		$fields = array();
		$sql = '';
		while($_newDate <= $end)
		{
			$fields[] = $_newDate->format('Ymd');
			$sql .= ", SUM(CASE WHEN DATE_FORMAT(A.closing_date,'%Y%m%d') = '".$_newDate->format('Ymd')."' THEN B.qty ELSE 0 END) AS `q".$_newDate->format('Ymd')."`";
			$_newDate->add(new DateInterval("P1D"));
		}
		
		$result = $this->runQuery($sql, $data);
		echo json_encode(array('fields'=>$fields, 'field_values'=>$result));
	}
}