<?php /**
* 
*/
class Purchase extends CI_Controller
{
	
	function get_author($id){
		$sql = "select full_name from user_apps where id = ".$id;
		$person = $this->db->query($sql);
		if ($person->num_rows() >0) {
			return $person->row()->full_name;
		}else{
			return "-";
		}
	}

	function get_purchase_detail($id){
		$sql = "select d.*, p.* from outlet_purchase_details d inner join master_products p on (d.product_id = p.product_id) where d.purchase_id = ".$id;
		$data = $this->db->query($sql)->result();
		return $data;
	}

	
	function find_all(){
		$sql = "select * from outlet_purchases where outlet_id = ".$this->session->userdata('outlet_id')." order by id  desc";
		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function findby_pk($id){
		$this->db->trans_begin();
		$sql = "select * from outlet_purchases where outlet_id = ".$this->session->userdata('outlet_id')." and id = ".$id." ";
		$header = $this->db->query($sql);
		$person = $header->row();
		$person->author_name = $this->get_author($person->author_id);
		$data['body'] = $this->get_purchase_detail($id);
		//$person['sasa'] = "pian";
		$data['header'] = $person;
		echo json_encode($data);
	} 

	function create_purchase(){
		$array = json_decode($this->input->post('json'));
		$detail = $array;

		$new_purchases  = array(
			'code' => $this->generate(), 
			'outlet_id' => $this->session->userdata('outlet_id'), 
			'closing_date'=>date("Y-m-d"),
			'author_id' => $this->session->userdata('author_id'), 
			'created_at' => date("Y-m-d H:i:s"), 
		);
		$this->db->trans_begin();		
		$this->db->insert('outlet_purchases',$new_purchases);
		$id = $this->db->insert_id();
		$this->create_purchase_detail($detail,$id);
		if ($this->db->trans_status() === FALSE)
		{
		    $this->db->trans_rollback();
		    echo "gagal";
		}
		else
		{
		    $this->db->trans_commit();
		    echo $id;
		}	
		//var_dump(sizeof($detail));

	}

	function create_purchase_detail($detail,$id){
		foreach ($detail as $d) {
			$new_detail = array(
				'purchase_id'=>$id,
				'product_id'=>$d->product_id,
				'unit_large'=>$d->unit_large,
				'unit_small'=>$d->unit_small,
				'conversion'=>$d->conversion,
				'qty'=>$d->qty
				);

			$this->db->insert('outlet_purchase_details',$new_detail);
		}
	}

	function generate(){
		$year = date("Y");
        $month = date("m");

		$select = "select count(id) as total from outlet_purchases where MONTH(created_at) = $month and YEAR(created_at) = $year";
		$data = $this->db->query($select)->row();
		
		return "PB-".substr($year, 2)."".$month."".$this->get_zero($data->total+1);
	}

	function generates(){
		$year = date("Y");
        $month = date("m");

		$select = "select count(id) as total from outlet_purchases where MONTH(created_at) = $month and YEAR(created_at) = $year";
		$data = $this->db->query($select)->row();
		echo $select."<br>";
		echo "PB-".substr($year, 2)."".$month."".$this->get_zero($data->total+1);
	}

	function get_zero($id){
		$zero = "";
		for ($i=0; $i < 4-strlen($id.""); $i++) { 
			$zero.="0";
		}
		return $zero.$id;
	}
} ?>