<?php /**
* 
*/
class Waste extends CI_Controller
{
	function index()
	{
		$data = json_decode(file_get_contents('php://input'));
		if(isset($data->Reports))
		{
			if($data->Reports->group == 'products')
			{
				$fields = array(
					array('code'=>'product_code', 'title'=>'Kode Product'), 
					array('code'=>'product_name', 'title'=> 'Nama Product'), 
					array('code'=>'unit', 'title'=> 'Satuan'), 
					array('code'=>'total', 'title'=> 'Total'));
				if($data->Reports->viewtype == 'total')
					$this->viewTotal($data->Reports, $fields);
				else if($data->Reports->viewtype == 'monthly')
					$this->viewMonthly($data->Reports, $fields);
				else
					$this->viewDaily($data->Reports, $fields);
			} elseif($data->Reports->group == 'menus')
			{
				$fields = array(
					array('code'=>'menu_code', 'title'=>'Kode Menu'), 
					array('code'=>'menu_name', 'title'=> 'Nama Menu'), 
					array('code'=>'menu_price', 'title'=> 'Harga'), 
					array('code'=>'total', 'title'=> 'Total'));
				if($data->Reports->viewtype == 'total')
					$this->viewMenuTotal($data->Reports, $fields);
				else if($data->Reports->viewtype == 'monthly')
					$this->viewMenuMonthly($data->Reports, $fields);
				else
					$this->viewMenuDaily($data->Reports, $fields);
			}
		}
	}

	function runQuery($data)
	{
		$sql = "CALL sp_report_waste_products(".(isset($data->outlet_id) && $data->outlet_id <> '' ? $data->outlet_id : '0').", '".$data->periode_start."', '".$data->periode_end."', '".$data->viewtype."')";
		return $this->db->query($sql)->result();
	}
	
	function viewTotal($data, $fields)
	{
		$result = $this->runQuery($data);
		echo json_encode(array('fields'=>$fields, 'field_values'=>$result));
	}
	
	function viewMonthly($data, $fields)
	{
		$start = new DateTime($data->periode_start);
		$end = new DateTime($data->periode_end);

		$_newDate = new DateTime($start->format('Y').'-'.$start->format('m').'-01');
		while($_newDate <= $end)
		{
			$fields[] = array('code'=>'q'.$_newDate->format('Ym'), 'title'=>$_newDate->format('Ym'));
			$_newDate->add(new DateInterval("P1M"));
		}
		
		$result = $this->runQuery($data);
		echo json_encode(array('fields'=>$fields, 'field_values'=>$result));
	}
	
	function viewDaily($data, $fields)
	{
		$start = new DateTime($data->periode_start);
		$end = new DateTime($data->periode_end);

		$_newDate = clone $start;
		while($_newDate <= $end)
		{
			$fields[] = array('code'=>'q'.$_newDate->format('Ymd'), 'title'=>$_newDate->format('Ymd'));
			$_newDate->add(new DateInterval("P1D"));
		}
		
		$result = $this->runQuery($data);
		echo json_encode(array('fields'=>$fields, 'field_values'=>$result));
	}
	
	function runMenuQuery($_sql, $data)
	{
		$sql = "SELECT B.menu_id, C.menu_code, C.menu_name, C.menu_price, SUM(B.qty) AS `total` ".$_sql."
				FROM `outlet_menu_waste` A INNER JOIN `outlet_menu_waste_details` B ON A.id = B.waste_menu_id 
					INNER JOIN `master_menus` C ON B.menu_id = C.menu_id
				WHERE A.closing_date BETWEEN '".$data->periode_start."' AND '".$data->periode_end."' ".(isset($data->outlet_id) ? " AND A.outlet_id = ".$data->outlet_id : '')." 
				GROUP BY B.menu_id, C.menu_code, C.menu_name, C.menu_price
				ORDER BY C.menu_name";
		return $this->db->query($sql)->result();
	}
	
	function viewMenuTotal($data, $fields)
	{
		$result = $this->runMenuQuery('', $data);
		echo json_encode(array('fields'=>$fields, 'field_values'=>$result));
	}
	
	function viewMenuMonthly($data, $fields)
	{
		$start = new DateTime($data->periode_start);
		$end = new DateTime($data->periode_end);

		$_newDate = new DateTime($start->format('Y').'-'.$start->format('m').'-01');
		$sql = '';
		while($_newDate <= $end)
		{
			$fields[] = array('code'=>'q'.$_newDate->format('Ym'), 'title'=>$_newDate->format('Ym'));
			$sql .= ", SUM(CASE WHEN DATE_FORMAT(A.closing_date,'%Y%m') = '".$_newDate->format('Ym')."' THEN B.qty ELSE 0 END) AS `q".$_newDate->format('Ym')."`";
			$_newDate->add(new DateInterval("P1M"));
		}
		
		$result = $this->runMenuQuery($sql, $data);
		echo json_encode(array('fields'=>$fields, 'field_values'=>$result));
	}
	
	function viewMenuDaily($data, $fields)
	{
		$start = new DateTime($data->periode_start);
		$end = new DateTime($data->periode_end);

		$_newDate = clone $start;
		$sql = '';
		while($_newDate <= $end)
		{
			$fields[] = array('code'=>'q'.$_newDate->format('Ymd'), 'title'=>$_newDate->format('Ymd'));
			$sql .= ", SUM(CASE WHEN DATE_FORMAT(A.closing_date,'%Y%m%d') = '".$_newDate->format('Ymd')."' THEN B.qty ELSE 0 END) AS `q".$_newDate->format('Ymd')."`";
			$_newDate->add(new DateInterval("P1D"));
		}
		
		$result = $this->runMenuQuery($sql, $data);
		echo json_encode(array('fields'=>$fields, 'field_values'=>$result));
	}
} ?>