<?php /**
* 
*/
class Menu extends CI_Controller
{
	
	public function create_menu(){
		$json = $this->input->post('json');
		$obj = json_decode($json);

		if ($this->check_unique_code($obj->menu_code) == 0) {
				$result = $this->save_menu($obj);
				$this->histories('create menu info'); 
				$data = array('is_save' => $result,'status'=>200);
				echo json_encode($data);
			} else {
				$data = array('is_save' =>'duplicate code','status'=>500);
				echo json_encode($data);
			}
				
	}

	public function update_menu(){
		$json = $this->input->post('json');
		$menu_id = $this->input->post('menu_id');
		$obj = json_decode($json);

		if ($this->check_unique_uptd($obj->menu_code) == 0) {
				$result = $this->edit_menu($obj,$menu_id);
				$this->histories('update menu info');
				$data = array('is_save' => $menu_id,'status'=>200);
				echo json_encode($data);
			} else {
				$data = array('is_save' =>'duplicate code','status'=>500);
				echo json_encode($data);
			}
				
	}

	public function edit_menu($obj,$menu_id){
		$this->db->trans_begin();	
		$this->db->where('menu_id',$menu_id);	
		$result = $this->db->update('master_menus',$obj);

		if ($this->db->trans_status() === FALSE)
		{
		    $this->db->trans_rollback();
		    return "gagal";
		}
		else
		{
			
		    $this->db->trans_commit();
		    return $menu_id;
		}

	}

	public function save_menu($obj){
		$this->db->trans_begin();		
		$result = $this->db->insert('master_menus',$obj);
		$id = $this->db->insert_id();

		if ($this->db->trans_status() === FALSE)
		{
		    $this->db->trans_rollback();
		    return "gagal";
		}
		else
		{
			
		    $this->db->trans_commit();
		    return $id;
		}
	}

	public function findby_pk($id){
		$sql = "select * from master_menus where menu_id = ".$id;
		$result = $this->db->query($sql)->row();
		print json_encode($result);
	}

	public function check_unique_code($id){
		$sql = "select count(menu_code) as total from master_menus where menu_code = '$id'";
		$result = $this->db->query($sql)->row();

		return $result->total;
	}

	public function check_unique_uptd($id){
		$sql = "select count(menu_code) as total from master_menus 
		 where menu_code = '$id' and
		  menu_code <> '$id' ";
		$result = $this->db->query($sql)->row();

		return $result->total;
	}

	public function get_package_data($id){
		$sql = "select m.*,p.qty from master_menus m 
		inner join master_menu_packages p on (m.menu_id = p.menu_id) where p.package_id = ".$id;
		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function find_menu_compositions($id)
	{
		$sql = "SELECT A.*, B.product_name, B.unit_small, B.is_active 
				FROM `master_menu_compositions` A INNER JOIN `master_products` B ON A.product_id = B.product_id 
				WHERE A.menu_id = ".$id;
		$result =  $this->db->query($sql)->result();
		echo json_encode($result);
	}



	function find_menu_package_compositions($id)
	{
		$sql = "SELECT C.product_id, D.product_code, D.product_name, unit_small, SUM(MENU.qty * qty_dynein) AS qty_dynein, SUM(MENU.qty * qty_deltak) AS qty_deltak, D.is_active
				FROM (SELECT A.menu_id AS `package_id`
							  , CASE WHEN B.menu_id IS NULL THEN A.menu_id ELSE B.menu_id END AS `menu_id`
							, CASE WHEN B.menu_id IS NULL THEN 1 ELSE B.qty END AS `qty`
					FROM `master_menus` A LEFT JOIN `master_menu_packages` B ON A.menu_id = B.package_id
					WHERE A.menu_id = ".$id.") MENU INNER JOIN `master_menu_compositions` C ON MENU.menu_id = C.menu_id
							INNER JOIN `master_products` D ON C.product_id = D.product_id
				GROUP BY C.product_id, D.product_code, D.product_name, unit_small";
		$result =  $this->db->query($sql)->result();
		echo json_encode($result);
	}



public function update_comp_package(){
		$json = $this->input->post('json');
		$menu_id = $this->input->post('package_id');
		$obj = json_decode($json);
		$this->db->trans_begin();

		//delete data sebelumnya
		$this->db->where('menu_id',$menu_id);
		$this->db->delete('master_menu_compositions');
		foreach ($obj as $detail) {
			$package_detail = array(
				'menu_id' => $menu_id, 
				'product_id' => $detail->product_id, 
				'qty_dynein' => $detail->qty_dynein,
				'qty_deltak' => $detail->qty_deltak
				);
			$this->db->insert('master_menu_compositions',$package_detail);
		}
		$this->histories('update composition menu');

		if ($this->db->trans_status() === FALSE)
		{
		    $this->db->trans_rollback();
		    echo "gagal";
		}
		else
		{
			
		    $this->db->trans_commit();
		    echo "ok";
		}
	}

	public function update_item_package(){
		$json = $this->input->post('json');
		$menu_id = $this->input->post('package_id');
		$obj = json_decode($json);
		$this->db->trans_begin();

		//delete data sebelumnya
		$this->db->where('package_id',$menu_id);
		$this->db->delete('master_menu_packages');
		foreach ($obj as $detail) {
			$package_detail = array(
				'package_id' => $menu_id, 
				'menu_id' => $detail->menu_id, 
				'qty' => $detail->qty
				);
			$this->db->insert('master_menu_packages',$package_detail);
		}
		$this->histories('update package menu');

		if ($this->db->trans_status() === FALSE)
		{
		    $this->db->trans_rollback();
		    echo "gagal";
		}
		else
		{
			
		    $this->db->trans_commit();
		    echo "ok";
		}
	}


	function histories($treatment){
		$log_history = array('treatment' =>$treatment ,'date_time' =>date("Y-m-d H:i:s"),'author_id'=>$this->session->userdata('author_id'),
				'datatable'=>'Menu');
				$this->db->insert('log_history',$log_history);
	}



} ?>