<?php /**
* 
*/
class Product_Groups extends CI_Controller
{
	function index()
	{
		$result = $this->find_all();
		echo json_encode($result);
	}

	function create()
	{
		try {
			$data = json_decode(file_get_contents('php://input'));
			if(isset($data->ProductGroups))
			{
				$data = $data->ProductGroups;
				$result = $this->db->insert('master_product_groups',$data);
				$result = $this->findby_pk($this->db->insert_id());
				$this->histories('create');
				echo '{"success":{"msg":"Data group produk BERHASIL disimpan !"}, "groups":'.json_encode($result).'}';
			}
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menyimpan data group produk !", "text":'. $e->getMessage() .'}}';
		}
	}

	function update($id)
	{
		try {
			$data = json_decode(file_get_contents('php://input'));
			if(isset($data->ProductGroups))
			{
				$data = $data->ProductGroups;
				$this->db->where('group_id', $id);
				$result = $this->db->update('master_product_groups',$data);
				$result = $this->findby_pk($id);
				$this->histories('update');

				echo '{"success":{"msg":"Data group produk BERHASIL disimpan !"}, "groups":'.json_encode($result).'}';
			} else {
				$result = $this->findby_pk($id);
				echo json_encode($result);
			}
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menyimpan data group produk !", "text":'. $e->getMessage() .'}}';
		}
	}

	function delete($id)
	{
		try {
			$this->db->where('group_id', $id);
			$this->db->delete('master_product_groups');
			$this->histories('delete');
			$result = $this->find_all();
			echo json_encode($result);
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menghapus data group produk !", "text":'. $e->getMessage() .'}}';
		}
	}
	
	function view($id)
	{
		try {
			$result = $this->findby_pk($id);
			echo json_encode($result);
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL mengambil data group produk !", "text":'. $e->getMessage() .'}}';
		}
	}
	
	function find_all()
	{
		$sql = "select * from master_product_groups";
		return $this->db->query($sql)->result();
	}

	function findby_pk($id)
	{
		$id_ = addslashes($id);
		$sql = "select * from master_product_groups where group_id= ".$id_;
		return $this->db->query($sql)->result();
	}

	function histories($treatment){
		$log_history = array('treatment' =>$treatment ,'date_time' =>date("Y-m-d H:i:s"),'author_id'=>$this->session->userdata('author_id'),
				'datatable'=>'ProductGroups');
				$this->db->insert('log_history',$log_history);
	}

} ?>