<?php /**
* 
*/
class Sales extends CI_Controller
{
	function index()
	{
		$data = json_decode(file_get_contents('php://input'));
		if(isset($data->Reports))
		{
			if($data->Reports->viewtype == 'total')
				$this->viewTotal($data->Reports);
			else if($data->Reports->viewtype == 'monthly')
				$this->viewMonthly($data->Reports);
			else
				$this->viewDaily($data->Reports);
		}
	}

	function runQuery($_sql, $data)
	{
		$sql = "SELECT B.outlets_id, B.other_code AS `outlets_code`, B.outlets_name, SUM(A.JmlPenjualan) AS `total` ".$_sql."
				FROM `outlet_sales_orders` A INNER JOIN `master_outlets` B ON A.KdOutlet = B.other_code
				WHERE A.SdhBayar = 'T' AND A.tglClosing BETWEEN '".$data->periode_start."' AND '".$data->periode_end."' ".(isset($data->outlet_id) ? " AND B.outlets_id = ".$data->outlet_id : '')." 
				GROUP BY B.outlets_id, B.other_code, B.outlets_name
				ORDER BY B.outlets_name";
		return $this->db->query($sql)->result();
	}
	
	function viewTotal($data)
	{
		$result = $this->runQuery('', $data);
		echo json_encode(array('fields'=>array(), 'field_values'=>$result));
	}
	
	function viewMonthly($data)
	{
		$start = new DateTime($data->periode_start);
		$end = new DateTime($data->periode_end);

		$_newDate = new DateTime($start->format('Y').'-'.$start->format('m').'-01');
		$fields = array();
		$sql = '';
		while($_newDate <= $end)
		{
			$fields[] = $_newDate->format('Ym');
			$sql .= ", SUM(CASE WHEN DATE_FORMAT(A.tglClosing,'%Y%m') = '".$_newDate->format('Ym')."' THEN A.JmlPenjualan ELSE 0 END) AS `q".$_newDate->format('Ym')."`";
			$_newDate->add(new DateInterval("P1M"));
		}
		
		$result = $this->runQuery($sql, $data);
		echo json_encode(array('fields'=>$fields, 'field_values'=>$result));
	}
	
	function viewDaily($data)
	{
		$start = new DateTime($data->periode_start);
		$end = new DateTime($data->periode_end);

		$_newDate = clone $start;
		$fields = array();
		$sql = '';
		while($_newDate <= $end)
		{
			$fields[] = $_newDate->format('Ymd');
			$sql .= ", SUM(CASE WHEN DATE_FORMAT(A.tglClosing,'%Y%m%d') = '".$_newDate->format('Ymd')."' THEN A.JmlPenjualan ELSE 0 END) AS `q".$_newDate->format('Ymd')."`";
			$_newDate->add(new DateInterval("P1D"));
		}
		
		$result = $this->runQuery($sql, $data);
		echo json_encode(array('fields'=>$fields, 'field_values'=>$result));
	}
} ?>