<?php /**
* 
*/
class Opnames extends CI_Controller
{
	function index()
	{
		$outlet_id = $this->session->userdata('outlet_id')*1;
		if(is_int($outlet_id) && $outlet_id > 0)
			$result = $this->find_all_byoutlet($outlet_id);
		else 
			$result = $this->find_all();
		echo json_encode($result);
	}

	function create()
	{
		try {
			$data = json_decode(file_get_contents('php://input'));
			if(isset($data->opname))
			{
				$data = $data->opname;
				$data->code = $this->genOpnameCode($data->outlet_id);
				$data->author_id = 1;
				$data->created_at = date('Y-m-d H:i:s');
				$this->db->insert('outlet_stock_opnames',$data);
				$id = $this->db->insert_id();
				$opname = $this->findby_pk($id);
				$this->genOpnameDetails($opname[0]);
				echo json_encode(array('opname'=>$opname, 'details'=>$this->findDetails($id)));
			}
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menyimpan data produk !", "text":'. $e->getMessage() .'}}';
		}
	}

	function update($id)
	{
		try {
			$data = json_decode(file_get_contents('php://input'));
			if(isset($data->opname))
			{
				$data = $data->Products;
				$this->db->where('product_id', $id);
				$this->db->update('master_products',$data);
				$result = $this->findby_pk($id);
				echo '{"success":{"msg":"Data produk BERHASIL disimpan !"}, "produk":'.json_encode($result).'}';
			} else {
				$result = $this->findby_pk($id);
				echo json_encode(array('opname'=>$result, 'details'=>$this->findDetails($id)));
			}
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menyimpan data produk !", "text":'. $e->getMessage() .'}}';
		}
	}

	function delete($id)
	{
		try {
			$this->db->where('product_id', $id);
			$this->db->update('master_products');
			
			$result = $this->find_all();
			echo json_encode($result);
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menghapus data produk !", "text":'. $e->getMessage() .'}}';
		}
	}
	
	function view($id)
	{
		try {
			echo json_encode(array(
					'opname' => $this->findby_pk($id),
					'details' => $this->findDetails($id),
				));
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL mengambil data stock opname !", "text":'. $e->getMessage() .'}}';
		}
	}
	
	function find_all()
	{
		$sql = "SELECT A.*, B.outlets_name, C.full_name 
				FROM outlet_stock_opnames A INNER JOIN master_outlets B ON A.outlet_id = B.outlets_id
					INNER JOIN user_apps C ON A.author_id = C.id
				ORDER BY A.id DESC";
		return $this->db->query($sql)->result();
	}
	
	function find_all_byoutlet($oid)
	{
		$sql = "SELECT * FROM outlet_stock_opnames A INNER JOIN user_apps B ON A.author_id = B.id WHERE A.outlet_id = ".$oid;
		return $this->db->query($sql)->result();
	}

	function findby_pk($id)
	{
		$id_ = addslashes($id);
		$sql = "SELECT A.*, B.full_name FROM outlet_stock_opnames A INNER JOIN user_apps B ON A.author_id = B.id WHERE A.id = ".$id_;
		return $this->db->query($sql)->result();
	}
	
	function findDetails($id)
	{
		$id_ = addslashes($id);
		$sql = "SELECT A.*, B.product_code, B.product_name 
				FROM outlet_stock_opname_details A INNER JOIN `master_products` B ON A.product_id = B.product_id 
				WHERE opname_id = ".$id_;
		return $this->db->query($sql)->result();
	}
	
	function getOutletCode($oid)
	{
		$id_ = addslashes($oid);
		$sql = "select * from master_outlets WHERE outlets_id = ".$id_;
		$result = $this->db->query($sql)->result();
		return count($result) > 0 ? $result[0]->outlets_code : 'STO';
	}
	
	function getperiode()
	{
		$data = json_decode(file_get_contents('php://input'));
		if(isset($data->outlet_id) && $data->outlet_id > 0)
		{
			$sql = "CALL sp_stock_opname_periode (".$data->outlet_id.")";
			$result = $this->db->query($sql)->result();
			echo json_encode(array('periode_start'=>$result[0]->start, 'periode_end'=>$result[0]->end));
		} else {
			echo '{"error":{"msg":"Anda belum memilih outlet !"}}';
		}
	}
	
	function genOpnameCode($oid)
	{
		$sql = "SELECT MAX(RIGHT(`code`, 5)) AS last_number
				FROM `outlet_stock_opnames`
				WHERE outlet_id = ".$oid;
		$result = $this->db->query($sql)->result();
		
		if(count($result) > 0)
		{
			$last_number = ($result[0]->last_number * 1) + 1;
		} else {
			$last_number = 1;
		}
		return $this->getOutletCode($oid).str_pad($last_number, 5, '0', STR_PAD_LEFT);
	}
	
	function genOpnameDetails($opname)
	{
		$sql = "CALL sp_stock_opname (".$opname->outlet_id.", '".$opname->periode_start."', '".$opname->periode_end."', ".$opname->id.")";
		return $this->db->query($sql)->result();
	}
} ?>